/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.beans.Introspector;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.TypeKind;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorOrderAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRootElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSeeAlsoAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTransientAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaClassMappingTests
extends JaxbContextModelTestCase {
    public GenericJavaClassMappingTests(String name) {
        super(name);
    }

    private void createTestSubType() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    private ICompilationUnit createXmlTypeWithAccessorType() throws CoreException {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlAccessorType(value = XmlAccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createXmlTypeWithAccessorOrder() throws CoreException {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAccessOrder", "javax.xml.bind.annotation.XmlAccessorOrder"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
                sb.append("@XmlAccessorOrder(value = XmlAccessOrder.ALPHABETICAL)");
            }
        });
    }

    private ICompilationUnit createPackageInfoWithAccessorType() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorType(value = XmlAccessType.PROPERTY)", new String[]{"javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
    }

    private void createTestXmlTypeWithFieldAndPublicMemberAccess() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int foo;").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyAndPublicMemberAccess() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append("    public void setFoo(int foo) {}").append(CR).append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyGetterAndPublicMemberAccess() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public int getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertyGetterListAndPublicMemberAccess() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public List<?> getFoo() {").append(CR);
                sb.append("        return 1;").append(CR).append("    }").append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestXmlTypeWithPropertySetterAndPublicMemberAccess() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlType");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlAttribute");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.xml.bind.annotation.XmlTransient");
                sb.append(";");
                sb.append(CR);
                sb.append("import java.util.List;");
                sb.append(CR);
                sb.append("@XmlType");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" ");
                sb.append("{").append(CR);
                sb.append("    public void setFoo(int foo) {}").append(CR).append(CR);
                sb.append(CR).append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createXmlTypeWithVariousFieldsAndProperties() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.xml.bind.annotation.XmlTransient").append(";").append(CR);
                sb.append("@XmlTransient").append(CR);
                sb.append("public class ").append("AnnotationTestType").append(" {").append(CR);
                sb.append("    public String publicField;").append(CR);
                sb.append("    protected String protectedField;").append(CR);
                sb.append("    public String getPublicProperty() { return null; }").append(CR);
                sb.append("    public void setPublicProperty(String string) {}").append(CR);
                sb.append("    protected String getProtectedProperty() { return null; }").append(CR);
                sb.append("    protected void setProtectedProperty(String string) {}").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    protected void addXmlTypeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, value);
    }

    protected void addXmlTypeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlTypeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected Annotation getXmlTypeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlType");
    }

    public void testTypeKind() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((Object)TypeKind.CLASS, (Object)classMapping.getTypeKind());
    }

    public void testModifyXmlTransient() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlTransientAnnotation annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertFalse((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
        classMapping.setXmlTransient(true);
        annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertTrue((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNotNull((Object)annotation);
        classMapping.setXmlTransient(false);
        annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertFalse((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlTransient() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlTransientAnnotation annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertFalse((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertTrue((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlTransient");
            }
        });
        annotation = (XmlTransientAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlTransient");
        GenericJavaClassMappingTests.assertFalse((boolean)classMapping.isXmlTransient());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testModifyQNameName() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getDefaultName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getName());
        classMapping.getQName().setSpecifiedName("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getName());
        classMapping.getQName().setSpecifiedName(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertNull((Object)xmlTypeAnnotation.getName());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getName());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        classMapping.getQName().setSpecifiedName("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getName());
    }

    public void testUpdateQNameName() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        String defaultXmlTypeName = Introspector.decapitalize("AnnotationTestType");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getDefaultName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addXmlTypeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaClassMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaClassMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedName());
        GenericJavaClassMappingTests.assertEquals((String)defaultXmlTypeName, (String)classMapping.getQName().getName());
    }

    public void testModifyQNameNamespace() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getDefaultNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getNamespace());
        classMapping.getQName().setSpecifiedNamespace("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getNamespace());
        classMapping.getQName().setSpecifiedNamespace(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertNull((Object)xmlTypeAnnotation.getNamespace());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getNamespace());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        classMapping.getQName().setSpecifiedNamespace("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getNamespace());
    }

    public void testUpdateQNameNamespace() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getDefaultNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addXmlTypeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaClassMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaClassMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getQName().getSpecifiedNamespace());
        GenericJavaClassMappingTests.assertEquals((String)"", (String)classMapping.getQName().getNamespace());
    }

    public void testModifyXmlRootElement() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlRootElement());
        classMapping.addXmlRootElement().getQName().setSpecifiedName("foo");
        XmlRootElementAnnotation xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlRootElementAnnotation.getName());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getXmlRootElement().getQName().getName());
        classMapping.removeXmlRootElement();
        xmlRootElementAnnotation = (XmlRootElementAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRootElement");
        GenericJavaClassMappingTests.assertNull((Object)xmlRootElementAnnotation);
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlRootElement());
    }

    public void testUpdateXmlRootElement() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlRootElement());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = GenericJavaClassMappingTests.this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlRootElement");
                GenericJavaClassMappingTests.this.addMemberValuePair(annotation, "name", "foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getXmlRootElement().getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlRootElement");
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlRootElement());
    }

    public void testModifyXmlSeeAlso() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
        classMapping.addXmlSeeAlso();
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNotNull((Object)annotation);
        classMapping.removeXmlSeeAlso();
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testUpdateXmlSeeAlso() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        XmlSeeAlsoAnnotation annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNotNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNotNull((Object)annotation);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSeeAlso");
            }
        });
        annotation = (XmlSeeAlsoAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlSeeAlso");
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getXmlSeeAlso());
        GenericJavaClassMappingTests.assertNull((Object)annotation);
    }

    public void testModifyFactoryClass() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"javax.xml.bind.annotation.XmlType.DEFAULT", (String)classMapping.getFactoryClass());
        classMapping.setSpecifiedFactoryClass("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getFactoryClass());
        classMapping.setSpecifiedFactoryClass(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertNull((Object)xmlTypeAnnotation.getFactoryClass());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"javax.xml.bind.annotation.XmlType.DEFAULT", (String)classMapping.getFactoryClass());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        classMapping.setSpecifiedFactoryClass("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getFactoryClass());
    }

    public void testUpdateFactoryClass() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"javax.xml.bind.annotation.XmlType.DEFAULT", (String)classMapping.getFactoryClass());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addXmlTypeTypeMemberValuePair(declaration, "factoryClass", "Foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((String)"Foo", (String)classMapping.getFactoryClass());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaClassMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaClassMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedFactoryClass());
        GenericJavaClassMappingTests.assertEquals((String)"javax.xml.bind.annotation.XmlType.DEFAULT", (String)classMapping.getFactoryClass());
    }

    public void testModifyFactoryMethod() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getFactoryMethod());
        classMapping.setFactoryMethod("foo");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getFactoryMethod());
        classMapping.setFactoryMethod(null);
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertNull((Object)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getFactoryMethod());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlType");
        classMapping.setFactoryMethod("foo");
        xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)xmlTypeAnnotation.getFactoryMethod());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getFactoryMethod());
    }

    public void testUpdateFactoryMethod() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getFactoryMethod());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addXmlTypeMemberValuePair(declaration, "factoryMethod", "foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)classMapping.getFactoryMethod());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation xmlTypeAnnotation = (NormalAnnotation)GenericJavaClassMappingTests.this.getXmlTypeAnnotation(declaration);
                GenericJavaClassMappingTests.this.values(xmlTypeAnnotation).remove(0);
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getFactoryMethod());
    }

    public void testModifyAccessType() throws Exception {
        this.createXmlTypeWithAccessorType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)classMapping.getSpecifiedAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)classMapping.getAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getDefaultAccessType());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        XmlAccessorTypeAnnotation accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaClassMappingTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.FIELD, (Object)accessorTypeAnnotation.getValue());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.FIELD, (Object)classMapping.getAccessType());
        classMapping.setSpecifiedAccessType(XmlAccessType.PUBLIC_MEMBER);
        GenericJavaClassMappingTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.PUBLIC_MEMBER, (Object)accessorTypeAnnotation.getValue());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getAccessType());
        classMapping.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaClassMappingTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType.NONE, (Object)accessorTypeAnnotation.getValue());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.NONE, (Object)classMapping.getAccessType());
        classMapping.setSpecifiedAccessType(null);
        accessorTypeAnnotation = (XmlAccessorTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        GenericJavaClassMappingTests.assertNull((Object)accessorTypeAnnotation.getValue());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getDefaultAccessType());
    }

    public void testUpdateAccessType() throws Exception {
        this.createXmlTypeWithAccessorType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)classMapping.getSpecifiedAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)classMapping.getAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getDefaultAccessType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.FIELD");
            }
        });
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.FIELD, (Object)classMapping.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
            }
        });
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", "javax.xml.bind.annotation.XmlAccessType.NONE");
            }
        });
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.NONE, (Object)classMapping.getAccessType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorType");
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getAccessType());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getDefaultAccessType());
    }

    public void testGetDefaultAccessType() throws Exception {
        this.createClassWithXmlType();
        this.createTestSubType();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaClass childJaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestTypeChild");
        JavaClassMapping childClassMapping = childJaxbClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)childClassMapping.getDefaultAccessType());
        this.createPackageInfoWithAccessorType();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)childClassMapping.getDefaultAccessType());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.FIELD, (Object)childClassMapping.getDefaultAccessType());
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        classMapping.setSpecifiedAccessType(null);
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)childClassMapping.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.FIELD, (Object)childClassMapping.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.NONE, (Object)childClassMapping.getDefaultAccessType());
        contextPackageInfo.setSpecifiedAccessType(null);
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)childClassMapping.getDefaultAccessType());
    }

    public void testModifyAccessOrder() throws Exception {
        this.createXmlTypeWithAccessorOrder();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)classMapping.getSpecifiedAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)classMapping.getAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getDefaultAccessOrder());
        classMapping.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        XmlAccessorOrderAnnotation accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaClassMappingTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.resource.java.XmlAccessOrder.UNDEFINED, (Object)accessorOrderAnnotation.getValue());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getAccessOrder());
        classMapping.setSpecifiedAccessOrder(null);
        accessorOrderAnnotation = (XmlAccessorOrderAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlAccessorOrder");
        GenericJavaClassMappingTests.assertNull((Object)accessorOrderAnnotation.getValue());
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getDefaultAccessOrder());
    }

    public void testUpdateAccessOrder() throws Exception {
        this.createXmlTypeWithAccessorOrder();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)classMapping.getSpecifiedAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)classMapping.getAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getDefaultAccessOrder());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorOrder", "javax.xml.bind.annotation.XmlAccessOrder.UNDEFINED");
            }
        });
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getAccessOrder());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAccessorOrder");
            }
        });
        GenericJavaClassMappingTests.assertNull((Object)classMapping.getSpecifiedAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getAccessOrder());
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)classMapping.getDefaultAccessOrder());
    }

    public void testGetPropOrder() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ListIterator props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addProp(declaration, 0, "bar");
                GenericJavaClassMappingTests.this.addProp(declaration, 1, "foo");
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
    }

    public void testGetPropOrderSize() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getPropOrderSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addProp(declaration, 0, "bar");
                GenericJavaClassMappingTests.this.addProp(declaration, 1, "foo");
            }
        });
        GenericJavaClassMappingTests.assertEquals((int)2, (int)classMapping.getPropOrderSize());
    }

    public void testAddProp() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        classMapping.addProp(0, "bar");
        classMapping.addProp(0, "foo");
        classMapping.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
    }

    public void testAddProp2() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        classMapping.addProp(0, "bar");
        classMapping.addProp(1, "foo");
        classMapping.addProp(0, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        ListIterator props = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
    }

    public void testRemoveProp() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        classMapping.addProp(0, "bar");
        classMapping.addProp(1, "foo");
        classMapping.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        classMapping.removeProp(1);
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)resourceProps.hasNext());
        classMapping.removeProp(1);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)resourceProps.hasNext());
        classMapping.removeProp(0);
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertFalse((boolean)resourceProps.hasNext());
    }

    public void testMoveProp() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        classMapping.addProp(0, "bar");
        classMapping.addProp(1, "foo");
        classMapping.addProp(2, "baz");
        XmlTypeAnnotation xmlTypeAnnotation = (XmlTypeAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlType");
        GenericJavaClassMappingTests.assertEquals((int)3, (int)xmlTypeAnnotation.getPropOrderSize());
        classMapping.moveProp(2, 0);
        ListIterator props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        ListIterator resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
        classMapping.moveProp(0, 1);
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        resourceProps = xmlTypeAnnotation.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)resourceProps.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)resourceProps.next()));
    }

    public void testSyncProps() throws Exception {
        this.createClassWithXmlType();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        ListIterator props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addProp(declaration, 0, "bar");
                GenericJavaClassMappingTests.this.addProp(declaration, 1, "foo");
                GenericJavaClassMappingTests.this.addProp(declaration, 2, "baz");
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertTrue((boolean)props.hasNext());
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.moveProp(declaration, 2, 0);
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertTrue((boolean)props.hasNext());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.moveProp(declaration, 0, 1);
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertTrue((boolean)props.hasNext());
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeProp(declaration, 1);
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertTrue((boolean)props.hasNext());
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertEquals((String)"bar", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeProp(declaration, 1);
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertTrue((boolean)props.hasNext());
        GenericJavaClassMappingTests.assertEquals((String)"baz", (String)((String)props.next()));
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeProp(declaration, 0);
            }
        });
        props = classMapping.getPropOrder().iterator();
        GenericJavaClassMappingTests.assertFalse((boolean)props.hasNext());
    }

    protected void addProp(ModifiedDeclaration declaration, int index, String prop) {
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlType", index, "propOrder", (Expression)this.newStringLiteral(declaration.getAst(), prop));
    }

    protected void removeProp(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", index);
    }

    protected void moveProp(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)this.getXmlTypeAnnotation(declaration), "propOrder", targetIndex, sourceIndex);
    }

    public void testGetSuperclass() throws Exception {
        this.createClassWithXmlType();
        this.createTestSubType();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JavaClass childJaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestTypeChild");
        JavaClassMapping childClassMapping = childJaxbClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((Object)classMapping, (Object)childClassMapping.getSuperclass());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)jaxbClass.getJavaResourceType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlType");
            }
        });
        GenericJavaClassMappingTests.assertEquals((Object)classMapping, (Object)childClassMapping.getSuperclass());
    }

    public void testUpdateFieldAttributes() throws Exception {
        this.createTestXmlTypeWithFieldAndPublicMemberAccess();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        this.publicFieldTest(classMapping);
        this.publicTransientFieldTest(classMapping);
        this.publicStaticFieldTest(classMapping);
        this.publicFinalFieldTest(classMapping);
        this.publicStaticFinalFieldTest(classMapping);
        this.privateFieldTest(classMapping);
        this.privateTransientFieldTest(classMapping);
        this.privateStaticFieldTest(classMapping);
        this.privateStaticFinalFieldTest(classMapping);
    }

    protected void publicFieldTest(JavaClassMapping classMapping) {
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        Iterator attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)classMapping.getAttributes().iterator().next()).getJavaResourceAttribute();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlTransient");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlTransient");
            }
        });
    }

    protected void publicTransientFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
    }

    protected void publicStaticFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    protected void publicFinalFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    protected void publicStaticFinalFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    protected void privateFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateTransientFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateStaticFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void privateStaticFinalFieldTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        JavaResourceField resourceField = (JavaResourceField)((JavaPersistentAttribute)attributes.next()).getJavaResourceAttribute();
        this.removeModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceField, Modifier.ModifierKeyword.PRIVATE_KEYWORD, Modifier.ModifierKeyword.STATIC_KEYWORD, Modifier.ModifierKeyword.FINAL_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceField);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdatePropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyAndPublicMemberAccess();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        this.publicGetterSetterTest(classMapping);
        this.publicStaticGetterSetterTest(classMapping);
        this.privateGetterSetterTest(classMapping);
    }

    public void testUpdateGetterPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyGetterAndPublicMemberAccess();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)classMapping.getJavaType().getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        Iterator attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdateSetterPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertySetterAndPublicMemberAccess();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)classMapping.getJavaType().getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        Iterator attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    public void testUpdateGetterListPropertyAttributes() throws Exception {
        this.createTestXmlTypeWithPropertyGetterListAndPublicMemberAccess();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        Iterator attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)classMapping.getJavaType().getJavaResourceType().getMethods().iterator().next();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    protected void publicGetterSetterTest(JavaClassMapping classMapping) {
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        Iterator attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        JavaResourceMethod resourceMethod = (JavaResourceMethod)((JavaPersistentAttribute)classMapping.getAttributes().iterator().next()).getJavaResourceAttribute();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMethod);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
    }

    protected void publicStaticGetterSetterTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        PropertyAccessor propertyAccessor = (PropertyAccessor)ObjectTools.get(attributes.next(), (String)"accessor");
        JavaResourceMethod resourceGetter = propertyAccessor.getResourceGetterMethod();
        JavaResourceMethod resourceSetter = propertyAccessor.getResourceSetterMethod();
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceGetter);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    protected void privateGetterSetterTest(JavaClassMapping classMapping) {
        Iterator attributes = classMapping.getAttributes().iterator();
        PropertyAccessor propertyAccessor = (PropertyAccessor)ObjectTools.get(attributes.next(), (String)"accessor");
        JavaResourceMethod resourceGetter = propertyAccessor.getResourceGetterMethod();
        JavaResourceMethod resourceSetter = propertyAccessor.getResourceSetterMethod();
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getAttributesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceGetter);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PROPERTY");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.FIELD");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.NONE");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        this.setAccessTypeInJavaSource(classMapping, "javax.xml.bind.annotation.XmlAccessType.PUBLIC_MEMBER");
        GenericJavaClassMappingTests.assertEquals((int)1, (int)classMapping.getAttributesSize());
        attributes = classMapping.getAttributes().iterator();
        GenericJavaClassMappingTests.assertEquals((String)"foo", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaClassMappingTests.assertFalse((boolean)attributes.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlAttribute");
            }
        });
        this.removeModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.removeModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceGetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        this.addModifiers((JavaResourceMember)resourceSetter, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    protected void addModifiers(JavaResourceMember resourceMember, final Modifier.ModifierKeyword ... modifiers) {
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMember);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.addModifiers((BodyDeclaration)declaration.getDeclaration(), modifiers);
            }
        });
    }

    protected void removeModifiers(JavaResourceMember resourceMember, final Modifier.ModifierKeyword ... modifiers) {
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceMember);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.removeModifiers((BodyDeclaration)declaration.getDeclaration(), modifiers);
            }
        });
    }

    protected void addModifiers(BodyDeclaration bodyDeclaration, Modifier.ModifierKeyword ... modifiers) {
        Modifier.ModifierKeyword[] modifierKeywordArray = modifiers;
        int n = modifiers.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier.ModifierKeyword modifier = modifierKeywordArray[n2];
            this.modifiers(bodyDeclaration).add((IExtendedModifier)bodyDeclaration.getAST().newModifier(modifier));
            ++n2;
        }
    }

    protected void removeModifiers(BodyDeclaration bodyDeclaration, Modifier.ModifierKeyword ... modifierKeywords) {
        Modifier.ModifierKeyword[] modifierKeywordArray = modifierKeywords;
        int n = modifierKeywords.length;
        int n2 = 0;
        while (n2 < n) {
            Modifier.ModifierKeyword modifierKeyWord = modifierKeywordArray[n2];
            Iterator<IExtendedModifier> stream = this.modifiers(bodyDeclaration).iterator();
            while (stream.hasNext()) {
                IExtendedModifier modifier = stream.next();
                if (!modifier.isModifier() || ((Modifier)modifier).getKeyword() != modifierKeyWord) continue;
                stream.remove();
                break;
            }
            ++n2;
        }
    }

    protected List<IExtendedModifier> modifiers(BodyDeclaration bodyDeclaration) {
        return bodyDeclaration.modifiers();
    }

    protected void setAccessTypeInJavaSource(JavaClassMapping classMapping, final String accessType) {
        JavaResourceType resourceClass = classMapping.getJavaType().getJavaResourceType();
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceClass);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaClassMappingTests.this.setEnumMemberValuePair(declaration, "javax.xml.bind.annotation.XmlAccessorType", accessType);
            }
        });
    }

    public void testUpdateIncludedAttributes() throws Exception {
        this.createXmlTypeWithVariousFieldsAndProperties();
        this.createTestSubType();
        JavaClass javaClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestTypeChild");
        JavaClassMapping classMapping = javaClass.getMapping();
        GenericJavaClassMappingTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)classMapping.getAccessType());
        GenericJavaClassMappingTests.assertEquals((int)2, (int)classMapping.getIncludedAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"publicField", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)0)).getName());
        GenericJavaClassMappingTests.assertEquals((String)"publicProperty", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)1)).getName());
        classMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        GenericJavaClassMappingTests.assertEquals((int)2, (int)classMapping.getIncludedAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"publicField", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)0)).getName());
        GenericJavaClassMappingTests.assertEquals((String)"protectedField", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)1)).getName());
        classMapping.setSpecifiedAccessType(XmlAccessType.PROPERTY);
        GenericJavaClassMappingTests.assertEquals((int)2, (int)classMapping.getIncludedAttributesSize());
        GenericJavaClassMappingTests.assertEquals((String)"publicProperty", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)0)).getName());
        GenericJavaClassMappingTests.assertEquals((String)"protectedProperty", (String)((JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getIncludedAttributes(), (int)1)).getName());
        classMapping.setSpecifiedAccessType(XmlAccessType.NONE);
        GenericJavaClassMappingTests.assertEquals((int)0, (int)classMapping.getIncludedAttributesSize());
    }
}

