/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbEnumConstant;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnum;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnumMapping;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumValueAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaEnumConstantTests
extends JaxbContextModelTestCase {
    public GenericJavaEnumConstantTests(String name) {
        super(name);
    }

    private ICompilationUnit createEnumWithXmlEnum() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType"});
            }

            public void appendEnumAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
            }
        });
    }

    public void testUpdateName() throws Exception {
        this.createEnumWithXmlEnum();
        JavaEnum jaxbEnum = (JavaEnum)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaEnumMapping enumMapping = jaxbEnum.getMapping();
        JaxbEnumConstant contextEnumConstant = (JaxbEnumConstant)IterableTools.get((Iterable)enumMapping.getEnumConstants(), (int)1);
        JavaResourceEnum resourceEnum = jaxbEnum.getJavaResourceType();
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnum);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumConstantTests.this.changeEnumConstantName((EnumDeclaration)declaration.getDeclaration(), "MONDAY", "MONDAY2");
            }
        });
        contextEnumConstant = (JaxbEnumConstant)IterableTools.get((Iterable)enumMapping.getEnumConstants(), (int)1);
        GenericJavaEnumConstantTests.assertEquals((int)2, (int)enumMapping.getEnumConstantsSize());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY2", (String)contextEnumConstant.getName());
    }

    public void testModifyValue() throws Exception {
        this.createEnumWithXmlEnum();
        JavaEnum jaxbEnum = (JavaEnum)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaEnumMapping enumMapping = jaxbEnum.getMapping();
        JaxbEnumConstant contextEnumConstant = (JaxbEnumConstant)IterableTools.get((Iterable)enumMapping.getEnumConstants(), (int)1);
        JavaResourceEnumConstant resourceEnumConstant = contextEnumConstant.getResourceEnumConstant();
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertNull((Object)contextEnumConstant.getSpecifiedValue());
        contextEnumConstant.setSpecifiedValue("foo");
        XmlEnumValueAnnotation enumValueAnnotation = (XmlEnumValueAnnotation)resourceEnumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        GenericJavaEnumConstantTests.assertEquals((String)"foo", (String)enumValueAnnotation.getValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"foo", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertEquals((String)"foo", (String)contextEnumConstant.getSpecifiedValue());
        contextEnumConstant.setSpecifiedValue(null);
        enumValueAnnotation = (XmlEnumValueAnnotation)resourceEnumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        GenericJavaEnumConstantTests.assertNull((Object)enumValueAnnotation.getValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertNull((Object)contextEnumConstant.getSpecifiedValue());
    }

    public void testUpdateValue() throws Exception {
        this.createEnumWithXmlEnum();
        JavaEnum jaxbEnum = (JavaEnum)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaEnumMapping enumMapping = jaxbEnum.getMapping();
        JaxbEnumConstant contextEnumConstant = (JaxbEnumConstant)IterableTools.get((Iterable)enumMapping.getEnumConstants(), (int)1);
        JavaResourceEnumConstant resourceEnumConstant = contextEnumConstant.getResourceEnumConstant();
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertNull((Object)contextEnumConstant.getSpecifiedValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceEnumConstant);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation enumValueAnnotation = GenericJavaEnumConstantTests.this.addNormalAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlEnumValue");
                GenericJavaEnumConstantTests.this.addMemberValuePair(enumValueAnnotation, "value", "foo");
            }
        });
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"foo", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertEquals((String)"foo", (String)contextEnumConstant.getSpecifiedValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaEnumConstantTests.this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlEnumValue");
            }
        });
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getDefaultValue());
        GenericJavaEnumConstantTests.assertEquals((String)"MONDAY", (String)contextEnumConstant.getValue());
        GenericJavaEnumConstantTests.assertNull((Object)contextEnumConstant.getSpecifiedValue());
    }
}

