/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbElementFactoryMethod;
import org.eclipse.jpt.jaxb.core.context.XmlRegistry;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaRegistryTests
extends JaxbContextModelTestCase {
    public GenericJavaRegistryTests(String name) {
        super(name);
    }

    protected ICompilationUnit createClassWithXmlRegistryAndCreateMethods() throws Exception {
        return this.createTestType("test", "ObjectFactory.java", "ObjectFactory", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRegistry", "javax.xml.bind.annotation.XmlElementDecl", "javax.xml.bind.JAXBElement"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRegistry");
            }

            public void appendGetNameMethodAnnotationTo(StringBuilder sb) {
                sb.append("@XmlElementDecl(name=\"foo\")").append(CR);
                sb.append("    JAXBElement<AnnotationTestType> createFoo(AnnotationTestType value) {return null}").append(CR);
                sb.append(CR);
                sb.append("    @XmlElementDecl(name=\"bar\")").append(CR);
                sb.append("    JAXBElement createBar(Object value) {return null}").append(CR);
                sb.append(CR);
            }
        });
    }

    protected void addElementFactoryMethod(TypeDeclaration typeDeclaration, String methodName) {
        AST ast = typeDeclaration.getAST();
        MethodDeclaration methodDeclaration = this.newMethodDeclaration(ast, methodName);
        Block body = ast.newBlock();
        methodDeclaration.setBody(body);
        methodDeclaration.setReturnType2((Type)ast.newSimpleType(ast.newName("JAXBElement")));
        SingleVariableDeclaration parameter = ast.newSingleVariableDeclaration();
        parameter.setName(ast.newSimpleName("value"));
        parameter.setType((Type)ast.newSimpleType(ast.newName("Object")));
        this.parameters(methodDeclaration).add(parameter);
        NormalAnnotation elementDeclAnnotation = this.newNormalAnnotation(ast, "XmlElementDecl");
        this.modifiers(methodDeclaration).add((IExtendedModifier)elementDeclAnnotation);
        this.bodyDeclarations(typeDeclaration).add((BodyDeclaration)methodDeclaration);
    }

    protected MethodDeclaration newMethodDeclaration(AST ast, String methodName) {
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        methodDeclaration.setName(ast.newSimpleName(methodName));
        return methodDeclaration;
    }

    protected List<BodyDeclaration> bodyDeclarations(TypeDeclaration td) {
        return td.bodyDeclarations();
    }

    protected List<SingleVariableDeclaration> parameters(MethodDeclaration md) {
        return md.parameters();
    }

    protected List<IExtendedModifier> modifiers(MethodDeclaration md) {
        return md.modifiers();
    }

    protected void removeMethodDeclaration(TypeDeclaration typeDeclaration, String methodName) {
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration md = methodDeclarationArray[n2];
            if (md.getName().getFullyQualifiedName().equals(methodName)) {
                this.bodyDeclarations(typeDeclaration).remove(md);
                break;
            }
            ++n2;
        }
    }

    public void testUpdateElementFactoryMethods() throws Exception {
        this.createClassWithXmlType();
        this.createClassWithXmlRegistryAndCreateMethods();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.ObjectFactory");
        XmlRegistry contextRegistry = jaxbClass.getXmlRegistry();
        JavaResourceType resourceType = jaxbClass.getJavaResourceType();
        GenericJavaRegistryTests.assertEquals((int)2, (int)contextRegistry.getElementFactoryMethodsSize());
        Iterator elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        JaxbElementFactoryMethod elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createFoo", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"foo", (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getName());
        GenericJavaRegistryTests.assertFalse((boolean)elementFactoryMethods.hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceType);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaRegistryTests.this.addElementFactoryMethod((TypeDeclaration)declaration.getDeclaration(), "createFoo2");
                GenericJavaRegistryTests.this.addElementFactoryMethod((TypeDeclaration)declaration.getDeclaration(), "createBar2");
            }
        });
        GenericJavaRegistryTests.assertEquals((int)4, (int)contextRegistry.getElementFactoryMethodsSize());
        elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createFoo", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"foo", (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createFoo2", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals(null, (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar2", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals(null, (String)elementFactoryMethod.getQName().getName());
        GenericJavaRegistryTests.assertFalse((boolean)elementFactoryMethods.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaRegistryTests.this.removeMethodDeclaration((TypeDeclaration)declaration.getDeclaration(), "createFoo");
            }
        });
        GenericJavaRegistryTests.assertEquals((int)3, (int)contextRegistry.getElementFactoryMethodsSize());
        elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createFoo2", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals(null, (String)elementFactoryMethod.getQName().getName());
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar2", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals(null, (String)elementFactoryMethod.getQName().getName());
        GenericJavaRegistryTests.assertFalse((boolean)elementFactoryMethods.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaRegistryTests.this.removeMethodDeclaration((TypeDeclaration)declaration.getDeclaration(), "createFoo2");
                GenericJavaRegistryTests.this.removeMethodDeclaration((TypeDeclaration)declaration.getDeclaration(), "createBar2");
            }
        });
        GenericJavaRegistryTests.assertEquals((int)1, (int)contextRegistry.getElementFactoryMethodsSize());
        elementFactoryMethods = contextRegistry.getElementFactoryMethods().iterator();
        elementFactoryMethod = (JaxbElementFactoryMethod)elementFactoryMethods.next();
        GenericJavaRegistryTests.assertEquals((String)"createBar", (String)elementFactoryMethod.getName());
        GenericJavaRegistryTests.assertEquals((String)"bar", (String)elementFactoryMethod.getQName().getName());
        GenericJavaRegistryTests.assertFalse((boolean)elementFactoryMethods.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaRegistryTests.this.removeMethodDeclaration((TypeDeclaration)declaration.getDeclaration(), "createBar");
            }
        });
        GenericJavaRegistryTests.assertEquals((int)0, (int)contextRegistry.getElementFactoryMethodsSize());
        GenericJavaRegistryTests.assertFalse((boolean)contextRegistry.getElementFactoryMethods().iterator().hasNext());
    }
}

