/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CacheType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ExistenceCheckingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ExistenceType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaCachingTests
extends EclipseLinkContextModelTestCase {
    public EclipseLinkJavaCachingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testSetSpecifiedShared() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedShared());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isShared());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
    }

    public void testSetSpecifiedSharedFalseUnsetsOtherCacheSettings() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        caching.setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        caching.setSpecifiedSize(Integer.valueOf(500));
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.FALSE);
        caching.setSpecifiedDisableHits(Boolean.FALSE);
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        caching.setExistenceChecking(true);
        caching.setSpecifiedExistenceType(EclipseLinkExistenceType.CHECK_CACHE);
        caching.setExpiry(Integer.valueOf(8000));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals(null, (Object)caching.getExpiry());
        EclipseLinkJavaCachingTests.assertTrue((boolean)caching.isExistenceChecking());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_CACHE, (Object)caching.getSpecifiedExistenceType());
        caching.setSpecifiedShared(null);
        EclipseLinkTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        timeOfDayExpiry.setHour(Integer.valueOf(5));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiryTimeOfDay());
    }

    public void testGetDefaultShared() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertTrue((boolean)caching.isDefaultShared());
        this.getPersistenceUnit().setProperty("eclipselink.cache.shared.default", "false");
        EclipseLinkJavaCachingTests.assertFalse((boolean)caching.isDefaultShared());
    }

    public void testGetSpecifiedShared() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setShared(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getShared());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedShared());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isShared());
    }

    public void testSetSpecifiedType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
        caching.setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.HARD_WEAK, (Object)cacheAnnotation.getType());
        caching.setSpecifiedType(EclipseLinkCacheType.SOFT_WEAK);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.SOFT_WEAK, (Object)cacheAnnotation.getType());
        caching.setSpecifiedType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
    }

    public void testGetDefaultType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getDefaultType());
        this.getPersistenceUnit().setProperty("eclipselink.cache.type.default", EclipseLinkCacheType.FULL.toString());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)caching.getDefaultType());
    }

    public void testGetSpecifiedType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setType(CacheType.HARD_WEAK);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheType.HARD_WEAK, (Object)cacheAnnotation.getType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getSpecifiedType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getType());
    }

    public void testSetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isAlwaysRefresh());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.FALSE, (Object)cacheAnnotation.getAlwaysRefresh());
    }

    public void testGetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setAlwaysRefresh(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedAlwaysRefresh());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isAlwaysRefresh());
    }

    public void testSetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isRefreshOnlyIfNewer());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getRefreshOnlyIfNewer());
    }

    public void testGetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setRefreshOnlyIfNewer(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isRefreshOnlyIfNewer());
    }

    public void testSetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
        caching.setSpecifiedDisableHits(Boolean.TRUE);
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isDisableHits());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getDisableHits());
    }

    public void testGetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setDisableHits(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)cacheAnnotation.getDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedDisableHits());
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isDisableHits());
    }

    public void testSetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getCoordinationType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cacheAnnotation.getCoordinationType());
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.SEND_OBJECT_CHANGES, (Object)cacheAnnotation.getCoordinationType());
        caching.setSpecifiedCoordinationType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
    }

    public void testGetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setCoordinationType(CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)cacheAnnotation.getCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getSpecifiedCoordinationType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getCoordinationType());
    }

    public void testHasExistenceChecking() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isExistenceChecking());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        resourceType.addAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isExistenceChecking());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isExistenceChecking());
    }

    public void testSetExistenceChecking() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLinkJavaCachingTests.assertEquals((boolean)false, (boolean)caching.isExistenceChecking());
        EclipseLinkJavaCachingTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ExistenceChecking"));
        caching.setExistenceChecking(true);
        EclipseLinkJavaCachingTests.assertEquals((boolean)true, (boolean)caching.isExistenceChecking());
        EclipseLinkJavaCachingTests.assertNotNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ExistenceChecking"));
    }

    public void testGetDefaultExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)caching.getDefaultExistenceType());
        caching.setExistenceChecking(true);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_CACHE, (Object)caching.getDefaultExistenceType());
    }

    public void testGetSpecifiedExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)caching.getExistenceType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ExistenceCheckingAnnotation existenceCheckingAnnotation = (ExistenceCheckingAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        existenceCheckingAnnotation.setValue(ExistenceType.ASSUME_NON_EXISTENCE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)existenceCheckingAnnotation.getValue());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getExistenceType());
    }

    public void testSetSpecifiedExistenceType() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)caching.getExistenceType());
        caching.setExistenceChecking(true);
        caching.setSpecifiedExistenceType(EclipseLinkExistenceType.ASSUME_NON_EXISTENCE);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.ASSUME_NON_EXISTENCE, (Object)entity.getCaching().getExistenceType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ExistenceCheckingAnnotation existenceCheckingAnnotation = (ExistenceCheckingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ExistenceChecking");
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.ASSUME_NON_EXISTENCE, (Object)existenceCheckingAnnotation.getValue());
        caching.setSpecifiedExistenceType(EclipseLinkExistenceType.CHECK_DATABASE);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_DATABASE, (Object)caching.getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)ExistenceType.CHECK_DATABASE, (Object)existenceCheckingAnnotation.getValue());
        caching.setSpecifiedExistenceType(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedExistenceType());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_CACHE, (Object)caching.getExistenceType());
    }

    public void testGetExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
        cacheAnnotation.setExpiry(Integer.valueOf(57));
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)57, (Object)entity.getCaching().getExpiry());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.Cache");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertNull((Object)entity.getCaching().getExpiry());
    }

    public void testSetExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        caching.setExpiry(Integer.valueOf(58));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)58, (Object)cacheAnnotation.getExpiry());
        caching.setExpiry(null);
        cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiry());
    }

    public void testSetExpiryUnsetsExpiryTimeOfDay() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        caching.addExpiryTimeOfDay();
        caching.getExpiryTimeOfDay().setHour(Integer.valueOf(5));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)5, (Object)cacheAnnotation.getExpiryTimeOfDay().getHour());
        caching.setExpiry(Integer.valueOf(900));
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertEquals((Object)900, (Object)cacheAnnotation.getExpiry());
        EclipseLinkJavaCachingTests.assertEquals((Object)900, (Object)caching.getExpiry());
    }

    public void testGetTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.addExpiryTimeOfDay();
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testAddTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLinkTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertNotNull((Object)cacheAnnotation.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkJavaCachingTests.assertEquals((Object)timeOfDayExpiry, (Object)caching.getExpiryTimeOfDay());
    }

    public void testRemoveTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.addExpiryTimeOfDay();
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
        caching.removeExpiryTimeOfDay();
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testAddTimeOfDayExpiryUnsetsExpiry() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        caching.setExpiry(Integer.valueOf(800));
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)800, (Object)cacheAnnotation.getExpiry());
        caching.addExpiryTimeOfDay();
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getExpiry());
        EclipseLinkJavaCachingTests.assertNull((Object)cacheAnnotation.getExpiry());
        EclipseLinkJavaCachingTests.assertNotNull((Object)cacheAnnotation.getExpiryTimeOfDay());
    }

    public void testSetSpecifiedSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((int)100, (int)caching.getSize());
        caching.setSpecifiedSize(new Integer(50));
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)cacheAnnotation.getSize());
    }

    public void testGetDefaultSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((int)100, (int)caching.getDefaultSize());
        this.getPersistenceUnit().setProperty("eclipselink.cache.size.default", "333");
        EclipseLinkJavaCachingTests.assertEquals((int)333, (int)caching.getDefaultSize());
    }

    public void testGetSpecifiedSize() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((int)100, (int)caching.getSize());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setSize(new Integer(50));
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)cacheAnnotation.getSize());
        EclipseLinkJavaCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkJavaCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
    }

    public void testSetSpecifiedIsolation() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        caching.setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2.PROTECTED);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getSpecifiedIsolation());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getIsolation());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Cache");
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheIsolationType2_2.PROTECTED, (Object)cacheAnnotation.getIsolation());
        caching.setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2.SHARED);
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getSpecifiedIsolation());
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheIsolationType2_2.SHARED, (Object)cacheAnnotation.getIsolation());
        caching.setSpecifiedIsolation(null);
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedIsolation());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
    }

    public void testGetSpecifiedIsolation() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
        EclipseLinkJavaCaching caching = entity.getCaching();
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkJavaCachingTests.assertNull((Object)caching.getSpecifiedIsolation());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CacheAnnotation cacheAnnotation = (CacheAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Cache");
        cacheAnnotation.setIsolation(CacheIsolationType2_2.PROTECTED);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaCachingTests.assertEquals((Object)CacheIsolationType2_2.PROTECTED, (Object)cacheAnnotation.getIsolation());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getSpecifiedIsolation());
        EclipseLinkJavaCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getIsolation());
    }
}

