/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAssociationOverride;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualAssociationOverride;
import org.eclipse.jpt.jpa.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaAssociationOverrideTests
extends ContextModelTestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE_NAME";

    private ICompilationUnit createTestMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToOne");
                sb.append(CR);
                sb.append("    private AnnotationTestTypeChild address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithAssociationOverride() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@AssociationOverride(name=\"MY_ASSOCIATION_OVERRIDE_NAME\")");
            }
        });
    }

    private void createTestSubType() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaAssociationOverrideTests(String name) {
        super(name);
    }

    public void testUpdateName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        VirtualAssociationOverride virtualOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        SpecifiedAssociationOverride javaAssociationOverride = virtualOverride.convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)overrideContainer.getOverrides().iterator().hasNext());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        associationOverrideResource.setName(null);
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((int)0, (int)overrideContainer.getSpecifiedOverridesSize());
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.getSpecifiedOverridesSize());
        javaAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
        resourceType.removeAnnotation(0, "javax.persistence.AssociationOverride");
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertFalse((boolean)overrideContainer.getSpecifiedOverrides().iterator().hasNext());
        JavaAssociationOverrideTests.assertFalse((boolean)resourceType.getAnnotations("javax.persistence.AssociationOverride").iterator().hasNext());
    }

    public void testModifyName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        VirtualAssociationOverride virtualAssociationOverride = (VirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        SpecifiedAssociationOverride javaAssociationOverride = virtualAssociationOverride.convertToSpecified();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverrideResource.getName());
        JavaAssociationOverrideTests.assertTrue((boolean)overrideContainer.getOverrides().iterator().hasNext());
        javaAssociationOverride.setName("foo");
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)javaAssociationOverride.getName());
        JavaAssociationOverrideTests.assertEquals((String)"foo", (String)associationOverrideResource.getName());
        javaAssociationOverride.setName(null);
        JavaAssociationOverrideTests.assertNull((Object)javaAssociationOverride.getName());
        associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertNull((Object)associationOverrideResource.getName());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaVirtualAssociationOverride virtualOverride = (JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaSpecifiedAssociationOverride specifiedOverride = virtualOverride.convertToSpecified();
        JavaSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideAnnotation = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaSpecifiedJoinColumn joinColumn1 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn1.setSpecifiedName("FOO");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideAnnotation.joinColumnAt(0).getName());
        JavaSpecifiedJoinColumn joinColumn2 = joiningStrategy.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideAnnotation.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideAnnotation.joinColumnAt(1).getName());
        JavaSpecifiedJoinColumn joinColumn3 = joiningStrategy.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)4, (int)associationOverrideAnnotation.getJoinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideAnnotation.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideAnnotation.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideAnnotation.joinColumnAt(2).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)associationOverrideAnnotation.joinColumnAt(3).getName());
        JavaAssociationOverrideTests.assertEquals((int)4, (int)joiningStrategy.getSpecifiedJoinColumnsSize());
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn2, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn3, joinColumns.next());
        JavaAssociationOverrideTests.assertEquals((Object)joinColumn1, joinColumns.next());
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaVirtualAssociationOverride javaAssociationOverride = (JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaSpecifiedAssociationOverride specifiedOverride = javaAssociationOverride.convertToSpecified();
        JavaSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((int)1, (int)associationOverrideResource.getJoinColumnsSize());
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)4, (int)associationOverrideResource.getJoinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)3, (int)associationOverrideResource.getJoinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)2, (int)associationOverrideResource.getJoinColumnsSize());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)1, (int)associationOverrideResource.getJoinColumnsSize());
        joiningStrategy.removeSpecifiedJoinColumn(0);
        JavaAssociationOverrideTests.assertEquals((int)0, (int)associationOverrideResource.getJoinColumnsSize());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaVirtualAssociationOverride javaAssociationOverride = (JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaSpecifiedAssociationOverride specifiedOverride = javaAssociationOverride.convertToSpecified();
        JavaSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        joiningStrategy.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        joiningStrategy.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        joiningStrategy.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        JavaAssociationOverrideTests.assertEquals((int)4, (int)associationOverrideResource.getJoinColumnsSize());
        joiningStrategy.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
        joiningStrategy.moveSpecifiedJoinColumn(0, 1);
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)associationOverrideResource.joinColumnAt(0).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)associationOverrideResource.joinColumnAt(1).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.joinColumnAt(2).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaVirtualAssociationOverride javaAssociationOverride = (JavaVirtualAssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaSpecifiedAssociationOverride specifiedOverride = javaAssociationOverride.convertToSpecified();
        JavaSpecifiedJoinColumnRelationshipStrategy joiningStrategy = specifiedOverride.getRelationship().getJoinColumnStrategy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        ListIterator joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinColumns.next();
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)joinColumn.getSpecifiedName());
        JavaAssociationOverrideTests.assertEquals((String)"id", (String)joinColumn.getSpecifiedReferencedColumnName());
        associationOverrideResource.addJoinColumn(0);
        associationOverrideResource.addJoinColumn(1);
        associationOverrideResource.addJoinColumn(2);
        associationOverrideResource.joinColumnAt(0).setName("FOO");
        associationOverrideResource.joinColumnAt(1).setName("BAR");
        associationOverrideResource.joinColumnAt(2).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(2, 0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.moveJoinColumn(0, 1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"BAR", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(1);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"BAZ", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        JavaAssociationOverrideTests.assertFalse((boolean)joinColumns.hasNext());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        joinColumns = joiningStrategy.getSpecifiedJoinColumns().iterator();
        JavaAssociationOverrideTests.assertEquals((String)"address_id", (String)((JavaSpecifiedJoinColumn)joinColumns.next()).getName());
        associationOverrideResource.removeJoinColumn(0);
        this.getJpaProject().synchronizeContextModel();
        JavaAssociationOverrideTests.assertFalse((boolean)joiningStrategy.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        associationOverrideResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)specifiedAssociationOverride.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithAssociationOverride();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAssociationOverrideContainer overrideContainer = this.getJavaEntity().getAssociationOverrideContainer();
        SpecifiedAssociationOverride specifiedAssociationOverride = (SpecifiedAssociationOverride)overrideContainer.getSpecifiedOverrides().iterator().next();
        JavaAssociationOverrideTests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)specifiedAssociationOverride.getName());
        specifiedAssociationOverride.setName("FOO");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        AssociationOverrideAnnotation associationOverrideResource = (AssociationOverrideAnnotation)resourceType.getAnnotation(0, "javax.persistence.AssociationOverride");
        JavaAssociationOverrideTests.assertEquals((String)"FOO", (String)associationOverrideResource.getName());
    }

    public void testDefaultName() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAssociationOverrideTests.assertEquals((String)"address", (String)associationOverride.getName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaEntity entity = this.getJavaEntity();
        JavaAssociationOverrideContainer overrideContainer = entity.getAssociationOverrideContainer();
        JavaAssociationOverrideTests.assertEquals((String)"AnnotationTestTypeChild", (String)entity.getName());
        JavaAssociationOverrideTests.assertEquals((int)1, (int)overrideContainer.getVirtualOverridesSize());
        AssociationOverride associationOverride = (AssociationOverride)overrideContainer.getVirtualOverrides().iterator().next();
        JavaAssociationOverrideTests.assertTrue((boolean)associationOverride.isVirtual());
    }
}

