/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.catalog;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;

public class CatalogElement
implements ICatalogElement {
    int type;
    String id;
    String base;
    Map attributes = new HashMap();
    ICatalog ownerCatalog;

    public CatalogElement(int aType) {
        this.type = aType;
    }

    public int getType() {
        return this.type;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getAttributeValue(String name) {
        return (String)this.attributes.get(name);
    }

    public void setAttributeValue(String name, String value) {
        this.attributes.put(name, value);
    }

    public String[] getAttributes() {
        Collection c = this.attributes.values();
        String[] result = new String[c.size()];
        this.attributes.keySet().toArray(result);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ICatalog getOwnerCatalog() {
        return this.ownerCatalog;
    }

    public void setOwnerCatalog(ICatalog catalog) {
        this.ownerCatalog = catalog;
    }

    protected static String makeAbsolute(String baseLocation, String location) {
        URL local = null;
        location = location.replace('\\', '/');
        try {
            URL baseURL = new URL(baseLocation);
            local = new URL(baseURL, location);
        }
        catch (MalformedURLException malformedURLException) {}
        if (local != null) {
            return local.toString();
        }
        return location;
    }

    public String getAbsolutePath(String path) {
        try {
            URI uri = new URI(path);
            if (uri.isAbsolute()) {
                return path;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (this.base != null && !this.base.equals("")) {
            return CatalogElement.makeAbsolute(this.base, path);
        }
        String result = path;
        Catalog catalog = (Catalog)this.getOwnerCatalog();
        if (catalog != null) {
            String base = catalog.getBase();
            if (base == null || base.equals("")) {
                base = catalog.getLocation();
            }
            result = CatalogElement.makeAbsolute(base, path);
        }
        return result;
    }

    public Object clone() {
        ICatalogElement element = this.ownerCatalog.createCatalogElement(this.type);
        String[] attributes = this.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            String attrName = attributes[i];
            String attrValue = this.getAttributeValue(attrName);
            element.setAttributeValue(attrName, attrValue);
            ++i;
        }
        element.setOwnerCatalog(this.ownerCatalog);
        element.setId(this.id);
        element.setBase(this.base);
        return element;
    }
}

