/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel;

import java.util.Vector;
import org.apache.wsil.Description;
import org.apache.wsil.QName;
import org.apache.wsil.Service;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.eclipse.wst.ws.internal.datamodel.Model;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilServiceElement;

public class WsilWsdlServiceElement
extends WsilServiceElement {
    public WsilWsdlServiceElement(String name, Model model, Service service) {
        super(name, model, service);
    }

    public String getWSDLServiceURL() {
        Description desc = this.getValidWSDLDescription();
        return desc == null ? null : this.makeAbsolute(desc.getLocation());
    }

    public Vector getWSDLBinding() {
        Vector<QName> v = new Vector<QName>();
        Description[] descList = this.service_.getDescriptions();
        int i = 0;
        while (i < descList.length) {
            ExtensionElement extElement = descList[i].getExtensionElement();
            if (extElement != null && extElement instanceof Reference) {
                ReferencedService refService = ((Reference)extElement).getReferencedService();
                if (refService != null) {
                    v.add(refService.getReferencedServiceName());
                }
                ImplementedBinding[] implBindingList = ((Reference)extElement).getImplementedBindings();
                int j = 0;
                while (j < implBindingList.length) {
                    v.add(implBindingList[j].getBindingName());
                    ++j;
                }
            }
            ++i;
        }
        return v;
    }

    private Description getValidWSDLDescription() {
        Description[] descList = this.service_.getDescriptions();
        int i = 0;
        while (i < descList.length) {
            Boolean endpointPresent;
            ExtensionElement extElement;
            String location = descList[i].getLocation();
            if (location != null && location.length() > 0 && ((extElement = descList[i].getExtensionElement()) == null || !(extElement instanceof Reference) || (endpointPresent = ((Reference)extElement).getEndpointPresent()) == null || endpointPresent.booleanValue())) {
                return descList[i];
            }
            ++i;
        }
        return null;
    }

    public boolean validateWSDLService() {
        Description desc = this.getValidWSDLDescription();
        return desc != null;
    }

    public String toString() {
        return this.getWSDLServiceURL();
    }
}

