/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.IAnnotationSerializer;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.JaxWsWorkspaceResource;
import org.eclipse.jst.ws.jaxws.dom.runtime.persistence.serializer.SeiSerializerAdapter;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer.SerializerAdapterTestFixture;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.persistence.serializer.WsSerializerAdapterTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotationInspector;

public class SeiSerializerAdapterTest
extends SerializerAdapterTestFixture {
    public void testCreateIAnnotationIServiceEndpointInterface() throws JavaModelException {
        try {
            new MySeiSerializerAdapter(this.resource).createIAnnotation(null, this.project.getJavaProject().getJavaModel());
            SeiSerializerAdapterTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            new MySeiSerializerAdapter(this.resource).createIAnnotation(this.sei, null);
            SeiSerializerAdapterTest.fail((String)"NullPointerException not thrown");
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void testCreateIAnnotationExplicitSei() throws JavaModelException {
        IAnnotation<? extends IJavaElement> annotation = new MySeiSerializerAdapter(this.resource).createIAnnotation(this.sei, this.project.getJavaProject().getJavaModel());
        SeiSerializerAdapterTest.assertEquals((int)2, (int)annotation.getParamValuePairs().size());
        SeiSerializerAdapterTest.assertEquals((String)"http://com.sap/test", (String)annotation.getPropertyValue("targetNamespace"));
        SeiSerializerAdapterTest.assertEquals((String)"MyPortType", (String)annotation.getPropertyValue("name"));
        SeiSerializerAdapterTest.assertEquals((String)this.seiType.getFullyQualifiedName(), (String)((IType)annotation.getAppliedElement()).getFullyQualifiedName());
    }

    public void testCreateIAnnotationImplicitSei() throws JavaModelException {
        IAnnotation<? extends IJavaElement> annotation = new MySeiSerializerAdapter(this.resource).createIAnnotation(this.wsImplicit.getServiceEndpoint(), this.project.getJavaProject().getJavaModel());
        SeiSerializerAdapterTest.assertEquals((int)5, (int)annotation.getParamValuePairs().size());
        WsSerializerAdapterTest.checkIWebServiceIAnnotation(annotation);
        SeiSerializerAdapterTest.assertEquals((String)"ImplicitName", (String)annotation.getPropertyValue("name"));
        SeiSerializerAdapterTest.assertEquals((String)this.implBeanImplicit.getFullyQualifiedName(), (String)((IType)annotation.getAppliedElement()).getFullyQualifiedName());
    }

    public void testCreateIAnnotationDefaultValues() throws JavaModelException {
        this.sei.setName("SEI");
        this.sei.setTargetNamespace("http://test/");
        IAnnotation<? extends IJavaElement> annotation = new MySeiSerializerAdapter(this.resource).createIAnnotation(this.sei, this.project.getJavaProject().getJavaModel());
        SeiSerializerAdapterTest.assertEquals((int)0, (int)annotation.getParamValuePairs().size());
    }

    public void testSaveAnnotation() throws JavaModelException {
        this.resource.getSerializerFactory().adapt((Notifier)this.sei, IAnnotationSerializer.class);
        this.sei.setName("ChangedSeiName");
        IAnnotationInspector inspector = AnnotationFactory.createAnnotationInspector((IType)this.seiType);
        IAnnotation found = inspector.inspectType("javax.jws.WebService");
        SeiSerializerAdapterTest.assertNotNull((Object)found);
        SeiSerializerAdapterTest.assertEquals((String)"ChangedSeiName", (String)found.getPropertyValue("name"));
        SeiSerializerAdapterTest.assertEquals((String)"http://com.sap/test", (String)found.getPropertyValue("targetNamespace"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MySeiSerializerAdapter
    extends SeiSerializerAdapter {
        public MySeiSerializerAdapter(JaxWsWorkspaceResource resource) {
            super(resource);
        }

        protected IAnnotation<? extends IJavaElement> createIAnnotation(IServiceEndpointInterface sei, IJavaModel javaModel) throws JavaModelException {
            return super.createIAnnotation(sei, javaModel);
        }
    }
}

