/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.tests;

import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class HTMLUIPreferencesTest
extends TestCase {
    public void testBundleGetPreferences() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.html.ui");
        try {
            if (bundle != null) {
                bundle.start();
            } else {
                HTMLUIPreferencesTest.fail((String)"Get preference value failed because could not find bundle: org.eclipse.wst.html.ui");
            }
        }
        catch (BundleException e) {
            HTMLUIPreferencesTest.fail((String)("Get preference value failed because of exception starting bundle: org.eclipse.wst.html.ui exception: " + (Object)((Object)e)));
        }
        this.bundleGetPreference("org.eclipse.wst.html.ui", HTMLUIPreferenceNames.AUTO_PROPOSE);
        this.bundleGetPreference("org.eclipse.wst.html.ui", HTMLUIPreferenceNames.AUTO_PROPOSE_CODE);
    }

    private void bundleGetPreference(String bundleName, String prefKey) {
        String defaultValue = Long.toString(System.currentTimeMillis());
        String value = Platform.getPreferencesService().getString(bundleName, prefKey, defaultValue, null);
        HTMLUIPreferencesTest.assertNotSame((String)("Get preference value failed using Platform.getPreferencesService. Key: " + prefKey), (Object)defaultValue, (Object)value);
    }

    public void testPluginGetDefaultPreferences() {
        IPreferenceStore store = HTMLUIPlugin.getDefault().getPreferenceStore();
        this.pluginGetDefaultPreference(store, HTMLUIPreferenceNames.AUTO_PROPOSE, Boolean.toString(true));
        this.pluginGetDefaultPreference(store, HTMLUIPreferenceNames.AUTO_PROPOSE_CODE, "<=");
    }

    private void pluginGetDefaultPreference(IPreferenceStore store, String prefKey, String expected) {
        String defaultValue = store.getDefaultString(prefKey);
        HTMLUIPreferencesTest.assertEquals((String)("Get default preference value failed using plugin.getPreferenceStore. Key: " + prefKey), (String)expected, (String)defaultValue);
    }

    public void testPluginSetPreferences() {
        IPreferenceStore store = HTMLUIPlugin.getDefault().getPreferenceStore();
        this.pluginSetPreferenceBoolean(store, HTMLUIPreferenceNames.AUTO_PROPOSE);
        this.pluginSetPreferenceString(store, HTMLUIPreferenceNames.AUTO_PROPOSE_CODE);
    }

    private void pluginSetPreferenceBoolean(IPreferenceStore store, String prefKey) {
        boolean originalValue = store.getBoolean(prefKey);
        boolean expectedValue = !originalValue;
        store.setValue(prefKey, expectedValue);
        boolean foundValue = store.getBoolean(prefKey);
        HTMLUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (boolean)expectedValue, (boolean)foundValue);
        store.setValue(prefKey, originalValue);
    }

    private void pluginSetPreferenceString(IPreferenceStore store, String prefKey) {
        String originalValue = store.getString(prefKey);
        String expectedValue = Long.toString(System.currentTimeMillis());
        store.setValue(prefKey, expectedValue);
        String foundValue = store.getString(prefKey);
        HTMLUIPreferencesTest.assertEquals((String)("Set preference value failed using plugin.getPreferenceStore. Key: " + prefKey + "  expected: " + expectedValue + " found: " + foundValue), (String)expectedValue, (String)foundValue);
        store.setValue(prefKey, originalValue);
    }
}

