/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchAttributes {
    private final Set<LaunchAttribute> attributes = new HashSet<LaunchAttribute>();

    public Set<LaunchAttribute> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(LaunchAttribute attribute) {
        this.attributes.add(attribute);
    }

    public LaunchAttribute getAttribute(String uri) {
        for (LaunchAttribute tv : this.attributes) {
            if (!tv.uri.equals(uri)) continue;
            return tv;
        }
        return null;
    }

    public void removeAtribute(String uri) {
        Iterator<LaunchAttribute> iter = this.attributes.iterator();
        while (iter.hasNext()) {
            LaunchAttribute attribute = iter.next();
            if (!attribute.uri.equals(uri)) continue;
            iter.remove();
        }
    }

    public String toXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element attributesEl = doc.createElement("Attributes");
        doc.appendChild(attributesEl);
        for (LaunchAttribute attribute : this.attributes) {
            Element attributeEl = doc.createElement("Attribute");
            attributeEl.setAttribute("name", attribute.uri);
            attributeEl.setAttribute("type", attribute.type);
            attributeEl.setAttribute("value", attribute.value);
            attributesEl.appendChild(attributeEl);
        }
        return PreferenceUtil.serializeDocument((Document)doc);
    }

    public static LaunchAttributes fromXML(InputStream inputStream) throws CoreException {
        Document doc = PreferenceUtil.getDocument((InputStream)inputStream);
        LaunchAttributes pdef = new LaunchAttributes();
        Element attributesEl = doc.getDocumentElement();
        NodeList attributeEls = attributesEl.getElementsByTagName("Attribute");
        int i = 0;
        while (i < attributeEls.getLength()) {
            Element attributeEl = (Element)attributeEls.item(i);
            String name = attributeEl.getAttribute("name");
            String type = attributeEl.getAttribute("type");
            String value = attributeEl.getAttribute("value");
            pdef.addAttribute(new LaunchAttribute(name, type, value));
            ++i;
        }
        return pdef;
    }
}

