/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class MethodExitsFinder
extends ASTVisitor {
    private AST fAST;
    private FunctionDeclaration fMethodDeclaration;
    private List fResult;
    private List fCatchedExceptions;

    public String initialize(JavaScriptUnit root, int offset, int length) {
        return this.initialize(root, NodeFinder.perform((ASTNode)root, offset, length));
    }

    public String initialize(JavaScriptUnit root, ASTNode node) {
        Name name;
        this.fAST = root.getAST();
        if (node instanceof ReturnStatement) {
            this.fMethodDeclaration = (FunctionDeclaration)ASTNodes.getParent(node, 31);
            if (this.fMethodDeclaration == null) {
                return SearchMessages.MethodExitsFinder_no_return_type_selected;
            }
            return null;
        }
        Type type = null;
        if (node instanceof Type) {
            type = (Type)node;
        } else if (node instanceof Name && (name = ASTNodes.getTopMostName((Name)node)).getParent() instanceof Type) {
            type = (Type)name.getParent();
        }
        if (type == null) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        if (!((type = ASTNodes.getTopMostType(type)).getParent() instanceof FunctionDeclaration)) {
            return SearchMessages.MethodExitsFinder_no_return_type_selected;
        }
        this.fMethodDeclaration = (FunctionDeclaration)type.getParent();
        return null;
    }

    public List perform() {
        Type returnType;
        this.fResult = new ArrayList();
        this.markReferences();
        if (this.fResult.size() > 0 && (returnType = this.fMethodDeclaration.getReturnType2()) != null) {
            this.fResult.add(this.fMethodDeclaration.getReturnType2());
        }
        return this.fResult;
    }

    private void markReferences() {
        this.fCatchedExceptions = new ArrayList();
        boolean isVoid = true;
        Type returnType = this.fMethodDeclaration.getReturnType2();
        if (returnType != null) {
            ITypeBinding returnTypeBinding = returnType.resolveBinding();
            isVoid = returnTypeBinding != null && Bindings.isVoidType(returnTypeBinding);
        }
        this.fMethodDeclaration.accept((ASTVisitor)this);
        Block block = this.fMethodDeclaration.getBody();
        if (block != null) {
            Object lastObject;
            List statements = block.statements();
            if (statements.size() > 0 && (lastObject = statements.get(statements.size() - 1)) instanceof Statement) {
                Statement last = (Statement)lastObject;
                int maxVariableId = LocalVariableIndex.perform((BodyDeclaration)this.fMethodDeclaration);
                FlowContext flowContext = new FlowContext(0, maxVariableId + 1);
                flowContext.setConsiderAccessMode(false);
                flowContext.setComputeMode(FlowContext.ARGUMENTS);
                InOutFlowAnalyzer flowAnalyzer = new InOutFlowAnalyzer(flowContext);
                FlowInfo info = flowAnalyzer.perform(new ASTNode[]{last});
                if (!(info.isNoReturn() || isVoid || info.isPartialReturn())) {
                    return;
                }
            }
            SimpleName name = this.fAST.newSimpleName("x");
            name.setSourceRange(this.fMethodDeclaration.getStartPosition() + this.fMethodDeclaration.getLength() - 1, 1);
            this.fResult.add(name);
        }
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        this.fResult.add(node);
        return super.visit(node);
    }

    public boolean visit(TryStatement node) {
        int toRemove;
        int currentSize = this.fCatchedExceptions.size();
        List catchClauses = node.catchClauses();
        Iterator iter = catchClauses.iterator();
        while (iter.hasNext()) {
            IVariableBinding variable = ((CatchClause)iter.next()).getException().resolveBinding();
            if (variable == null || variable.getType() == null) continue;
            this.fCatchedExceptions.add(variable.getType());
        }
        node.getBody().accept((ASTVisitor)this);
        int i = toRemove = this.fCatchedExceptions.size() - currentSize;
        while (i > 0) {
            this.fCatchedExceptions.remove(currentSize);
            --i;
        }
        Iterator iter2 = catchClauses.iterator();
        while (iter2.hasNext()) {
            ((CatchClause)iter2.next()).accept((ASTVisitor)this);
        }
        if (node.getFinally() != null) {
            node.getFinally().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ThrowStatement node) {
        if (this.isExitPoint()) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return true;
    }

    public boolean visit(FunctionInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isExitPoint(node.resolveMethodBinding())) {
            this.fResult.add(node.getName());
        }
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            this.fResult.add(node.getType());
        }
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxx");
            name.setSourceRange(node.getStartPosition(), 4);
            this.fResult.add(name);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isExitPoint(node.resolveConstructorBinding())) {
            SimpleName name = this.fAST.newSimpleName("xxxxx");
            name.setSourceRange(node.getStartPosition(), 5);
            this.fResult.add(name);
        }
        return true;
    }

    private boolean isExitPoint() {
        return !this.isCatched();
    }

    private boolean isExitPoint(IFunctionBinding binding) {
        return false;
    }

    private boolean isCatched() {
        return this.fCatchedExceptions.size() != 0;
    }
}

