/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.predicate;

import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.BitTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.predicate.IsNotNull;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.CompoundPredicate;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class ORTests
extends TestCase {
    private CompoundPredicate<Number> orPredicate;

    public ORTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.orPredicate = PredicateTools.or((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0)});
    }

    private Predicate<Number> buildMin(double min) {
        return new Min(min);
    }

    private Predicate<Number> buildMax(double max) {
        return new Max(max);
    }

    private Predicate<Number> buildIsEven() {
        return new IsEven();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testEvaluate2() {
        ORTests.assertFalse((boolean)this.orPredicate.evaluate((Object)new Integer(7)));
        ORTests.assertFalse((boolean)this.orPredicate.evaluate((Object)new Integer(2)));
        ORTests.assertFalse((boolean)this.orPredicate.evaluate((Object)new Double(6.666)));
        ORTests.assertTrue((boolean)this.orPredicate.evaluate((Object)new Double(-99.0)));
        ORTests.assertTrue((boolean)this.orPredicate.evaluate((Object)new Double(-1.0)));
        ORTests.assertTrue((boolean)this.orPredicate.evaluate((Object)new Double(11.0)));
        ORTests.assertTrue((boolean)this.orPredicate.evaluate((Object)new Double(111.0)));
    }

    public void testEvaluate3() {
        CompoundPredicate orPredicate2 = PredicateTools.or((Predicate[])new Predicate[]{this.orPredicate, this.buildIsEven()});
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(7)));
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(3)));
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(9)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Integer(2)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(6.1)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-99.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-1.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(11.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(111.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-98.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(0.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-2.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(12.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(222.0)));
    }

    public void testComposite() {
        CompoundPredicate orPredicate2 = PredicateTools.or((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0), this.buildIsEven()});
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(7)));
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(3)));
        ORTests.assertFalse((boolean)orPredicate2.evaluate((Object)new Integer(9)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Integer(2)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(6.1)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-99.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-1.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(11.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(111.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-98.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(0.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(-2.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(12.0)));
        ORTests.assertTrue((boolean)orPredicate2.evaluate((Object)new Double(222.0)));
    }

    public void testEquals() {
        CompoundPredicate orPredicate2 = PredicateTools.or((Predicate[])new Predicate[]{this.buildMin(1.0), this.buildMax(10.0)});
        ORTests.assertEquals(this.orPredicate, (Object)orPredicate2);
        ORTests.assertEquals((int)this.orPredicate.hashCode(), (int)orPredicate2.hashCode());
        ORTests.assertFalse((boolean)this.orPredicate.equals((Object)IsNotNull.instance()));
    }

    static class IsEven
    extends PredicateAdapter<Number> {
        IsEven() {
        }

        public boolean evaluate(Number number) {
            return BitTools.isEven((int)number.intValue());
        }
    }

    static class Max
    extends CriterionPredicate<Number, Number> {
        Max(double max) {
            super((Object)new Double(max));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() >= ((Number)this.criterion).doubleValue();
        }
    }

    static class Min
    extends CriterionPredicate<Number, Number> {
        Min(double min) {
            super((Object)new Double(min));
        }

        public boolean evaluate(Number number) {
            return number.doubleValue() <= ((Number)this.criterion).doubleValue();
        }
    }
}

