/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.testutils.files;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzipper {
    public static final Unzipper INSTANCE = new Unzipper();

    private Unzipper() {
    }

    public void copyInputStream(InputStream sourceStream, OutputStream destStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = sourceStream.read(buffer)) >= 0) {
            destStream.write(buffer, 0, len);
        }
        destStream.flush();
    }

    public void unzip(File sourceFile, File destinationDir, boolean toLowerCase) throws IOException {
        this.checkInputParams(sourceFile, destinationDir);
        ZipFile zipFile = null;
        try {
            ZipEntry entry;
            zipFile = new ZipFile(sourceFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (!entry.isDirectory()) continue;
                new File(destinationDir, toLowerCase ? entry.getName().toLowerCase() : entry.getName()).mkdirs();
            }
            entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                FileOutputStream fos = null;
                FilterOutputStream bufOutStream = null;
                try {
                    fos = new FileOutputStream(new File(destinationDir, toLowerCase ? entry.getName().toLowerCase() : entry.getName()));
                    bufOutStream = new BufferedOutputStream(fos);
                    this.copyInputStream(zipFile.getInputStream(entry), bufOutStream);
                    fos.flush();
                    ((BufferedOutputStream)bufOutStream).flush();
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                    if (bufOutStream != null) {
                        bufOutStream.close();
                    }
                }
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private void checkInputParams(File zipFile, File destination) {
        if (!zipFile.exists() || zipFile.isDirectory()) {
            throw new IllegalArgumentException("ZIP file does not exist or is a directory");
        }
        if (!destination.exists() || !destination.isDirectory()) {
            throw new IllegalArgumentException("Destination does not exist or is not a directory");
        }
    }
}

