/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmManagedType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JpaFileTests
extends ContextModelTestCase {
    public JpaFileTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private JpaFile getJpaFile(ICompilationUnit cu) {
        return this.getJpaFile((IFile)cu.getResource());
    }

    private JpaFile getJpaFile(IFile file) {
        try {
            return this.getJpaFile_(file);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }

    private JpaFile getJpaFile_(IFile file) throws InterruptedException {
        return this.getJpaFileReference(file).getValue();
    }

    private JpaFile.Reference getJpaFileReference(IFile file) {
        return (JpaFile.Reference)file.getAdapter(JpaFile.Reference.class);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    public void testGetRootStructureNode() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removeManagedType((OrmManagedType)ormPersistentType);
        JpaFileTests.assertEquals((Object)this.getJavaEntity().getPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        JptXmlResource resource = (JptXmlResource)ormXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testImpliedEntityMappingsRootStructureNodeRemoved() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertNull((Object)this.getPersistenceUnit().getImpliedMappingFileRef());
        this.getXmlPersistenceUnit().getMappingFiles().remove(0);
        JpaFileTests.assertNotNull((Object)this.getPersistenceUnit().getImpliedMappingFileRef());
        JpaFileTests.assertEquals((Object)this.getPersistenceUnit().getImpliedMappingFileRef().getMappingFile().getRoot(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        JptXmlResource resource = (JptXmlResource)ormXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testEntityMappingsRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.getOrmXmlResource().getFile();
        JpaFile ormXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertEquals((Object)this.getEntityMappings(), ormXmlJpaFile.getRootStructureNodes().iterator().next());
        this.getOrmXmlResource().getContents().remove((Object)this.getOrmXmlResource().getRootObject());
        JpaFileTests.assertFalse((boolean)ormXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdatePersistenceRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertEquals((Object)this.getContextModelRoot().getPersistenceXml().getRoot(), persistenceXmlJpaFile.getRootStructureNodes().iterator().next());
        JptXmlResource resource = (JptXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = this.getJpaFile(file);
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        JptXmlResource resource = (JptXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceRemoved() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = this.getJpaFile(file);
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        JptXmlResource resource = (JptXmlResource)persistenceXmlJpaFile.getResourceModel();
        resource.getContents().remove((Object)resource.getRootObject());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testPersistenceRootStructureNodeRemovedFromResourceModel() throws Exception {
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile persistenceXmlJpaFile = this.getJpaFile(file);
        this.getContextModelRoot().getPersistenceXml().getRoot();
        JpaFileTests.assertEquals((Object)this.getContextModelRoot().getPersistenceXml().getRoot(), persistenceXmlJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)persistenceXmlJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateOrmJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testUpdateJavaRootStructureNodePersistenceXmlRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        this.getPersistenceXmlResource().getContents().remove((Object)this.getXmlPersistence());
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertTrue((boolean)(node.getParent() instanceof OrmPersistentType));
        this.getEntityMappings().removeManagedType(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertTrue((boolean)(node.getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testOrmJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertTrue((boolean)(node.getParent() instanceof OrmPersistentType));
        this.getXmlEntityMappings().getEntities().remove(0);
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertTrue((boolean)(node.getParent() instanceof ClassRef));
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getSpecifiedClassRefs().iterator().next(), (Object)node.getParent());
        this.getEntityMappings().getPersistenceUnit().removeSpecifiedClassRef(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }

    public void testJavaPersistentTypeRootStructureNodeRemovedFromResourceModel() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        Iterator rootStructureNodes = javaJpaFile.getRootStructureNodes().iterator();
        JpaStructureNode rootStructureNode = (JpaStructureNode)rootStructureNodes.next();
        JpaFileTests.assertEquals((Object)javaPersistentType, (Object)rootStructureNode);
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getSpecifiedClassRefs().iterator().next(), (Object)rootStructureNode.getParent());
        JpaFileTests.assertFalse((boolean)rootStructureNodes.hasNext());
        this.removeXmlClassRef("test.AnnotationTestType");
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }

    public void testImpliedJavaPersistentTypeRootStructureNodeRemoved() throws Exception {
        this.getJpaProject().setDiscoversAnnotatedClasses(true);
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ((ClassRef)this.getPersistenceUnit().getImpliedClassRefs().iterator().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        javaPersistentType.setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
    }

    public void testJavaRootStructureNodesEntityMappingsRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getOrmXmlResource().getContents().remove((Object)this.getXmlEntityMappings());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemovedFromResourceModel() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getXmlPersistence().getPersistenceUnits().remove(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.getRootStructureNodesSize());
    }

    public void testJavaRootStructureNodesPersistenceUnitRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getJpaProject().getContextRoot().getPersistenceXml().getRoot().removePersistenceUnit(0);
        JpaFileTests.assertFalse((boolean)javaJpaFile.getRootStructureNodes().iterator().hasNext());
        JpaFileTests.assertEquals((int)0, (int)javaJpaFile.getRootStructureNodesSize());
    }

    public void testJavaRootStructureNodesOrmPersistentTypeRemoved() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removeManagedType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }

    public void testJavaRootStructureNodesOrmTypeMappingMorphed() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        ormPersistentType.setMappingKey("embeddable");
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        javaPersistentType = ((OrmPersistentType)this.getEntityMappings().getPersistentTypes().iterator().next()).getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.getEntityMappings().removeManagedType(0);
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getEntityMappings().getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }

    public void testUpdateOrmJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.getPersistenceUnit().getMappingFileRefs().iterator().next();
        mappingFileRef.setFileName("foo");
        ormPersistentType = (OrmPersistentType)((EntityMappings)this.getPersistenceUnit().getImpliedMappingFileRef().getMappingFile().getRoot()).getPersistentTypes().iterator().next();
        JpaFileTests.assertEquals((Object)ormPersistentType.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        IFile file = this.getPersistenceXmlResource().getFile();
        JpaFile ormXmlJpaFile = this.getJpaFile(file);
        JpaFileTests.assertEquals((int)1, (int)ormXmlJpaFile.getRootStructureNodesSize());
    }

    public void testUpdateJavaRootStructureNodeMappingFileRefChanged() throws Exception {
        ICompilationUnit cu = this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
        MappingFileRef mappingFileRef = (MappingFileRef)this.getPersistenceUnit().getMappingFileRefs().iterator().next();
        mappingFileRef.setFileName("foo");
        JpaFileTests.assertEquals((Object)this.getJavaPersistentType(), javaJpaFile.getRootStructureNodes().iterator().next());
    }

    public void testUpdateJavaRootStrucutreNodeDeleteOrmResource() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ICompilationUnit cu = this.createTestEntity();
        JpaFile javaJpaFile = this.getJpaFile(cu);
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        JpaFileTests.assertEquals((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        this.deleteResource((Resource)this.getOrmXmlResource());
        JpaFileTests.assertNotSame((Object)javaPersistentType, javaJpaFile.getRootStructureNodes().iterator().next());
        JpaFileTests.assertEquals((int)1, (int)javaJpaFile.getRootStructureNodesSize());
        JpaModel node = (JpaModel)javaJpaFile.getRootStructureNodes().iterator().next();
        JpaFileTests.assertEquals(this.getPersistenceUnit().getImpliedClassRefs().iterator().next(), (Object)node.getParent());
    }
}

