/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class GenericJavaPersistentAttributeTests
extends ContextModelTestCase {
    private static String GENERIC_SUPERCLASS = "GenericSuperclass";
    private static String GENERIC_SUBCLASS = "GenericSubclass";

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentAttributeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getName());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaBasicMapping));
    }

    public void testGetSpecifiedMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaIdMapping));
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testGetSpecifiedMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaPersistentAttributeTests.assertNotNull((Object)persistentAttribute.getMapping());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey(null);
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMappingKey());
    }

    public void testDefaultMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getDefaultMappingKey());
    }

    public void testSetSpecifiedMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        persistentAttribute.setMappingKey("embedded");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey("embedded");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        GenericJavaPersistentAttributeTests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Embedded"));
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
        GenericJavaPersistentAttributeTests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof JavaEmbeddedMapping));
    }

    public void testSetSpecifiedMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        GenericJavaPersistentAttributeTests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((String)"id", (String)persistentAttribute.getMappingKey());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        resourceAttribute.setPrimaryAnnotation("javax.persistence.Embedded", EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttributeTests.assertEquals((String)"embedded", (String)persistentAttribute.getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceAttribute resourceAttribute = (JavaResourceAttribute)resourceType.getFields().iterator().next();
        resourceAttribute.setPrimaryAnnotation("javax.persistence.Basic", EmptyIterable.instance());
        GenericJavaPersistentAttributeTests.assertEquals((String)"basic", (String)persistentAttribute.getMapping().getKey());
    }

    public void testGetAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.FIELD, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }

    public void testGetAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getAccess());
        GenericJavaPersistentAttributeTests.assertEquals((Object)AccessType.PROPERTY, (Object)persistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttributeTests.assertEquals(null, (Object)persistentAttribute.getSpecifiedAccess());
    }

    public void testNonResolvingField() throws Exception {
        this.createTestEntityWithNonResolvingField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourceField resourceField = (JavaResourceField)this.getJavaPersistentType().getJavaResourceType().getFields().iterator().next();
        JavaSpecifiedPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("foo");
        GenericJavaPersistentAttributeTests.assertTrue((boolean)attribute.isFor(resourceField));
    }

    public void testIsPersistableMethod2() throws Exception {
        this.createTestEntityWithNonResolvingMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        Iterator methods = this.getJavaPersistentType().getJavaResourceType().getMethods().iterator();
        JavaResourceMethod resourceGetter = (JavaResourceMethod)methods.next();
        JavaResourceMethod resourceSetter = (JavaResourceMethod)methods.next();
        JavaSpecifiedPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("foo");
        GenericJavaPersistentAttributeTests.assertTrue((boolean)attribute.isFor(resourceGetter, resourceSetter));
    }

    private ICompilationUnit createTestEntityWithNonResolvingField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private Foo foo;").append(CR);
                sb.append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithNonResolvingMethod() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("private Foo foo;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
                sb.append(CR);
                sb.append("    public Foo getFoo() {").append(CR);
                sb.append("        return this.foo;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append(CR);
                sb.append("    public void setFoo(Foo foo) {").append(CR);
                sb.append("        this.foo = foo;").append(CR);
                sb.append("    }").append(CR);
                sb.append(CR);
                sb.append("    ");
            }
        });
    }

    public void testGetAttributeTypeName() throws Exception {
        this.createGenericSuperclass();
        this.createGenericSubclass();
        JavaPersistentType superclassPT = ((ClassRef)IterableTools.get((Iterable)this.getPersistenceUnit().getClassRefs(), (int)0)).getJavaPersistentType();
        JavaPersistentType subclassPT = ((ClassRef)IterableTools.get((Iterable)this.getPersistenceUnit().getClassRefs(), (int)1)).getJavaPersistentType();
        JavaSpecifiedPersistentAttribute genericAttribute = superclassPT.getAttributeNamed("genericField");
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)genericAttribute.getTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)genericAttribute.getTypeName((PersistentType)superclassPT));
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Long", (String)genericAttribute.getTypeName((PersistentType)subclassPT));
        JavaSpecifiedPersistentAttribute nongenericAttribute = superclassPT.getAttributeNamed("nongenericField");
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)nongenericAttribute.getTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)nongenericAttribute.getTypeName((PersistentType)superclassPT));
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)nongenericAttribute.getTypeName((PersistentType)subclassPT));
    }

    private ICompilationUnit createGenericSuperclass() throws CoreException {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(GENERIC_SUPERCLASS).append("<T extends Number> ").append("{").append(CR);
                sb.append("    protected T genericField;").append(CR);
                sb.append("    protected Number nongenericField;").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.addXmlClassRef("test." + GENERIC_SUPERCLASS);
        return this.javaProjectTestHarness.createCompilationUnit("test", String.valueOf(GENERIC_SUPERCLASS) + ".java", sourceWriter);
    }

    private ICompilationUnit createGenericSubclass() throws CoreException {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("public class ").append(GENERIC_SUBCLASS).append(CR);
                sb.append("        extends ").append(GENERIC_SUPERCLASS).append("<Long> {").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.addXmlClassRef("test." + GENERIC_SUBCLASS);
        return this.javaProjectTestHarness.createCompilationUnit("test", String.valueOf(GENERIC_SUBCLASS) + ".java", sourceWriter);
    }
}

