/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaPersistentAttribute2_0Tests
extends Generic2_0ContextModelTestCase {
    private ICompilationUnit createTestEntityForDerivedId() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.OneToOne", "javax.persistence.ManyToOne"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntitySpecifiedAccessField() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Basic", "javax.persistence.Transient", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("transient");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
                sb.append("@Access(AccessType.PROPERTY)");
            }
        });
    }

    private ICompilationUnit createTestEntitySpecifiedAccessProperty() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.Basic", "javax.persistence.Access", "javax.persistence.AccessType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append("@Access(AccessType.PROPERTY)");
            }

            public void appendNameFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic");
                sb.append("@Access(AccessType.FIELD)");
            }

            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentAttribute2_0Tests(String name) {
        super(name);
    }

    public void testGetAccessField() throws Exception {
        this.createTestEntitySpecifiedAccessField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute namePersistentAttribute = this.getJavaPersistentType().getAttributeNamed("name");
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)namePersistentAttribute.getAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)namePersistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals(null, (Object)namePersistentAttribute.getSpecifiedAccess());
        JavaSpecifiedPersistentAttribute idPersistentAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)"id", (String)idPersistentAttribute.getMappingKey());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)idPersistentAttribute.getAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)idPersistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)idPersistentAttribute.getSpecifiedAccess());
    }

    public void testGetAccessProperty() throws Exception {
        this.createTestEntitySpecifiedAccessProperty();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute namePersistentAttribute = this.getJavaPersistentType().getAttributeNamed("name");
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)namePersistentAttribute.getAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)namePersistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.FIELD, (Object)namePersistentAttribute.getSpecifiedAccess());
        JavaSpecifiedPersistentAttribute idPersistentAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)"id", (String)idPersistentAttribute.getMappingKey());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)idPersistentAttribute.getAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals((Object)AccessType.PROPERTY, (Object)idPersistentAttribute.getDefaultAccess());
        GenericJavaPersistentAttribute2_0Tests.assertEquals(null, (Object)idPersistentAttribute.getSpecifiedAccess());
    }

    public void testDerivedIdMappingInitialization() throws Exception {
        this.createTestEntityForDerivedId();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute id = this.getJavaPersistentType().getAttributeNamed("id");
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"basic");
        id.getResourceAttribute().addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"id");
        id.getResourceAttribute().addAnnotation("javax.persistence.OneToOne");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"oneToOne");
        GenericJavaPersistentAttribute2_0Tests.assertNotNull((Object)id.getResourceAttribute().getAnnotation("javax.persistence.Id"));
        id.getResourceAttribute().removeAnnotation("javax.persistence.OneToOne");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"id");
        id.getResourceAttribute().addAnnotation("javax.persistence.ManyToOne");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"manyToOne");
        GenericJavaPersistentAttribute2_0Tests.assertNotNull((Object)id.getResourceAttribute().getAnnotation("javax.persistence.Id"));
        id.getResourceAttribute().removeAnnotation("javax.persistence.ManyToOne");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"id");
        id.getResourceAttribute().setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaPersistentAttribute2_0Tests.assertEquals((String)id.getMappingKey(), (String)"basic");
    }
}

