/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.orm;

import java.util.ListIterator;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryHint;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmNamedStoredProcedureQuery2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmQueryContainer2_1;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.OrmStoredProcedureParameter2_1;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlNamedStoredProcedureQuery;
import org.eclipse.jpt.jpa.core.resource.orm.XmlQueryHint;
import org.eclipse.jpt.jpa.core.resource.orm.XmlStoredProcedureParameter;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.Generic2_1ContextModelTestCase;

public class GenericOrmNamedStoredProcedureQuery2_1Tests
extends Generic2_1ContextModelTestCase {
    public GenericOrmNamedStoredProcedureQuery2_1Tests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getName());
        procedureQueryResource.setName("foo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryResource.getName());
        procedureQueryResource.setName(null);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getName());
        ormProcedureQuery.setName("foo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryResource.getName());
        ormProcedureQuery.setName("newFoo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"newFoo", (String)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"newFoo", (String)procedureQueryResource.getName());
        ormProcedureQuery.setName(null);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getName());
    }

    public void testUpdateProcedureName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getProcedureName());
        procedureQueryResource.setProcedureName("foo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryResource.getProcedureName());
        procedureQueryResource.setProcedureName(null);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getProcedureName());
    }

    public void testModifyProcedureName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getName());
        ormProcedureQuery.setProcedureName("foo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"foo", (String)procedureQueryResource.getProcedureName());
        ormProcedureQuery.setProcedureName("newFoo");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"newFoo", (String)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"newFoo", (String)procedureQueryResource.getProcedureName());
        ormProcedureQuery.setProcedureName(null);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)ormProcedureQuery.getProcedureName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertNull((Object)procedureQueryResource.getProcedureName());
    }

    public void testAddParameter() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        OrmStoredProcedureParameter2_1 parameter1 = ormProcedureQuery.addParameter(0);
        parameter1.setName("FOO");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        OrmStoredProcedureParameter2_1 parameter2 = ormProcedureQuery.addParameter(0);
        parameter2.setName("BAR");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).getName());
        OrmStoredProcedureParameter2_1 parameter3 = ormProcedureQuery.addParameter(1);
        parameter3.setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(2)).getName());
        ListIterator parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter2, parameters.next());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter3, parameters.next());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)parameter1, parameters.next());
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
    }

    public void testRemoveParameter() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addParameter(0).setName("FOO");
        ormProcedureQuery.addParameter(1).setName("BAR");
        ormProcedureQuery.addParameter(2).setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getParameters().size());
        ormProcedureQuery.removeParameter(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryResource.getParameters().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).getName());
        ormProcedureQuery.removeParameter(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryResource.getParameters().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        ormProcedureQuery.removeParameter(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryResource.getParameters().size());
    }

    public void testMoveParameter() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addParameter(0).setName("FOO");
        ormProcedureQuery.addParameter(1).setName("BAR");
        ormProcedureQuery.addParameter(2).setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getParameters().size());
        ormProcedureQuery.moveParameter(2, 0);
        ListIterator parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(2)).getName());
        ormProcedureQuery.moveParameter(0, 1);
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(2)).getName());
    }

    public void testUpdateParameters() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        procedureQueryResource.getParameters().add((Object)OrmFactory.eINSTANCE.createXmlStoredProcedureParameter());
        procedureQueryResource.getParameters().add((Object)OrmFactory.eINSTANCE.createXmlStoredProcedureParameter());
        procedureQueryResource.getParameters().add((Object)OrmFactory.eINSTANCE.createXmlStoredProcedureParameter());
        ((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(0)).setName("FOO");
        ((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(1)).setName("BAR");
        ((XmlStoredProcedureParameter)procedureQueryResource.getParameters().get(2)).setName("BAZ");
        ListIterator parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryResource.getParameters().move(2, 0);
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryResource.getParameters().move(0, 1);
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryResource.getParameters().remove(1);
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryResource.getParameters().remove(1);
        parameters = ormProcedureQuery.getParameters().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmStoredProcedureParameter2_1)parameters.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)parameters.hasNext());
        procedureQueryResource.getParameters().remove(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)ormProcedureQuery.getParameters().iterator().hasNext());
    }

    public void testAddResultClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultClass("Employee");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        ormProcedureQuery.addResultClass("Address");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(1)));
        ormProcedureQuery.addResultClass(1, "Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultClasses().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(2)));
        ListIterator resultSetClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetClasses.next()));
    }

    public void testRemoveResultClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultClass("Employee");
        ormProcedureQuery.addResultClass("Address");
        ormProcedureQuery.addResultClass("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getResultClasses().size());
        ormProcedureQuery.removeResultClass(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryResource.getResultClasses().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultClasses().get(1)));
        ormProcedureQuery.removeResultClass("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryResource.getResultClasses().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        ormProcedureQuery.removeResultClass(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryResource.getResultClasses().size());
    }

    public void testMoveResultClass() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultClass("Employee");
        ormProcedureQuery.addResultClass("Address");
        ormProcedureQuery.addResultClass("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getResultClasses().size());
        ormProcedureQuery.moveResultClass(2, 0);
        ListIterator resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultClasses().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultClasses().get(2)));
        ormProcedureQuery.moveResultClass(0, 1);
        resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultClasses().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultClasses().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultClasses().get(2)));
    }

    public void testUpdateResultClasses() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        procedureQueryResource.getResultClasses().add((Object)"Employee");
        procedureQueryResource.getResultClasses().add((Object)"Address");
        procedureQueryResource.getResultClasses().add((Object)"Project");
        ListIterator resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryResource.getResultClasses().move(2, 0);
        resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryResource.getResultClasses().move(0, 1);
        resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryResource.getResultClasses().remove(1);
        resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryResource.getResultClasses().remove(1);
        resultClasses = ormProcedureQuery.getResultClasses().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultClasses.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultClasses.hasNext());
        procedureQueryResource.getResultClasses().remove(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)ormProcedureQuery.getResultClasses().iterator().hasNext());
    }

    public void testAddResultSetMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultSetMapping("Employee");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        ormProcedureQuery.addResultSetMapping("Address");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(1)));
        ormProcedureQuery.addResultSetMapping(1, "Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultSetMappings().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(2)));
        ListIterator resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
    }

    public void testRemoveResultSetMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultSetMapping("Employee");
        ormProcedureQuery.addResultSetMapping("Address");
        ormProcedureQuery.addResultSetMapping("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getResultSetMappings().size());
        ormProcedureQuery.removeResultSetMapping(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryResource.getResultSetMappings().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultSetMappings().get(1)));
        ormProcedureQuery.removeResultSetMapping("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryResource.getResultSetMappings().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        ormProcedureQuery.removeResultSetMapping(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryResource.getResultSetMappings().size());
    }

    public void testMoveResultSetMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addResultSetMapping("Employee");
        ormProcedureQuery.addResultSetMapping("Address");
        ormProcedureQuery.addResultSetMapping("Project");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getResultSetMappings().size());
        ormProcedureQuery.moveResultSetMapping(2, 0);
        ListIterator resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultSetMappings().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultSetMappings().get(2)));
        ormProcedureQuery.moveResultSetMapping(0, 1);
        resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)procedureQueryResource.getResultSetMappings().get(0)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)procedureQueryResource.getResultSetMappings().get(1)));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)procedureQueryResource.getResultSetMappings().get(2)));
    }

    public void testUpdateResultSetMappings() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        procedureQueryResource.getResultSetMappings().add((Object)"Employee");
        procedureQueryResource.getResultSetMappings().add((Object)"Address");
        procedureQueryResource.getResultSetMappings().add((Object)"Project");
        ListIterator resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMappings.hasNext());
        procedureQueryResource.getResultSetMappings().move(2, 0);
        resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMappings.hasNext());
        procedureQueryResource.getResultSetMappings().move(0, 1);
        resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Address", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMappings.hasNext());
        procedureQueryResource.getResultSetMappings().remove(1);
        resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Employee", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMappings.hasNext());
        procedureQueryResource.getResultSetMappings().remove(1);
        resultSetMappings = ormProcedureQuery.getResultSetMappings().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"Project", (String)((String)resultSetMappings.next()));
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)resultSetMappings.hasNext());
        procedureQueryResource.getResultSetMappings().remove(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)ormProcedureQuery.getResultSetMappings().iterator().hasNext());
    }

    public void testAddHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        OrmQueryHint queryHint = ormProcedureQuery.addHint(0);
        queryHint.setName("FOO");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        OrmQueryHint queryHint2 = ormProcedureQuery.addHint(0);
        queryHint2.setName("BAR");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlQueryHint)procedureQueryResource.getHints().get(1)).getName());
        OrmQueryHint queryHint3 = ormProcedureQuery.addHint(1);
        queryHint3.setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlQueryHint)procedureQueryResource.getHints().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlQueryHint)procedureQueryResource.getHints().get(2)).getName());
        ListIterator queryHints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint2, queryHints.next());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint3, queryHints.next());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((Object)queryHint, queryHints.next());
        queryHints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)queryHints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)queryHints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)queryHints.next()).getName());
    }

    public void testRemoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addHint(0).setName("FOO");
        ormProcedureQuery.addHint(1).setName("BAR");
        ormProcedureQuery.addHint(2).setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getHints().size());
        ormProcedureQuery.removeHint(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)2, (int)procedureQueryResource.getHints().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlQueryHint)procedureQueryResource.getHints().get(1)).getName());
        ormProcedureQuery.removeHint(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)1, (int)procedureQueryResource.getHints().size());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        ormProcedureQuery.removeHint(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)0, (int)procedureQueryResource.getHints().size());
    }

    public void testMoveHint() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        ormProcedureQuery.addHint(0).setName("FOO");
        ormProcedureQuery.addHint(1).setName("BAR");
        ormProcedureQuery.addHint(2).setName("BAZ");
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((int)3, (int)procedureQueryResource.getHints().size());
        ormProcedureQuery.moveHint(2, 0);
        ListIterator hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlQueryHint)procedureQueryResource.getHints().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlQueryHint)procedureQueryResource.getHints().get(2)).getName());
        ormProcedureQuery.moveHint(0, 1);
        hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((XmlQueryHint)procedureQueryResource.getHints().get(0)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((XmlQueryHint)procedureQueryResource.getHints().get(1)).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((XmlQueryHint)procedureQueryResource.getHints().get(2)).getName());
    }

    public void testUpdateHints() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmNamedStoredProcedureQuery2_1 ormProcedureQuery = ((OrmQueryContainer2_1)ormEntity.getQueryContainer()).addNamedStoredProcedureQuery(0);
        XmlNamedStoredProcedureQuery procedureQueryResource = (XmlNamedStoredProcedureQuery)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getNamedStoredProcedureQueries().get(0);
        procedureQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        procedureQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        procedureQueryResource.getHints().add((Object)OrmFactory.eINSTANCE.createXmlQueryHint());
        ((XmlQueryHint)procedureQueryResource.getHints().get(0)).setName("FOO");
        ((XmlQueryHint)procedureQueryResource.getHints().get(1)).setName("BAR");
        ((XmlQueryHint)procedureQueryResource.getHints().get(2)).setName("BAZ");
        ListIterator hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryResource.getHints().move(2, 0);
        hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryResource.getHints().move(0, 1);
        hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAR", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryResource.getHints().remove(1);
        hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"FOO", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryResource.getHints().remove(1);
        hints = ormProcedureQuery.getHints().iterator();
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertEquals((String)"BAZ", (String)((OrmQueryHint)hints.next()).getName());
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)hints.hasNext());
        procedureQueryResource.getHints().remove(0);
        GenericOrmNamedStoredProcedureQuery2_1Tests.assertFalse((boolean)ormProcedureQuery.getHints().iterator().hasNext());
    }
}

