/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.EnumType;
import org.eclipse.jpt.jpa.core.resource.java.EnumeratedAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class EnumeratedTests
extends JpaJavaResourceModelTestCase {
    public EnumeratedTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEnumerated() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Enumerated"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated");
            }
        });
    }

    private ICompilationUnit createTestEnumeratedWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Enumerated", "javax.persistence.EnumType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Enumerated(EnumType.ORDINAL)");
            }
        });
    }

    public void testEnumerated() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)resourceField.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertNotNull((Object)enumerated);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumeratedWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)resourceField.getAnnotation("javax.persistence.Enumerated");
        EnumeratedTests.assertEquals((Object)EnumType.ORDINAL, (Object)enumerated.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestEnumerated();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        EnumeratedAnnotation enumerated = (EnumeratedAnnotation)resourceField.getAnnotation("javax.persistence.Enumerated");
        enumerated.setValue(EnumType.STRING);
        this.assertSourceContains("@Enumerated(STRING)", cu);
        enumerated.setValue(null);
        this.assertSourceDoesNotContain("@Enumerated(", cu);
        this.assertSourceContains("@Enumerated", cu);
    }
}

