/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceType;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class InheritanceTests
extends JpaJavaResourceModelTestCase {
    public InheritanceTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestInheritance() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Inheritance"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Inheritance");
            }
        });
    }

    private ICompilationUnit createTestInheritanceWithStrategy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Inheritance", "javax.persistence.InheritanceType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Inheritance(strategy = InheritanceType.JOINED)");
            }
        });
    }

    public void testInheritance() throws Exception {
        ICompilationUnit cu = this.createTestInheritance();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)resourceType.getAnnotation("javax.persistence.Inheritance");
        InheritanceTests.assertNotNull((Object)inheritance);
    }

    public void testGetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestInheritanceWithStrategy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)resourceType.getAnnotation("javax.persistence.Inheritance");
        InheritanceTests.assertEquals((Object)InheritanceType.JOINED, (Object)inheritance.getStrategy());
    }

    public void testSetStrategy() throws Exception {
        ICompilationUnit cu = this.createTestInheritance();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        InheritanceAnnotation inheritance = (InheritanceAnnotation)resourceType.getAnnotation("javax.persistence.Inheritance");
        inheritance.setStrategy(InheritanceType.TABLE_PER_CLASS);
        this.assertSourceContains("@Inheritance(strategy = TABLE_PER_CLASS)", cu);
        inheritance.setStrategy(null);
        this.assertSourceDoesNotContain("strategy", cu);
    }
}

