/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.XmlAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.XmlJavaTypeAdapter;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.resource.java.XmlJavaTypeAdapterAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaAttributeXmlJavaTypeAdapterTests
extends JaxbContextModelTestCase {
    public GenericJavaAttributeXmlJavaTypeAdapterTests(String name) {
        super(name);
    }

    private ICompilationUnit createClassWithXmlTypeAndAttributeXmlJavaTypeAdapter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlAttribute", "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlAttribute").append(CR);
                sb.append("@XmlJavaTypeAdapter");
            }
        });
    }

    public void testModifyValue() throws Exception {
        this.createClassWithXmlTypeAndAttributeXmlJavaTypeAdapter();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        XmlAttributeMapping attributeMapping = (XmlAttributeMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = attributeMapping.getXmlJavaTypeAdapter();
        JavaResourceAttribute resourceAttribute = ((JavaAttributeMapping)attributeMapping).getJavaResourceAttribute();
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getValue());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getValue());
        contextXmlJavaTypeAdapter.setValue(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getValue());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
    }

    public void testUpdateValue() throws Exception {
        this.createClassWithXmlTypeAndAttributeXmlJavaTypeAdapter();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        XmlAttributeMapping attributeMapping = (XmlAttributeMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = attributeMapping.getXmlJavaTypeAdapter();
        JavaResourceAttribute resourceAttribute = ((JavaAttributeMapping)attributeMapping).getJavaResourceAttribute();
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getValue());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaAttributeXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "value", "String");
            }
        });
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getValue());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaAttributeXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
    }

    public void testModifyType() throws Exception {
        this.createClassWithXmlTypeAndAttributeXmlJavaTypeAdapter();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        XmlAttributeMapping attributeMapping = (XmlAttributeMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = attributeMapping.getXmlJavaTypeAdapter();
        JavaResourceAttribute resourceAttribute = ((JavaAttributeMapping)attributeMapping).getJavaResourceAttribute();
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getDefaultType());
        contextXmlJavaTypeAdapter.setSpecifiedType("foo");
        XmlJavaTypeAdapterAnnotation javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)javaTypeAdapterAnnotation.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"foo", (String)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getDefaultType());
        contextXmlJavaTypeAdapter.setSpecifiedType(null);
        javaTypeAdapterAnnotation = (XmlJavaTypeAdapterAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)javaTypeAdapterAnnotation.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getDefaultType());
    }

    public void testUpdateType() throws Exception {
        this.createClassWithXmlTypeAndAttributeXmlJavaTypeAdapter();
        JavaClass jaxbClass = (JavaClass)this.getContextRoot().getJavaType("test.AnnotationTestType");
        JavaClassMapping classMapping = jaxbClass.getMapping();
        XmlAttributeMapping attributeMapping = (XmlAttributeMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        XmlJavaTypeAdapter contextXmlJavaTypeAdapter = attributeMapping.getXmlJavaTypeAdapter();
        JavaResourceAttribute resourceAttribute = ((JavaAttributeMapping)attributeMapping).getJavaResourceAttribute();
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getDefaultType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaAttributeXmlJavaTypeAdapterTests.this.addXmlJavaTypeAdapterTypeMemberValuePair(declaration, "type", "String");
            }
        });
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getSpecifiedType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"String", (String)contextXmlJavaTypeAdapter.getType());
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertEquals((String)"int", (String)contextXmlJavaTypeAdapter.getDefaultType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaAttributeXmlJavaTypeAdapterTests.this.removeXmlJavaTypeAdapterAnnotation(declaration);
            }
        });
        GenericJavaAttributeXmlJavaTypeAdapterTests.assertNull((Object)attributeMapping.getXmlJavaTypeAdapter());
    }

    protected void addXmlJavaTypeAdapterTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlJavaTypeAdapterMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlJavaTypeAdapterAnnotation(declaration), name, value);
    }

    protected void removeXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }

    protected Annotation getXmlJavaTypeAdapterAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    }
}

