/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnum;
import org.eclipse.jpt.common.core.resource.java.JavaResourceEnumConstant;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlEnumValueAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlEnumValueAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String XML_ENUM_VALUE_VALUE = "myEnumValue";

    public XmlEnumValueAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlEnumValue() throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlEnumValue"});
            }

            public void appendSundayEnumConstantAnnotationTo(StringBuilder sb) {
                sb.append("@XmlEnumValue");
            }
        });
    }

    private ICompilationUnit createTestXmlEnumValueWithValue() throws Exception {
        return this.createTestXmlEnumValueWithStringElement("value", XML_ENUM_VALUE_VALUE);
    }

    private ICompilationUnit createTestXmlEnumValueWithStringElement(final String element, final String value) throws Exception {
        return this.createTestEnum((AnnotationTestCase.EnumAnnotationWriter)new AnnotationTestCase.DefaultEnumAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlEnumValue"});
            }

            public void appendSundayEnumConstantAnnotationTo(StringBuilder sb) {
                sb.append("@XmlEnumValue(" + element + " = \"" + value + "\")");
            }
        });
    }

    public void testGetXmlEnumValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnumValue();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        JavaResourceEnumConstant enumConstant = this.getEnumConstant(resourceEnum, 0);
        XmlEnumValueAnnotation xmlEnumValueAnnotation = (XmlEnumValueAnnotation)enumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        XmlEnumValueAnnotationTests.assertTrue((xmlEnumValueAnnotation != null ? 1 : 0) != 0);
        enumConstant.removeAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        this.assertSourceDoesNotContain("@XmlEnumValue", cu);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnumValueWithValue();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        JavaResourceEnumConstant enumConstant = this.getEnumConstant(resourceEnum, 0);
        XmlEnumValueAnnotation xmlEnumValueAnnotation = (XmlEnumValueAnnotation)enumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        XmlEnumValueAnnotationTests.assertTrue((xmlEnumValueAnnotation != null ? 1 : 0) != 0);
        XmlEnumValueAnnotationTests.assertEquals((String)XML_ENUM_VALUE_VALUE, (String)xmlEnumValueAnnotation.getValue());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnumValue();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        JavaResourceEnumConstant enumConstant = this.getEnumConstant(resourceEnum, 0);
        XmlEnumValueAnnotation xmlEnumValueAnnotation = (XmlEnumValueAnnotation)enumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        XmlEnumValueAnnotationTests.assertTrue((xmlEnumValueAnnotation != null ? 1 : 0) != 0);
        XmlEnumValueAnnotationTests.assertNull((Object)xmlEnumValueAnnotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestXmlEnumValue();
        JavaResourceEnum resourceEnum = this.buildJavaResourceEnum(cu);
        JavaResourceEnumConstant enumConstant = this.getEnumConstant(resourceEnum, 0);
        XmlEnumValueAnnotation xmlEnumValueAnnotation = (XmlEnumValueAnnotation)enumConstant.getAnnotation("javax.xml.bind.annotation.XmlEnumValue");
        XmlEnumValueAnnotationTests.assertNull((Object)xmlEnumValueAnnotation.getValue());
        xmlEnumValueAnnotation.setValue(XML_ENUM_VALUE_VALUE);
        XmlEnumValueAnnotationTests.assertEquals((String)XML_ENUM_VALUE_VALUE, (String)xmlEnumValueAnnotation.getValue());
        this.assertSourceContains("@XmlEnumValue(\"myEnumValue\")", cu);
        xmlEnumValueAnnotation.setValue(null);
        XmlEnumValueAnnotationTests.assertNull((Object)xmlEnumValueAnnotation.getValue());
        this.assertSourceDoesNotContain("@XmlEnumValue(", cu);
    }
}

