/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlRegistryAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlRegistryAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlRegistryAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlRegistry() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlRegistry"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlRegistry");
            }
        });
    }

    public void testGetXmlRegistry() throws Exception {
        ICompilationUnit cu = this.createTestXmlRegistry();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        XmlRegistryAnnotation xmlRegistryAnnotation = (XmlRegistryAnnotation)resourceType.getAnnotation("javax.xml.bind.annotation.XmlRegistry");
        XmlRegistryAnnotationTests.assertTrue((xmlRegistryAnnotation != null ? 1 : 0) != 0);
        resourceType.removeAnnotation("javax.xml.bind.annotation.XmlRegistry");
        this.assertSourceDoesNotContain("@XmlRegistry", cu);
    }
}

