/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlSchemaTypePackageAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String TEST_NAME = "foo";
    private static final String TEST_NAME_2 = "bar";
    private static final String TEST_NAMESPACE = "http://www.eclipse.org/test/schema";
    private static final String TEST_NAMESPACE_2 = "http://www.eclipse.org/test/schema2";
    private static final String TEST_CLASS = GregorianCalendar.class.getSimpleName();
    private static final String TEST_CLASS_2 = Date.class.getSimpleName();
    private static final String FQ_TEST_CLASS = GregorianCalendar.class.getName();
    private static final String FQ_TEST_CLASS_2 = Date.class.getName();

    public XmlSchemaTypePackageAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithSchemaType() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaType", new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
    }

    private ICompilationUnit createPackageInfoWithSchemaTypeAndName() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaType(name = \"foo\")", new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
    }

    private ICompilationUnit createPackageInfoWithSchemaTypeAndNamespace() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")", new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
    }

    private ICompilationUnit createPackageInfoWithSchemaTypeAndType() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaType(type = " + TEST_CLASS + ".class)", new String[]{"javax.xml.bind.annotation.XmlSchemaType", FQ_TEST_CLASS, FQ_TEST_CLASS_2});
    }

    private ICompilationUnit createPackageInfoWithSchemaTypes() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaTypes({@XmlSchemaType,@XmlSchemaType})", new String[]{"javax.xml.bind.annotation.XmlSchemaTypes", "javax.xml.bind.annotation.XmlSchemaType", FQ_TEST_CLASS, FQ_TEST_CLASS_2});
    }

    public void testName() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypeAndName();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypePackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAME, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"foo\")", cu);
        annotation.setName(TEST_NAME_2);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAME_2, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"bar\")", cu);
        annotation.setName(null);
        XmlSchemaTypePackageAnnotationTests.assertEquals(null, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setName(TEST_NAME);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAME, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"foo\")", cu);
    }

    public void testNamespace() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypeAndNamespace();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypePackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")", cu);
        annotation.setNamespace(TEST_NAMESPACE_2);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAMESPACE_2, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema2\")", cu);
        annotation.setNamespace(null);
        XmlSchemaTypePackageAnnotationTests.assertEquals(null, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setNamespace(TEST_NAMESPACE);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")", cu);
    }

    public void testType() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypeAndType();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypePackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS + ".class)", cu);
        annotation.setType(TEST_CLASS_2);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS_2, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS_2 + ".class)", cu);
        annotation.setType(null);
        XmlSchemaTypePackageAnnotationTests.assertEquals(null, (String)annotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertEquals(null, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setType(TEST_CLASS);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS + ".class)", cu);
    }

    public void testContainedWithName() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypes();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation containedAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        containedAnnotation.setName(TEST_NAME);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAME, (String)containedAnnotation.getName());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType(name = \"foo\"),@XmlSchemaType})", cu);
        containedAnnotation.setName(null);
        XmlSchemaTypePackageAnnotationTests.assertNull((Object)containedAnnotation.getName());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType,@XmlSchemaType})", cu);
    }

    public void testContainedWithNamespace() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypes();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation containedAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        containedAnnotation.setNamespace(TEST_NAMESPACE);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)containedAnnotation.getNamespace());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\"),@XmlSchemaType})", cu);
        containedAnnotation.setNamespace(null);
        XmlSchemaTypePackageAnnotationTests.assertNull((Object)containedAnnotation.getNamespace());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType,@XmlSchemaType})", cu);
    }

    public void testContainedWithType() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaTypes();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypeAnnotation containedAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(1, "javax.xml.bind.annotation.XmlSchemaType");
        containedAnnotation.setType(TEST_CLASS);
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)TEST_CLASS, (String)containedAnnotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)containedAnnotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType,@XmlSchemaType(type = " + TEST_CLASS + ".class)})", cu);
        containedAnnotation.setType(null);
        XmlSchemaTypePackageAnnotationTests.assertNull((Object)containedAnnotation.getType());
        XmlSchemaTypePackageAnnotationTests.assertNull((String)FQ_TEST_CLASS, (Object)containedAnnotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaTypes({@XmlSchemaType,@XmlSchemaType})", cu);
    }

    public void testContained() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithSchemaType();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlSchemaTypePackageAnnotationTests.assertEquals((int)1, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        resourcePackage.addAnnotation(1, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypePackageAnnotationTests.assertEquals((int)2, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        this.assertSourceContains("@XmlSchemaTypes({ @XmlSchemaType, @XmlSchemaType })", cu);
        XmlSchemaTypeAnnotation containedAnnotation1 = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        containedAnnotation1.setName(TEST_NAME);
        XmlSchemaTypeAnnotation containedAnnotation2 = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(1, "javax.xml.bind.annotation.XmlSchemaType");
        containedAnnotation2.setName(TEST_NAME_2);
        this.assertSourceContains("@XmlSchemaTypes({ @XmlSchemaType(name = \"foo\"), @XmlSchemaType(name = \"bar\") })", cu);
        resourcePackage.moveAnnotation(0, 1, "javax.xml.bind.annotation.XmlSchemaType");
        this.assertSourceContains("@XmlSchemaTypes({ @XmlSchemaType(name = \"bar\"), @XmlSchemaType(name = \"foo\") })", cu);
        resourcePackage.removeAnnotation(1, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypePackageAnnotationTests.assertEquals((int)1, (int)resourcePackage.getAnnotationsSize("javax.xml.bind.annotation.XmlSchemaType"));
        this.assertSourceContains("@XmlSchemaType(name = \"bar\")", cu);
        this.assertSourceDoesNotContain("@XmlSchemaTypes", cu);
    }
}

