/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.contentmodel;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAnyElement;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMContent;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMEntityDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;

public class CMPrinter
extends CMVisitor {
    protected StringBuffer fStringBuffer = new StringBuffer();
    protected Vector visitedElements = new Vector();
    protected String indent = "";

    protected void incrementIndent() {
        this.indent = String.valueOf(this.indent) + "  ";
    }

    protected void decrementIndent() {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    public void printCMNode(String filename, CMNode cmnode) {
        this.visitCMNode(cmnode);
        try {
            FileOutputStream fileStream = new FileOutputStream(filename);
            OutputStreamWriter writer = new OutputStreamWriter(fileStream);
            writer.write(this.fStringBuffer.toString());
            writer.flush();
            fileStream.close();
        }
        catch (IOException e) {
            Logger.logException((String)"PMPrinter Debug: ", (Throwable)e);
        }
    }

    public void visitCMAnyElement(CMAnyElement anyElement) {
        this.fStringBuffer.append(String.valueOf(this.indent) + "<CMAnyElement");
        this.printAttributes(this.fStringBuffer, (CMNode)anyElement);
        this.fStringBuffer.append(">/n");
        this.incrementIndent();
        this.printProperties(this.fStringBuffer, (CMNode)anyElement);
        this.decrementIndent();
        this.fStringBuffer.append(String.valueOf(this.indent) + "</CMAnyElement>/n");
    }

    public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
        this.fStringBuffer.append(String.valueOf(this.indent) + "<CMAttributeDeclaration");
        this.printAttributes(this.fStringBuffer, (CMNode)ad);
        this.fStringBuffer.append(">\n");
        this.incrementIndent();
        this.printProperties(this.fStringBuffer, (CMNode)ad);
        this.decrementIndent();
        this.visitCMNode((CMNode)ad.getAttrType());
        this.fStringBuffer.append(String.valueOf(this.indent) + "</CMAttributeDeclaration>\n");
    }

    public void visitCMDataType(CMDataType dataType) {
        this.fStringBuffer.append(String.valueOf(this.indent) + "<CMDataType");
        this.printAttributes(this.fStringBuffer, (CMNode)dataType);
        this.fStringBuffer.append(">\n");
        this.incrementIndent();
        this.fStringBuffer.append(String.valueOf(this.indent) + "<ImpliedValue kind=\"" + dataType.getImpliedValueKind() + "\">");
        this.fStringBuffer.append(String.valueOf(dataType.getImpliedValue()) + "</ImpliedValue>\n");
        this.printEnumeration(this.fStringBuffer, dataType.getEnumeratedValues());
        this.decrementIndent();
        this.fStringBuffer.append(String.valueOf(this.indent) + "</CMDataType>\n");
    }

    public void visitCMDocument(CMDocument document) {
        this.fStringBuffer.append(String.valueOf(this.indent) + "<CMDocument");
        this.printAttributes(this.fStringBuffer, (CMNode)document);
        this.fStringBuffer.append(">\n");
        this.incrementIndent();
        this.printProperties(this.fStringBuffer, (CMNode)document);
        CMNamedNodeMap map = document.getElements();
        int size = map.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(map.item(i));
            ++i;
        }
        this.decrementIndent();
        this.fStringBuffer.append(String.valueOf(this.indent) + "</CMDocument>\n");
    }

    public void visitCMGroup(CMGroup group) {
        this.fStringBuffer.append(String.valueOf(this.indent) + "<CMGroup");
        this.printAttributes(this.fStringBuffer, (CMNode)group);
        this.fStringBuffer.append(">\n");
        this.incrementIndent();
        CMNodeList nodeList = group.getChildNodes();
        int size = nodeList.getLength();
        int i = 0;
        while (i < size) {
            this.visitCMNode(nodeList.item(i));
            ++i;
        }
        this.decrementIndent();
        this.fStringBuffer.append(String.valueOf(this.indent) + "</CMGroup>\n");
    }

    public void visitCMElementDeclaration(CMElementDeclaration ed) {
        if (!this.visitedElements.contains(ed)) {
            this.visitedElements.add(ed);
            this.fStringBuffer.append(String.valueOf(this.indent) + "<CMElementDeclaration");
            this.printAttributes(this.fStringBuffer, (CMNode)ed);
            this.fStringBuffer.append(">\n");
            this.incrementIndent();
            this.printProperties(this.fStringBuffer, (CMNode)ed);
            CMNamedNodeMap nodeMap = ed.getAttributes();
            int size = nodeMap.getLength();
            int i = 0;
            while (i < size) {
                this.visitCMNode(nodeMap.item(i));
                ++i;
            }
            this.visitCMNode((CMNode)ed.getContent());
            CMDataType dataType = ed.getDataType();
            if (dataType != null) {
                this.visitCMNode((CMNode)dataType);
            }
            this.decrementIndent();
            this.fStringBuffer.append(String.valueOf(this.indent) + "</CMElementDeclaration>\n");
        }
    }

    public void printEnumeration(StringBuffer sb, String[] values) {
        if (values != null && values.length > 0) {
            sb.append(String.valueOf(this.indent) + "<Enumeration>\n");
            this.incrementIndent();
            int i = 0;
            while (i < values.length) {
                sb.append(String.valueOf(this.indent) + "<Value>" + values[i] + "</Values>\n");
                ++i;
            }
            this.decrementIndent();
            sb.append(String.valueOf(this.indent) + "</Enumeration>\n");
        }
    }

    public void printAttributes(StringBuffer sb, CMNode cmnode) {
        if (cmnode != null) {
            sb.append(" nodeName=\"" + cmnode.getNodeName() + "\"");
            sb.append(" nodeType=\"" + cmnode.getNodeType() + "\"");
            if (cmnode instanceof CMContent) {
                sb.append(" minOccur=\"" + ((CMContent)cmnode).getMinOccur() + "\"");
                sb.append(" maxOccur=\"" + ((CMContent)cmnode).getMaxOccur() + "\"");
            }
            if (cmnode instanceof CMAnyElement) {
                sb.append(" namespaceURI=\"" + ((CMAnyElement)cmnode).getNamespaceURI() + "\"");
            }
            if (cmnode instanceof CMAttributeDeclaration) {
                sb.append(" uasage=\"" + ((CMAttributeDeclaration)cmnode).getUsage() + "\"");
                sb.append(" defaultValue=\"" + ((CMAttributeDeclaration)cmnode).getDefaultValue() + "\"");
            }
            if (cmnode instanceof CMDataType) {
                sb.append(" instanceValue=\"" + ((CMDataType)cmnode).generateInstanceValue() + "\"");
            }
            if (cmnode instanceof CMEntityDeclaration) {
                String value = ((CMEntityDeclaration)cmnode).getValue();
                if (value.indexOf("\"") == -1) {
                    sb.append(" value=\"" + value + "\"");
                } else {
                    sb.append(" value=\"" + value + "\"");
                }
            }
            if (cmnode instanceof CMGroup) {
                sb.append(" operator=\"" + ((CMGroup)cmnode).getOperator() + "\"");
            }
            if (cmnode instanceof CMElementDeclaration) {
                sb.append(" contentType=\"" + ((CMElementDeclaration)cmnode).getContentType() + "\"");
            }
        }
    }

    public void printEntities(StringBuffer sb, CMNamedNodeMap entities) {
        if (entities != null && entities.getLength() > 0) {
            sb.append(String.valueOf(this.indent) + "<Entities>\n");
            this.incrementIndent();
            Iterator i = entities.iterator();
            while (i.hasNext()) {
                CMEntityDeclaration entity = (CMEntityDeclaration)i.next();
                sb.append(String.valueOf(this.indent) + "<Entity");
                this.printAttributes(sb, (CMNode)entity);
                sb.append("/>\n");
            }
            this.decrementIndent();
            sb.append(String.valueOf(this.indent) + "</Entities>\n");
        }
    }

    public void printProperties(StringBuffer sb, CMNode cmnode) {
        List properties = this.getProperties(cmnode);
        sb.append(String.valueOf(this.indent) + "<Properties>\n");
        this.incrementIndent();
        int i = 0;
        while (i < properties.size()) {
            String property = (String)properties.get(i);
            sb.append(String.valueOf(this.indent) + "<Property name=\"" + property + "\"");
            if (cmnode.supports(property)) {
                sb.append(" supports=\"true\"");
            } else {
                sb.append(" supports=\"false\"");
            }
            Object value = cmnode.getProperty(property);
            if (value instanceof String) {
                sb.append(" value=\"" + (String)value + "\"");
            } else if (value instanceof Boolean) {
                sb.append(" value=\"" + value + "\"");
            } else if (value != null) {
                sb.append(" value=\"" + value.getClass() + "\"");
            } else {
                sb.append(" value=\"null\"");
            }
            sb.append("/>\n");
            ++i;
        }
        this.decrementIndent();
        sb.append(String.valueOf(this.indent) + "</Properties>\n");
    }

    public List getProperties(CMNode cmnode) {
        Vector<String> properties = new Vector<String>();
        if (cmnode != null) {
            properties.add("CMDocument");
            properties.add("documentation");
            properties.add("http://org.eclipse.wst/cm/properties/usesLocalElementDeclarations");
            properties.add("http://org.eclipse.wst/cm/properties/isNameSpaceAware");
            properties.add("http://org.eclipse.wst/cm/properties/nsPrefixQualification");
            properties.add("http://org.eclipse.wst/cm/properties/nillable");
            properties.add("http://org.eclipse.wst/cm/properties/mofNotifier");
            properties.add("spec");
            if (cmnode instanceof CMElementDeclaration) {
                properties.add("http://org.eclipse.wst/cm/properties/definitionInfo");
                properties.add("http://org.eclipse.wst/cm/properties/definition");
                properties.add("XSITypes");
                properties.add("DerivedElementDeclaration");
                properties.add("Abstract");
            }
            if (cmnode instanceof CMDocument) {
                properties.add("http://org.eclipse.wst/cm/properties/targetNamespaceURI");
                properties.add("http://org.eclipse.wst/cm/properties/importedNamespaceInfo");
                properties.add("http://org.eclipse.wst/cm/properties/namespaceInfo");
                properties.add("http://org.eclipse.wst/cm/properties/elementFormDefault");
                properties.add("annotationMap");
            }
        }
        return properties;
    }
}

