/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation.ValidationTestsSetUp;

public class SeiValidationTest
extends ValidationTestsSetUp {
    protected IType seiType;

    public void setUp() throws Exception {
        super.setUp();
        this.seiType = this.testProject.createType(this.testPack, "Sei.java", "@javax.jws.WebService(name=\"SeiName\") public interface Sei {}");
        this.testProject.build(10);
    }

    public void testServiceNameIsNCName() throws CoreException {
        SeiValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        this.assertNoValidationErrors(this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"---\") public interface Sei {}");
        HashMap<String, Object> markerProps = new HashMap<String, Object>();
        markerProps.put("charStart", 41);
        markerProps.put("charEnd", 46);
        markerProps.put("lineNumber", 2);
        markerProps.put("severity", 2);
        markerProps.put("message", MessageFormat.format(JAXWSCoreMessages.INVALID_NCNAME_ATTRIBUTE, "WebService", "name", "---"));
        ValidationTestsSetUp.MarkerData markersData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerProps);
        this.validateResourceMarkers(this.seiType.getResource(), markersData);
    }

    public void testTargetNsIsValidUri() throws CoreException {
        SeiValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        this.assertNoValidationErrors(this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(targetNamespace=\"^^^\") public interface Sei {}");
        HashMap<String, Object> markerProps = new HashMap<String, Object>();
        markerProps.put("charStart", 52);
        markerProps.put("charEnd", 57);
        markerProps.put("severity", 2);
        markerProps.put("message", MessageFormat.format(JAXWSCoreMessages.TARGET_NAMESPACE_URI_SYNTAX_ERROR, "0", "^^^", "Illegal character in path"));
        ValidationTestsSetUp.MarkerData markersData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerProps);
        this.validateResourceMarkers(this.seiType.getResource(), markersData);
    }

    public void testRedundandAttributesOnExplicitSei() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"Name\", portName=\"PortName\") public interface Sei {}");
        SeiValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> markerProps = new HashMap<String, Object>();
        markerProps.put("charStart", 58);
        markerProps.put("charEnd", 68);
        markerProps.put("severity", 2);
        markerProps.put("message", JAXWSCoreMessages.WEBSERVICE_PORTNAME_SEI);
        ValidationTestsSetUp.MarkerData markersData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerProps);
        this.validateResourceMarkers(this.seiType.getResource(), markersData);
    }

    public void testSeiClassCorrectExplicitSei() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService interface Sei {}");
        SeiValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> markerProps = new HashMap<String, Object>();
        markerProps.put("charStart", 46);
        markerProps.put("charEnd", 49);
        markerProps.put("severity", 2);
        markerProps.put("message", JAXWSCoreMessages.WEBSERVICE_PUBLIC_ABSTRACT_FINAL);
        ValidationTestsSetUp.MarkerData markersData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerProps);
        this.validateResourceMarkers(this.seiType.getResource(), markersData);
    }

    public void testSeiClassCorrectImplicitSei() throws CoreException {
        this.testProject.createType(this.testPack, "Ws.java", "@javax.jws.WebService public class Ws {}");
        SeiValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        this.assertNoValidationErrors(this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem");
    }
}

