/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.sse.core.tests.SSEModelTestsPlugin;

public class TestJarUtilities
extends TestCase {
    private static final String[] fExpectedNames = new String[]{".project", "about.html", "build.properties", "plugin.properties", "test.xml"};
    private static final String TEST_JAR_UTILITIES_PROJECT = "TestJarUtilities";
    private static final String TEST_JAR_UTILITIES_TESTFILE_JAR = "testfile.jar";
    private static final String TESTFILE_BUNDLE_ENTRY = "resources/testfile.jar";

    static IFile _copyBundleEntryIntoWorkspace(String entryname, String fullPath) throws Exception {
        IFile file = null;
        URL entry = SSEModelTestsPlugin.getDefault().getBundle().getEntry(entryname);
        if (entry != null) {
            Path path = new Path(fullPath);
            byte[] b = new byte[2048];
            InputStream input = entry.openStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int i = -1;
            while ((i = input.read(b)) > -1) {
                output.write(b, 0, i);
            }
            file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null) {
                if (!file.exists()) {
                    file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.setContents((InputStream)new ByteArrayInputStream(output.toByteArray()), true, false, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        } else {
            System.err.println("can't find " + entryname);
        }
        return file;
    }

    static IFile copyBundleEntryIntoWorkspace(final String entryname, final String fullPath) throws Exception {
        final IFile[] file = new IFile[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    file[0] = TestJarUtilities._copyBundleEntryIntoWorkspace(entryname, fullPath);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, SSEModelTestsPlugin.getDefault().getBundle().getSymbolicName(), 0, null, (Throwable)e));
                }
                ResourcesPlugin.getWorkspace().checkpoint(true);
            }
        };
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        return file[0];
    }

    static IProject createSimpleProject(String name) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    public TestJarUtilities() {
        super("JarUtilities Tests");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readContents(InputStream is) {
        String charset = "iso-8859-1";
        StringBuffer s = new StringBuffer();
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader(is, charset);
                char[] readBuffer = new char[2048];
                int n = reader.read(readBuffer);
                while (n > 0) {
                    s.append(readBuffer, 0, n);
                    n = reader.read(readBuffer);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (is != null) {
                    is.close();
                }
                if (reader == null) throw throwable;
                ((Reader)reader).close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (Exception exception) {
            return s.toString();
        }
        if (is != null) {
            is.close();
        }
        if (reader == null) return s.toString();
        ((Reader)reader).close();
        return s.toString();
    }

    protected void setUp() throws Exception {
        super.setUp();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
        if (!project.isAccessible()) {
            project = TestJarUtilities.createSimpleProject(this.getName());
            TestJarUtilities.copyBundleEntryIntoWorkspace(TESTFILE_BUNDLE_ENTRY, this.getJarFile().getFullPath().toString());
        }
    }

    private IFile getJarFile() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
        return project.getFile(TEST_JAR_UTILITIES_TESTFILE_JAR);
    }

    protected void tearDown() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
        project.delete(true, null);
        super.tearDown();
    }

    public void testEntryCountFromFilesystem() {
        String[] entryNames = JarUtilities.getEntryNames((String)this.getJarFile().getLocation().toString());
        TestJarUtilities.assertEquals((String)"incorrect number of entries", (int)5, (int)entryNames.length);
    }

    public void testEntryCountFromMissingFile() {
        String[] names = JarUtilities.getEntryNames((String)"TestJarUtilities/nonexistent.jar");
        TestJarUtilities.assertNotNull((String)"null names", (Object)names);
        TestJarUtilities.assertEquals((String)"entries returned for missing file", (int)0, (int)names.length);
    }

    public void testEntryCountFromWorkspace() {
        String[] entryNames = JarUtilities.getEntryNames((IResource)this.getJarFile());
        TestJarUtilities.assertEquals((String)"incorrect number of entries", (int)5, (int)entryNames.length);
    }

    public void testEntryCountWithDirectoriesFromFilesystem() {
        String[] entryNames = JarUtilities.getEntryNames((String)this.getJarFile().getLocation().toString(), (boolean)false);
        TestJarUtilities.assertEquals((String)"incorrect number of entries", (int)6, (int)entryNames.length);
    }

    public void testEntryNamesFromFilesystem() {
        String[] entryNames = JarUtilities.getEntryNames((String)this.getJarFile().getLocation().toString());
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(entryNames));
        int i = 0;
        while (i < fExpectedNames.length) {
            TestJarUtilities.assertTrue((String)("missing name of entry: " + fExpectedNames[i]), (boolean)names.contains(fExpectedNames[i]));
            ++i;
        }
    }

    public void testEntryNamesFromWorkspace() {
        String[] entryNames = JarUtilities.getEntryNames((IResource)this.getJarFile());
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(entryNames));
        int i = 0;
        while (i < fExpectedNames.length) {
            TestJarUtilities.assertTrue((String)("missing name of entry: " + fExpectedNames[i]), (boolean)names.contains(fExpectedNames[i]));
            ++i;
        }
    }

    public void testEntryNamesWithDirectoriesFromFilesystem() {
        String[] entryNames = JarUtilities.getEntryNames((String)this.getJarFile().getLocation().toString(), (boolean)false);
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(entryNames));
        String[] expectedNames = new String[]{".project", "about.html", "build.properties", "plugin.properties", "test.xml"};
        int i = 0;
        while (i < expectedNames.length) {
            TestJarUtilities.assertTrue((String)("missing name of entry: " + entryNames[i]), (boolean)names.contains(entryNames[i]));
            ++i;
        }
        TestJarUtilities.assertTrue((String)"missing name of folder entry: empty/", (boolean)names.contains("empty/"));
    }

    public void testReadFromFilesystem() {
        String location = this.getJarFile().getLocation().toString();
        String contents = this.readContents(JarUtilities.getInputStream((String)location, (String)"plugin.properties"));
        TestJarUtilities.assertNotNull((String)"no contents loaded", (Object)contents);
        TestJarUtilities.assertTrue((String)"not enough contents read", (contents.length() > 40 ? 1 : 0) != 0);
        TestJarUtilities.assertTrue((String)("contents not as expected" + contents.substring(0, 40)), (boolean)contents.startsWith("##########################################################"));
    }

    public void testReadFromMissingFile() {
        InputStream contents = JarUtilities.getInputStream((String)"TestJarUtilities/nonexistent.jar", (String)"plugin.properties");
        TestJarUtilities.assertNull((String)"contents loaded", (Object)contents);
    }

    public void testReadFromSupportedURL() throws MalformedURLException {
        String location = this.getJarFile().getLocation().toString();
        String contents = this.readContents(JarUtilities.getInputStream((URL)new URL("jar:file:" + location + "!/plugin.properties")));
        TestJarUtilities.assertNotNull((String)"no contents loaded", (Object)contents);
        TestJarUtilities.assertTrue((String)"not enough contents read", (contents.length() > 0 ? 1 : 0) != 0);
        TestJarUtilities.assertTrue((String)"contents not as expected", (boolean)contents.startsWith("##########################################################"));
    }

    public void testReadFromUnsupportedURL() {
        URL entry = SSEModelTestsPlugin.getDefault().getBundle().getEntry("about.html");
        TestJarUtilities.assertNotNull((String)"null URL to about.html", (Object)entry);
        InputStream inputStream = JarUtilities.getInputStream((URL)entry);
        TestJarUtilities.assertNotNull((String)("null input stream to " + entry), (Object)inputStream);
        String contents = this.readContents(inputStream);
        TestJarUtilities.assertNotNull((String)"no contents loaded", (Object)contents);
        TestJarUtilities.assertTrue((String)("not enough contents read. Contents Length was " + contents.length() + " but expected more than 750."), (contents.length() > 750 ? 1 : 0) != 0);
        TestJarUtilities.assertTrue((String)("contents not as expected" + contents.substring(0, 75)), (contents.indexOf("DOCTYPE") > 0 ? 1 : 0) != 0);
    }

    public void testReadFromWorkspace() {
        IFile jar = this.getJarFile();
        String contents = this.readContents(JarUtilities.getInputStream((IResource)jar, (String)"plugin.properties"));
        TestJarUtilities.assertNotNull((String)"no contents loaded", (Object)contents);
        TestJarUtilities.assertTrue((String)"not enough contents read", (contents.length() > 40 ? 1 : 0) != 0);
        TestJarUtilities.assertTrue((String)("contents not as expected" + contents.substring(0, 40)), (boolean)contents.startsWith("##########################################################"));
    }
}

