/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.java.JavaIdMapping;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.persistence.Generic2_0JpaMetadataConversionTests;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvertibleMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkStructConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_2ContextModelTestCase;

public class EclipseLink2_2JpaMetadataConversionTests
extends EclipseLink2_2ContextModelTestCase {
    private IProgressMonitor progressMonitor;

    public EclipseLink2_2JpaMetadataConversionTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.progressMonitor = new IProgressMonitor(){

            public void worked(int work) {
            }

            public void subTask(String name) {
            }

            public void setTaskName(String name) {
            }

            public void setCanceled(boolean value) {
            }

            public boolean isCanceled() {
                return false;
            }

            public void internalWorked(double work) {
            }

            public void done() {
            }

            public void beginTask(String name, int totalWork) {
            }
        };
    }

    @Override
    protected void tearDown() throws Exception {
        this.progressMonitor = null;
        super.tearDown();
    }

    private ICompilationUnit createTestEntityWithDuplicateQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.NamedQuery", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedQuery(name=\"nquery\")").append(CR);
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"nnq1\", query=\"abcd\"), @NamedNativeQuery(name=\"nnq1\", query=\"abcde\")})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEquivalentQueries() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.NamedNativeQueries", "javax.persistence.NamedNativeQuery", "javax.persistence.QueryHint"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@NamedNativeQueries({@NamedNativeQuery(name=\"nnq1\", query=\"abcd\", resultClass=foo1.class, resultSetMapping=\"bar1\", hints={@QueryHint(name=\"nnq1hint1\", value = \"aaa\"), @QueryHint(name=\"nnq1hint2\", value=\"bbb\")}), @NamedNativeQuery(name=\"nnq1\", query=\"abcd\", resultClass=foo1.class, resultSetMapping=\"bar1\", hints={@QueryHint(name=\"nnq1hint1\", value = \"aaa\"), @QueryHint(name=\"nnq1hint2\", value=\"bbb\")})})");
            }
        });
    }

    public void testConvertDuplicateQueries() throws Exception {
        this.createTestEntityWithDuplicateQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaQueries((EntityMappings)entityMappings, this.progressMonitor);
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedQueriesSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)2, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedQueriesSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
    }

    public void testConvertEquivalentQueries() throws Exception {
        this.createTestEntityWithEquivalentQueries();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaQueries((EntityMappings)entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entity.getQueryContainer().getNamedNativeQueriesSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getQueryContainer().getNamedNativeQueriesSize());
    }

    private ICompilationUnit createTestEntityWithDuplicateGenerators() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", initialValue=10)");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", initialValue=10)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", initialValue=1)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEquivalentGenerators() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.TableGenerator", "javax.persistence.SequenceGenerator"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@TableGenerator(name=\"tgen\", table=\"ID_GEN\", schema=\"APP\", catalog=\"FOO\",pkColumnName=\"GEN_NAME\", valueColumnName=\"GEN_VALUE\", pkColumnValue=\"TGEN\",allocationSize=50, initialValue=100)").append(CR);
                sb.append("@SequenceGenerator(name=\"sgen\", sequenceName=\"Foo_Seq\", schema=\"SYS\", catalog=\"BAR\",allocationSize=5, initialValue=10)");
            }
        });
    }

    public void testConvertDuplicateGenerators() throws Exception {
        this.createTestEntityWithDuplicateGenerators();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        JavaIdMapping mapping = (JavaIdMapping)entity.getIdAttribute().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaGenerators((EntityMappings)entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getSequenceGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertNotNull((Object)entity.getGeneratorContainer().getTableGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getSequenceGeneratorsSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getTableGeneratorsSize());
        EclipseLink2_2JpaMetadataConversionTests.assertNotNull((Object)mapping.getGeneratorContainer().getSequenceGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertNotNull((Object)mapping.getGeneratorContainer().getTableGenerator());
    }

    public void testConvertEquivalentGenerators() throws Exception {
        this.createTestEntityWithEquivalentGenerators();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        JavaIdMapping mapping = (JavaIdMapping)entity.getIdAttribute().getMapping();
        this.addXmlMappingFileRef("META-INF/orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaGenerators((EntityMappings)entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertNull((Object)entity.getGeneratorContainer().getSequenceGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertNull((Object)entity.getGeneratorContainer().getTableGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getSequenceGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertNull((Object)mapping.getGeneratorContainer().getTableGenerator());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getSequenceGeneratorsSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getTableGeneratorsSize());
    }

    private ICompilationUnit createTestEntityWithConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\", dataType=Number.class, objectType=Integer.class)").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\", dataType=Character.class, objectType=String.class, conversionValues={@ConversionValue(dataValue=\"m\", objectValue=\"male\"), @ConversionValue(dataValue=\"f\", objectValue=\"female\")},defaultObjectValue=\"female\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConverterOnConvertibleMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "org.eclipse.persistence.annotations.Converters", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Converters({@Converter(name = \"custom1\", converterClass=foo1.class),@Converter(name = \"custom2\", converterClass=foo2.class)})");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConverterOnCollectionMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ElementCollection", "java.util.Map", "org.eclipse.persistence.annotations.StructConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ElementCollection").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")").append(CR);
                sb.append("    private Map<String, String> projects;");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDuplicateConvertersOfDiffTypes() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\")").append(CR);
                sb.append("@ObjectTypeConverter(name=\"type\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\")");
            }
        });
    }

    private ICompilationUnit createTestEntity2WithDuplicateConvertersOfSameType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\")").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=bar.class)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEquivalentConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\")").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)");
            }
        });
    }

    public void testConvertConvertersonEntity() throws Exception {
        this.createTestEntityWithConverters();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLinkCustomConverter custom = (EclipseLinkCustomConverter)entityMappings.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo", (String)custom.getConverterClass());
        EclipseLinkTypeConverter type = (EclipseLinkTypeConverter)entityMappings.getConverterContainer().getTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"type", (String)type.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Number", (String)type.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Integer", (String)type.getObjectType());
        EclipseLinkObjectTypeConverter otype = (EclipseLinkObjectTypeConverter)entityMappings.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"otype", (String)otype.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Character", (String)otype.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.String", (String)otype.getObjectType());
        ListIterator values = otype.getConversionValues().iterator();
        EclipseLinkConversionValue value1 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"m", (String)value1.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"male", (String)value1.getObjectValue());
        EclipseLinkConversionValue value2 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"f", (String)value2.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)value2.getObjectValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)otype.getDefaultObjectValue());
        EclipseLinkStructConverter struct = (EclipseLinkStructConverter)entityMappings.getConverterContainer().getStructConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"struct", (String)struct.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"bar", (String)struct.getConverterClass());
    }

    public void testConvertConvertersOnEntityConvertibleMapping() throws Exception {
        this.createTestEntityWithConverterOnConvertibleMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)2, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getIdAttribute().getMapping();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getConvertersSize(), (int)0);
        HashBag customConverters = CollectionTools.hashBag((Iterable)entityMappings.getConverterContainer().getCustomConverters());
        EclipseLinkCustomConverter custom1 = (EclipseLinkCustomConverter)Generic2_0JpaMetadataConversionTests.selectModelNamed((Iterable)customConverters, (String)"custom1");
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom1", (String)custom1.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo1", (String)custom1.getConverterClass());
        EclipseLinkCustomConverter custom2 = (EclipseLinkCustomConverter)Generic2_0JpaMetadataConversionTests.selectModelNamed((Iterable)customConverters, (String)"custom2");
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom2", (String)custom2.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo2", (String)custom2.getConverterClass());
    }

    public void testConvertConvertersOnCollectionMapping() throws Exception {
        this.createTestEntityWithConverterOnCollectionMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        if (entity.getAttributeMappings().iterator().hasNext()) {
            EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getAttributeMappings().iterator().next();
            EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getConvertersSize(), (int)0);
        }
        EclipseLinkStructConverter custom = (EclipseLinkStructConverter)entityMappings.getConverterContainer().getStructConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"struct", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"bar", (String)custom.getConverterClass());
    }

    public void testConvertOverriddenConverters() throws Exception {
        this.createTestEntityWithDuplicateConvertersOfDiffTypes();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkOrmConverterContainer ormConvertercontainer = entityMappings.getConverterContainer();
        ormConvertercontainer.addCustomConverter("type", ormConvertercontainer.getCustomConvertersSize());
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getAttributeMappings().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertTrue((boolean)IterableTools.contains((Iterable)persistenceUnit.getConverters(), mapping.getConverterContainer().getConverters().iterator().next()));
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getTypeConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getObjectTypeConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)2, (int)ormConvertercontainer.getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)ormConvertercontainer.getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)ormConvertercontainer.getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)ormConvertercontainer.getObjectTypeConvertersSize());
    }

    public void testConvertDuplicateConvertersWithDiffTypes() throws Exception {
        this.createTestEntityWithDuplicateConvertersOfDiffTypes();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getAttributeMappings().iterator().next();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getTypeConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getObjectTypeConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
    }

    public void testConvertDuplicateConvertersWithSameType() throws Exception {
        this.createTestEntity2WithDuplicateConvertersOfSameType();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getAttributeMappings().iterator().next();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getCustomConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getCustomConvertersSize(), (int)1);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)0, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
    }

    public void testConvertEquivalentConverters() throws Exception {
        this.createTestEntityWithEquivalentConverters();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        EclipseLinkJavaEntity entity = this.getJavaEntity();
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)entity.getAttributeMappings().iterator().next();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)entity.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
    }

    private ICompilationUnit createTestEmbeddableWithConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\", dataType=Number.class, objectType=Integer.class)").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\", dataType=Character.class, objectType=String.class, conversionValues={@ConversionValue(dataValue=\"m\", objectValue=\"male\"), @ConversionValue(dataValue=\"f\", objectValue=\"female\")},defaultObjectValue=\"female\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }
        });
    }

    private ICompilationUnit createTestEmbeddableWithConverterOnConvertibleMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "javax.persistence.Version", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Version").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)");
            }
        });
    }

    public void testConvertConvertersOnEmbeddable() throws Exception {
        this.createTestEmbeddableWithConverters();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEmbeddable embeddable = this.getJavaEmbeddable();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)embeddable.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)embeddable.getConverterContainer().getTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)embeddable.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)embeddable.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLinkCustomConverter custom = (EclipseLinkCustomConverter)entityMappings.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo", (String)custom.getConverterClass());
        EclipseLinkTypeConverter type = (EclipseLinkTypeConverter)entityMappings.getConverterContainer().getTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"type", (String)type.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Number", (String)type.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Integer", (String)type.getObjectType());
        EclipseLinkObjectTypeConverter otype = (EclipseLinkObjectTypeConverter)entityMappings.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"otype", (String)otype.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Character", (String)otype.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.String", (String)otype.getObjectType());
        ListIterator values = otype.getConversionValues().iterator();
        EclipseLinkConversionValue value1 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"m", (String)value1.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"male", (String)value1.getObjectValue());
        EclipseLinkConversionValue value2 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"f", (String)value2.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)value2.getObjectValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)otype.getDefaultObjectValue());
        EclipseLinkStructConverter struct = (EclipseLinkStructConverter)entityMappings.getConverterContainer().getStructConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"struct", (String)struct.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"bar", (String)struct.getConverterClass());
    }

    public void testConvertConvertersOnEmbeddableConvertibleMapping() throws Exception {
        this.createTestEmbeddableWithConverterOnConvertibleMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaEmbeddable embeddable = this.getJavaEmbeddable();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)embeddable.getAttributeMappings().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getConvertersSize(), (int)0);
        EclipseLinkCustomConverter custom = (EclipseLinkCustomConverter)entityMappings.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo", (String)custom.getConverterClass());
    }

    private ICompilationUnit createTestMappedSuperclassWithConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Converter", "org.eclipse.persistence.annotations.TypeConverter", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.StructConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)").append(CR);
                sb.append("@TypeConverter(name=\"type\", dataType=Number.class, objectType=Integer.class)").append(CR);
                sb.append("@ObjectTypeConverter(name=\"otype\", dataType=Character.class, objectType=String.class, conversionValues={@ConversionValue(dataValue=\"m\", objectValue=\"male\"), @ConversionValue(dataValue=\"f\", objectValue=\"female\")},defaultObjectValue=\"female\")").append(CR);
                sb.append("@StructConverter(name=\"struct\", converter=\"bar\")");
            }
        });
    }

    private ICompilationUnit createTestMappedSuperclassWithConverterOnConvertibleMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "javax.persistence.Id", "org.eclipse.persistence.annotations.Converter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id").append(CR);
                sb.append("@Converter(name=\"custom\", converterClass=foo.class)");
            }
        });
    }

    public void testConvertConvertersOnMappedSuperclass() throws Exception {
        this.createTestMappedSuperclassWithConverters();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMappedSuperclass mappedSuperclass = this.getJavaMappedSuperclass();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getObjectTypeConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getStructConvertersSize());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mappedSuperclass.getConverterContainer().getCustomConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mappedSuperclass.getConverterContainer().getTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mappedSuperclass.getConverterContainer().getObjectTypeConvertersSize(), (int)0);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mappedSuperclass.getConverterContainer().getStructConvertersSize(), (int)0);
        EclipseLinkCustomConverter custom = (EclipseLinkCustomConverter)entityMappings.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo", (String)custom.getConverterClass());
        EclipseLinkTypeConverter type = (EclipseLinkTypeConverter)entityMappings.getConverterContainer().getTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"type", (String)type.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Number", (String)type.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Integer", (String)type.getObjectType());
        EclipseLinkObjectTypeConverter otype = (EclipseLinkObjectTypeConverter)entityMappings.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"otype", (String)otype.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.Character", (String)otype.getDataType());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"java.lang.String", (String)otype.getObjectType());
        ListIterator values = otype.getConversionValues().iterator();
        EclipseLinkConversionValue value1 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"m", (String)value1.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"male", (String)value1.getObjectValue());
        EclipseLinkConversionValue value2 = (EclipseLinkConversionValue)values.next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"f", (String)value2.getDataValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)value2.getObjectValue());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"female", (String)otype.getDefaultObjectValue());
        EclipseLinkStructConverter struct = (EclipseLinkStructConverter)entityMappings.getConverterContainer().getStructConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"struct", (String)struct.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"bar", (String)struct.getConverterClass());
    }

    public void testConvertConvertersOnMappedSuperclassConvertibleMapping() throws Exception {
        this.createTestMappedSuperclassWithConverterOnConvertibleMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMappedSuperclass mappedSuperclass = this.getJavaMappedSuperclass();
        this.addXmlMappingFileRef("META-INF/eclipselink-orm.xml");
        EclipseLinkEntityMappings entityMappings = this.getEntityMappings();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        persistenceUnit.convertJavaConverters(entityMappings, this.progressMonitor);
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)1, (int)entityMappings.getConverterContainer().getCustomConvertersSize());
        EclipseLinkConvertibleMapping mapping = (EclipseLinkConvertibleMapping)mappedSuperclass.getAttributeMappings().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((int)mapping.getConverterContainer().getConvertersSize(), (int)0);
        EclipseLinkCustomConverter custom = (EclipseLinkCustomConverter)entityMappings.getConverterContainer().getCustomConverters().iterator().next();
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"custom", (String)custom.getName());
        EclipseLink2_2JpaMetadataConversionTests.assertEquals((String)"foo", (String)custom.getConverterClass());
    }
}

