/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkGeneralProperties;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class GeneralPropertiesValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkGeneralProperties generalProperty;
    private ModifiablePropertyValueModel<Boolean> excludeEclipselinkOrmHolder;
    private PropertyChangeListener excludeEclipselinkOrmListener;
    private PropertyChangeEvent excludeEclipselinkOrmEvent;
    public static final Boolean EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE = Boolean.FALSE;

    public GeneralPropertiesValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.generalProperty = this.subject.getGeneralProperties();
        SimplePropertyValueModel generalPropertyHolder = new SimplePropertyValueModel((Object)this.generalProperty);
        this.excludeEclipselinkOrmHolder = this.buildExcludeEclipselinkOrmAA((PropertyValueModel<EclipseLinkGeneralProperties>)generalPropertyHolder);
        this.excludeEclipselinkOrmListener = this.buildExcludeEclipselinkOrmChangeListener();
        this.excludeEclipselinkOrmHolder.addPropertyChangeListener("value", this.excludeEclipselinkOrmListener);
        this.excludeEclipselinkOrmEvent = null;
    }

    public void testHasListeners() {
        AbstractModel subjectGeneralProperty = (AbstractModel)this.generalProperty;
        PropertyAspectAdapter excludeEclipselinkOrmAA = (PropertyAspectAdapter)this.excludeEclipselinkOrmHolder;
        GeneralPropertiesValueModelTests.assertTrue((boolean)excludeEclipselinkOrmAA.hasAnyPropertyChangeListeners("value"));
        GeneralPropertiesValueModelTests.assertTrue((boolean)subjectGeneralProperty.hasAnyPropertyChangeListeners("excludeEclipselinkOrm"));
        excludeEclipselinkOrmAA.removePropertyChangeListener("value", this.excludeEclipselinkOrmListener);
        GeneralPropertiesValueModelTests.assertFalse((boolean)subjectGeneralProperty.hasAnyPropertyChangeListeners("excludeEclipselinkOrm"));
        GeneralPropertiesValueModelTests.assertFalse((boolean)excludeEclipselinkOrmAA.hasAnyPropertyChangeListeners("value"));
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.exclude-eclipselink-orm", EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.generalProperty;
    }

    private ModifiablePropertyValueModel<Boolean> buildExcludeEclipselinkOrmAA(PropertyValueModel<EclipseLinkGeneralProperties> subjectHolder) {
        return new PropertyAspectAdapter<EclipseLinkGeneralProperties, Boolean>(subjectHolder, new String[]{"excludeEclipselinkOrm"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkGeneralProperties)this.subject).getExcludeEclipselinkOrm();
            }

            protected void setValue_(Boolean enumValue) {
                ((EclipseLinkGeneralProperties)this.subject).setExcludeEclipselinkOrm(enumValue);
            }
        };
    }

    private PropertyChangeListener buildExcludeEclipselinkOrmChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                GeneralPropertiesValueModelTests.this.excludeEclipselinkOrmEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyExcludeEclipselinkOrmAAValue(EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE);
        GeneralPropertiesValueModelTests.assertEquals((Object)EclipseLinkGeneralProperties.DEFAULT_EXCLUDE_ECLIPSELINK_ORM, (Object)this.generalProperty.getDefaultExcludeEclipselinkOrm());
    }

    public void testSetValue() throws Exception {
        this.excludeEclipselinkOrmEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.excludeEclipselinkOrmHolder, "value");
        Boolean newExcludeEclipselinkOrm = EXCLUDE_ECLIPSELINK_ORM_TEST_VALUE == false;
        this.excludeEclipselinkOrmHolder.setValue((Object)newExcludeEclipselinkOrm);
        this.verifyExcludeEclipselinkOrmAAValue(newExcludeEclipselinkOrm);
        GeneralPropertiesValueModelTests.assertNotNull((Object)this.excludeEclipselinkOrmEvent);
    }

    public void testSetNullValue() {
        String notDeleted = "Property not deleted";
        this.excludeEclipselinkOrmEvent = null;
        this.excludeEclipselinkOrmHolder.setValue(null);
        this.verifyExcludeEclipselinkOrmAAValue(null);
        GeneralPropertiesValueModelTests.assertNotNull((Object)this.excludeEclipselinkOrmEvent);
        this.verifyPuHasNotProperty("eclipselink.exclude-eclipselink-orm", notDeleted);
    }

    protected void verifyExcludeEclipselinkOrmAAValue(Boolean testValue) {
        this.verifyAAValue(testValue, this.generalProperty.getExcludeEclipselinkOrm(), (PropertyValueModel)this.excludeEclipselinkOrmHolder, "eclipselink.exclude-eclipselink-orm");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

