/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ClasspathDependencyExtensions {
    private static final String CLASSPATH_DEP_EXTENSION_ID = "classpathdep";
    private static final String FILTERED_CLASSPATH_CONTAINER = "filteredClasspathContainer";
    private static final String CLASSPATH_CONTAINER_ID = "containerID";
    private static ClasspathDependencyExtensions _instance = null;
    private final List filteredClasspathContainerIDs = new ArrayList();

    public static ClasspathDependencyExtensions get() {
        if (_instance == null) {
            _instance = new ClasspathDependencyExtensions();
        }
        return _instance;
    }

    private ClasspathDependencyExtensions() {
        this.readExtensions();
    }

    public List getFilteredClasspathContainerIDs() {
        return this.filteredClasspathContainerIDs;
    }

    private void readExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.jst.j2ee", CLASSPATH_DEP_EXTENSION_ID);
        if (point == null) {
            throw new RuntimeException("Extension point not found!");
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String cpContainerID;
                if (elements[j].getName().equals(FILTERED_CLASSPATH_CONTAINER) && (cpContainerID = elements[j].getAttribute(CLASSPATH_CONTAINER_ID)) != null) {
                    this.filteredClasspathContainerIDs.add(cpContainerID);
                }
                ++j;
            }
            ++i;
        }
    }
}

