/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.provisional.contenttype;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class ContentTypeIdForJSP {
    public static final String ContentTypeID_JSP = ContentTypeIdForJSP.getConstantString();
    public static final String ContentTypeID_JSPFRAGMENT = ContentTypeIdForJSP.getFragmentConstantString();
    public static final String ContentTypeID_JSPTAG = ContentTypeIdForJSP.getTagConstantString();
    private static char[][] JSP_EXTENSIONS;
    private static String JSP;

    static {
        JSP = "jsp";
    }

    private ContentTypeIdForJSP() {
    }

    static String getConstantString() {
        return "org.eclipse.jst.jsp.core.jspsource";
    }

    static String getFragmentConstantString() {
        return "org.eclipse.jst.jsp.core.jspfragmentsource";
    }

    static String getTagConstantString() {
        return "org.eclipse.jst.jsp.core.tagsource";
    }

    public static int indexOfJSPExtension(String fileName) {
        int fileNameLength = fileName.length();
        char[][] jspExtensions = ContentTypeIdForJSP.getJSPExtensions();
        int i = 0;
        int length = jspExtensions.length;
        while (i < length) {
            block4: {
                char[] extension = jspExtensions[i];
                int extensionLength = extension.length;
                int extensionStart = fileNameLength - extensionLength;
                int dotIndex = extensionStart - 1;
                if (dotIndex >= 0 && fileName.charAt(dotIndex) == '.') {
                    int j = 0;
                    while (j < extensionLength) {
                        if (fileName.charAt(extensionStart + j) == extension[j]) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    return dotIndex;
                }
            }
            ++i;
        }
        return -1;
    }

    public static char[][] getJSPExtensions() {
        if (JSP_EXTENSIONS == null) {
            IContentType jspContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.getConstantString());
            HashSet<String> fileExtensions = new HashSet<String>();
            IContentType[] contentTypes = Platform.getContentTypeManager().getAllContentTypes();
            int i = 0;
            int length = contentTypes.length;
            while (i < length) {
                if (contentTypes[i].isKindOf(jspContentType)) {
                    String[] fileExtension = contentTypes[i].getFileSpecs(8);
                    int j = 0;
                    while (j < fileExtension.length) {
                        fileExtensions.add(fileExtension[j]);
                        ++j;
                    }
                }
                ++i;
            }
            int length2 = fileExtensions.size();
            char[][] extensions = new char[length2][];
            extensions[0] = JSP.toCharArray();
            int index = 1;
            Iterator iterator = fileExtensions.iterator();
            while (iterator.hasNext()) {
                String fileExtension = (String)iterator.next();
                if (JSP.equalsIgnoreCase(fileExtension)) continue;
                extensions[index++] = fileExtension.toCharArray();
            }
            JSP_EXTENSIONS = extensions;
        }
        return JSP_EXTENSIONS;
    }
}

