/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.operations.jsf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.ui.internal.utils.ResourceUtils;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.eclipse.jst.pagedesigner.utils.PreviewUtil;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class LoadBundleOperation
extends AbstractTransformOperation {
    public Element transform(Element srcElement, Element curElement) {
        block13: {
            if (srcElement != null) {
                String var = srcElement.getAttribute("var");
                String basename = srcElement.getAttribute("basename");
                if (var != null && basename != null && var.length() > 0 && basename.length() > 0) {
                    IPath webRootPath;
                    IVirtualFolder rootFolder;
                    IVirtualComponent component;
                    IProject project;
                    IDOMModel model;
                    String basePath = String.valueOf(basename.replace('.', "/".charAt(0))) + "." + "properties";
                    if (srcElement instanceof IDOMNode && (model = ((IDOMNode)srcElement).getModel()) != null && (project = StructuredModelUtil.getProjectFor((IStructuredModel)model)) != null && (component = ComponentCore.createComponent((IProject)project)) != null && (rootFolder = component.getRootFolder()) != null && (webRootPath = rootFolder.getProjectRelativePath()) != null) {
                        StringBuffer sb = new StringBuffer(webRootPath.toString());
                        if (!"/".equals(webRootPath.toString())) {
                            sb.append("/");
                        }
                        sb.append("WEB-INF");
                        sb.append("/");
                        sb.append("classes");
                        sb.append("/");
                        sb.append(basePath);
                        IResource resource = project.findMember(sb.toString());
                        if (resource == null && (resource = this.findFileInSrcFolder(project, basePath)) != null) {
                            InputStream inputStream = null;
                            try {
                                try {
                                    PropertyResourceBundle bundle;
                                    File file = new File(resource.getLocation().toString());
                                    inputStream = new FileInputStream(file);
                                    if (inputStream != null && (bundle = new PropertyResourceBundle(inputStream = new BufferedInputStream(inputStream))) != null) {
                                        if (PreviewUtil.getBUNDLE_MAP() == null) {
                                            PreviewUtil.setBUNDLE_MAP(new HashMap());
                                        } else {
                                            PreviewUtil.getBUNDLE_MAP().clear();
                                        }
                                        PreviewUtil.getBUNDLE_MAP().put(var, bundle);
                                        PreviewUtil.setBUNDLE((PropertyResourceBundle)bundle);
                                        PreviewUtil.setVAR((String)var);
                                    }
                                }
                                catch (IOException ioe) {
                                    PDPlugin.getLogger(LoadBundleOperation.class).error("LoadBundleTagConverter.convertRefresh.IOException", (Throwable)ioe);
                                    ResourceUtils.ensureClosed(inputStream);
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                ResourceUtils.ensureClosed(inputStream);
                                throw throwable;
                            }
                            ResourceUtils.ensureClosed((InputStream)inputStream);
                        }
                    }
                }
            }
        }
        return null;
    }

    protected IResource findFileInSrcFolder(IProject project, String filePath) {
        IResource resource = null;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < classpathEntries.length) {
                    IClasspathEntry classpathEntry = classpathEntries[i];
                    if (classpathEntry.getEntryKind() == 3) {
                        IPath srcPath = classpathEntry.getPath();
                        IPath srcFilePath = srcPath.append(filePath);
                        IResource tmpResource = project.getParent().findMember(srcFilePath);
                        if (tmpResource != null) {
                            resource = tmpResource;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return resource;
    }
}

