/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jem.internal.beaninfo.adapters.IReader;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.eclipse.jem.internal.beaninfo.core.SearchpathEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeaninfosDoc
implements IBeaninfosDocEntry {
    protected IBeaninfosDocEntry[] searchpath;
    static final String sExported = "exported";
    static final String sKind = "kind";
    static final String sPath = "path";

    public BeaninfosDoc() {
    }

    public BeaninfosDoc(IBeaninfosDocEntry[] searchpath) {
        this.searchpath = searchpath;
    }

    public int getKind() {
        return -1;
    }

    public IPath getPath() {
        return null;
    }

    public static BeaninfosDoc readEntry(IReader reader, Object root, IProject project) {
        ArrayList<BeaninfoEntry> paths = new ArrayList<BeaninfoEntry>();
        Object children = reader.getChildren(root);
        int childrenLength = reader.getLength(children);
        int i = 0;
        while (i < childrenLength) {
            Object child = reader.getItem(children, i);
            if (reader.isNodeTypeElement(child)) {
                IBeaninfosDocEntry entry = null;
                if (reader.getNodeName(child).equalsIgnoreCase("beaninfo")) {
                    entry = BeaninfoEntry.readEntry(reader, child, project);
                } else if (reader.getNodeName(child).equalsIgnoreCase("searchpath")) {
                    entry = SearchpathEntry.readEntry(reader, child, project, false);
                }
                if (entry != null) {
                    paths.add((BeaninfoEntry)entry);
                }
            }
            ++i;
        }
        return new BeaninfosDoc(paths.toArray(new IBeaninfosDocEntry[paths.size()]));
    }

    public IBeaninfosDocEntry[] getSearchpath() {
        return this.searchpath;
    }

    public void setSearchpath(IBeaninfosDocEntry[] searchpath) {
        this.searchpath = searchpath;
    }

    public Node writeEntry(Document doc, IProject project) {
        Element root = doc.createElement("searchpath");
        int i = 0;
        while (i < this.searchpath.length) {
            root.appendChild(this.searchpath[i].writeEntry(doc, project));
            ++i;
        }
        return root;
    }
}

