/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PopUpKeyValueDialog
extends Dialog {
    private final String title;
    private final String initialKey;
    private final String initialValue;
    private final VerifyListener verifyListener;
    protected Text keyText;
    protected Text valueText;
    private String key;
    private String value;
    private String keyLabelText;
    private String valueLabelText;

    public PopUpKeyValueDialog(Shell shell, String title, String initialKey, String initialValue, String keyLabelText, String valueLabelText, VerifyListener verifyListener) {
        super(shell);
        this.title = title;
        this.initialKey = initialKey;
        this.initialValue = initialValue;
        this.keyLabelText = keyLabelText;
        this.valueLabelText = valueLabelText;
        this.verifyListener = verifyListener;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        comp.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(this.keyLabelText);
        nameLabel.setFont(comp.getFont());
        this.keyText = new Text(comp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.keyText.setLayoutData((Object)gd);
        this.keyText.setFont(comp.getFont());
        this.keyText.setText(this.initialKey == null ? "" : this.initialKey);
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PopUpKeyValueDialog.this.updateButtons();
            }
        });
        Label valueLabel = new Label(comp, 0);
        valueLabel.setText(this.valueLabelText);
        valueLabel.setFont(comp.getFont());
        this.valueText = new Text(comp, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.valueText.setLayoutData((Object)gd);
        this.valueText.setFont(comp.getFont());
        this.valueText.setText(this.initialValue == null ? "" : this.initialValue);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PopUpKeyValueDialog.this.updateButtons();
            }
        });
        return comp;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.key = this.keyText.getText();
            this.value = this.valueText.getText();
        } else {
            this.key = null;
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void updateButtons() {
        String name = this.keyText.getText().trim();
        String value = this.valueText.getText().trim();
        Event e = new Event();
        e.widget = this.keyText;
        VerifyEvent ev = new VerifyEvent(e);
        ev.doit = true;
        if (this.verifyListener != null) {
            ev.text = name;
            this.verifyListener.verifyText(ev);
        }
        this.getButton(0).setEnabled(name.length() > 0 && value.length() > 0 && ev.doit);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

