/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTMatcher;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;

class SnippetFinder
extends GenericVisitor {
    private List fResult = new ArrayList(2);
    private Match fMatch;
    private ASTNode[] fSnippet;
    private int fIndex;
    private Matcher fMatcher;
    private int fTypes;

    private SnippetFinder(ASTNode[] snippet) {
        super(true);
        this.fSnippet = snippet;
        this.fMatcher = new Matcher();
        this.reset();
    }

    public static Match[] perform(ASTNode start, ASTNode[] snippet) {
        Assert.isTrue((start instanceof JavaScriptUnit || start instanceof AbstractTypeDeclaration || start instanceof AnonymousClassDeclaration ? 1 : 0) != 0);
        SnippetFinder finder = new SnippetFinder(snippet);
        start.accept((ASTVisitor)finder);
        Iterator iter = finder.fResult.iterator();
        while (iter.hasNext()) {
            Match match = (Match)iter.next();
            ASTNode[] nodes = match.getNodes();
            if (nodes.length != 1 || !SnippetFinder.isLeftHandSideOfAssignment(nodes[0])) continue;
            iter.remove();
        }
        return finder.fResult.toArray(new Match[finder.fResult.size()]);
    }

    private static boolean isLeftHandSideOfAssignment(ASTNode node) {
        ASTNode parent = node.getParent();
        return parent != null && parent.getNodeType() == 7 && ((Assignment)parent).getLeftHandSide() == node;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (++this.fTypes > 1) {
            return false;
        }
        return super.visit(node);
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        --this.fTypes;
        super.endVisit(node);
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (this.matches(node)) {
            return false;
        }
        if (!this.isResetted()) {
            this.reset();
            if (this.matches(node)) {
                return false;
            }
        }
        return true;
    }

    private boolean matches(ASTNode node) {
        if (this.isSnippetNode(node)) {
            return false;
        }
        if (node.subtreeMatch((ASTMatcher)this.fMatcher, (Object)this.fSnippet[this.fIndex]) && this.fMatch.hasCorrectNesting(node)) {
            this.fMatch.add(node);
            ++this.fIndex;
            if (this.fIndex == this.fSnippet.length) {
                this.fResult.add(this.fMatch);
                this.reset();
            }
            return true;
        }
        return false;
    }

    private boolean isResetted() {
        return this.fIndex == 0 && this.fMatch.isEmpty();
    }

    private void reset() {
        this.fIndex = 0;
        this.fMatch = new Match();
    }

    private boolean isSnippetNode(ASTNode node) {
        int i = 0;
        while (i < this.fSnippet.length) {
            if (node == this.fSnippet[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static class Match {
        private List fNodes = new ArrayList(10);
        private Map fLocalMappings = new HashMap();

        public void add(ASTNode node) {
            this.fNodes.add(node);
        }

        public boolean hasCorrectNesting(ASTNode node) {
            if (this.fNodes.size() == 0) {
                return true;
            }
            ASTNode parent = node.getParent();
            if (((ASTNode)this.fNodes.get(0)).getParent() != parent) {
                return false;
            }
            int nodeType = parent.getNodeType();
            return nodeType == 8 || nodeType == 50;
        }

        public ASTNode[] getNodes() {
            return this.fNodes.toArray(new ASTNode[this.fNodes.size()]);
        }

        public void addLocal(IVariableBinding org, SimpleName local) {
            this.fLocalMappings.put(org, local);
        }

        public SimpleName getMappedName(IVariableBinding org) {
            return (SimpleName)this.fLocalMappings.get(org);
        }

        public IVariableBinding getMappedBinding(IVariableBinding org) {
            SimpleName name = (SimpleName)this.fLocalMappings.get(org);
            return ASTNodes.getVariableBinding((Name)name);
        }

        public boolean isEmpty() {
            return this.fNodes.isEmpty() && this.fLocalMappings.isEmpty();
        }

        public boolean isMethodBody() {
            ASTNode first = (ASTNode)this.fNodes.get(0);
            if (first.getParent() == null) {
                return false;
            }
            ASTNode candidate = first.getParent().getParent();
            if (candidate == null || candidate.getNodeType() != 31) {
                return false;
            }
            FunctionDeclaration method = (FunctionDeclaration)candidate;
            return method.getBody().statements().size() == this.fNodes.size();
        }

        public FunctionDeclaration getEnclosingMethod() {
            ASTNode first = (ASTNode)this.fNodes.get(0);
            return (FunctionDeclaration)ASTNodes.getParent(first, 31);
        }
    }

    private class Matcher
    extends ASTMatcher {
        private Matcher() {
        }

        public boolean match(SimpleName candidate, Object s) {
            if (!(s instanceof SimpleName)) {
                return false;
            }
            SimpleName snippet = (SimpleName)s;
            if (candidate.isDeclaration() != snippet.isDeclaration()) {
                return false;
            }
            IBinding cb = candidate.resolveBinding();
            IBinding sb = snippet.resolveBinding();
            if (cb == null || sb == null) {
                return false;
            }
            IVariableBinding vcb = ASTNodes.getVariableBinding((Name)candidate);
            IVariableBinding vsb = ASTNodes.getVariableBinding((Name)snippet);
            if (vcb == null || vsb == null) {
                return Bindings.equals(cb, sb);
            }
            if (!vcb.isField() && !vsb.isField() && Bindings.equals((IBinding)vcb.getType(), (IBinding)vsb.getType())) {
                IVariableBinding mappedBinding;
                SimpleName mapped = SnippetFinder.this.fMatch.getMappedName(vsb);
                if (mapped != null && !Bindings.equals((IBinding)vcb, (IBinding)(mappedBinding = ASTNodes.getVariableBinding((Name)mapped)))) {
                    return false;
                }
                SnippetFinder.this.fMatch.addLocal(vsb, candidate);
                return true;
            }
            return Bindings.equals(cb, sb);
        }
    }
}

