/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.tomcat.core.internal.CatalinaPropertiesUtil;
import org.eclipse.jst.server.tomcat.core.internal.FileUtil;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat80PublishModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat85PublishModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.Tomcat90PublishModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPublishModuleVisitor;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.jst.server.tomcat.core.internal.wst.ModuleTraverser;
import org.eclipse.jst.server.tomcat.core.internal.xml.Factory;
import org.eclipse.jst.server.tomcat.core.internal.xml.XMLUtil;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Context;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Host;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.Server;
import org.eclipse.jst.server.tomcat.core.internal.xml.server40.ServerInstance;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.util.PublishHelper;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomcatVersionHelper {
    public static final String DEFAULT_WEBXML_SERVLET22 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN\" \"http://java.sun.com/j2ee/dtds/web-app_2_2.dtd\">\n<web-app>\n</web-app>";
    public static final String DEFAULT_WEBXML_SERVLET23 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE web-app PUBLIC \"-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN\" \"http://java.sun.com/dtd/web-app_2_3.dtd\">\n<web-app>\n</web-app>";
    public static final String DEFAULT_WEBXML_SERVLET24 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd\" version=\"2.4\">\n</web-app>";
    public static final String DEFAULT_WEBXML_SERVLET25 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\" version=\"2.5\">\n</web-app>";
    private static final Map<String, String> versionStringMap = new HashMap<String, String>();
    private static Map<IPath, String> catalinaJarVersion;
    private static Map<IPath, Long> catalinaJarLastModified;
    private static volatile long lastCheck;

    static {
        versionStringMap.put("org.eclipse.jst.server.tomcat.41", "4.1.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.50", "5.0.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.55", "5.5.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.60", "6.0.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.70", "7.0.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.80", "8.0.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.85", "8.5.");
        versionStringMap.put("org.eclipse.jst.server.tomcat.90", "9.0.");
        catalinaJarVersion = new ConcurrentHashMap<IPath, String>();
        catalinaJarLastModified = new ConcurrentHashMap<IPath, Long>();
        lastCheck = 0L;
    }

    public static String getFileContents(InputStream stream) throws IOException {
        StringBuffer sb;
        block9: {
            BufferedReader br = null;
            sb = new StringBuffer();
            try {
                try {
                    br = new BufferedReader(new InputStreamReader(stream));
                    String temp = br.readLine();
                    while (temp != null) {
                        sb.append(temp).append("\n");
                        temp = br.readLine();
                    }
                }
                catch (Exception e) {
                    Trace.trace((byte)1, "Could not load file contents.", e);
                    if (br != null) {
                        br.close();
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    br.close();
                }
                throw throwable;
            }
            if (br != null) {
                br.close();
            }
        }
        return sb.toString();
    }

    public static IPath getStandardBaseDirectory(TomcatServer ts) {
        if (ts.isTestEnvironment()) {
            String baseDir = ts.getInstanceDirectory();
            if (baseDir == null) {
                TomcatServerBehaviour tsb = (TomcatServerBehaviour)ts.getServer().loadAdapter(TomcatServerBehaviour.class, null);
                return tsb.getTempDirectory();
            }
            Path path = new Path(baseDir);
            if (!path.isAbsolute()) {
                IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                path = rootPath.append((IPath)path);
            }
            return path;
        }
        return ts.getServer().getRuntime().getLocation();
    }

    public static String[] getCatalinaVMArguments(IPath installPath, IPath instancePath, IPath deployPath, boolean isTestEnv) {
        ArrayList<String> list = new ArrayList<String>();
        if (isTestEnv) {
            list.add("-Dcatalina.base=\"" + instancePath.toOSString() + "\"");
        } else {
            list.add("-Dcatalina.base=\"" + installPath.toOSString() + "\"");
        }
        list.add("-Dcatalina.home=\"" + installPath.toOSString() + "\"");
        list.add("-Dwtp.deploy=\"" + deployPath.toOSString() + "\"");
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public static ServerInstance getCatalinaServerInstance(IPath serverXml, String serviceName, String hostName) throws FileNotFoundException, IOException, SAXException {
        Server server;
        IPath contextPath;
        File contextDir;
        ServerInstance serverInstance = null;
        Factory factory = new Factory();
        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
        File serverFile = serverXml.toFile();
        if (serverFile.exists() && (contextDir = (contextPath = (serverInstance = new ServerInstance(server = (Server)factory.loadDocument(new FileInputStream(serverFile)), serviceName, hostName)).getContextXmlDirectory(serverXml.removeLastSegments(1))).toFile()).exists()) {
            HashMap<File, Context> projectContexts = new HashMap<File, Context>();
            TomcatVersionHelper.loadSeparateContextFiles(contextPath.toFile(), factory, projectContexts);
            Host host = serverInstance.getHost();
            Collection contexts = projectContexts.values();
            for (Context context : contexts) {
                host.importNode(context.getElementNode(), true);
            }
        }
        return serverInstance;
    }

    public static void getRemovedKeptCatalinaContexts(ServerInstance oldServerInstance, List modules, Map<String, Context> removedContextsMap, Map<String, Context> keptContextsMap) {
        Context[] contexts = oldServerInstance.getContexts();
        if (contexts != null) {
            int i = 0;
            while (i < contexts.length) {
                String source = contexts[i].getSource();
                if (source != null && source.length() > 0) {
                    removedContextsMap.put(contexts[i].getPath(), contexts[i]);
                }
                ++i;
            }
        }
        int size = modules.size();
        int i = 0;
        while (i < size) {
            Context context;
            WebModule module = (WebModule)modules.get(i);
            String modulePath = module.getPath();
            if (modulePath.equals("/")) {
                modulePath = "";
            }
            if ((context = removedContextsMap.remove(modulePath)) != null) {
                keptContextsMap.put(context.getPath(), context);
            }
            ++i;
        }
    }

    public static IStatus cleanupCatalinaServer(IPath baseDir, IPath installDir, boolean removeKeptContextFiles, List modules, IProgressMonitor monitor) {
        MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.cleanupServerTask, null);
        try {
            try {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.cleanupServerTask, 200);
                monitor.subTask(Messages.detectingRemovedProjects);
                IPath serverXml = baseDir.append("conf").append("server.xml");
                ServerInstance oldInstance = TomcatVersionHelper.getCatalinaServerInstance(serverXml, null, null);
                if (oldInstance != null) {
                    File ctxFile;
                    IPath ctxFilePath;
                    Context ctx;
                    IProgressMonitor subMonitor;
                    HashMap<String, Context> removedContextsMap = new HashMap<String, Context>();
                    HashMap<String, Context> keptContextsMap = new HashMap<String, Context>();
                    TomcatVersionHelper.getRemovedKeptCatalinaContexts(oldInstance, modules, removedContextsMap, keptContextsMap);
                    monitor.worked(100);
                    if (removedContextsMap.size() > 0) {
                        subMonitor = ProgressUtil.getSubMonitorFor(monitor, 100);
                        subMonitor.beginTask(Messages.deletingContextFilesTask, removedContextsMap.size() * 200);
                        for (String oldPath : removedContextsMap.keySet()) {
                            ctx = (Context)removedContextsMap.get(oldPath);
                            ctxFilePath = oldInstance.getContextFilePath(baseDir, ctx);
                            if (ctxFilePath != null && (ctxFile = ctxFilePath.toFile()).exists()) {
                                subMonitor.subTask(NLS.bind((String)Messages.deletingContextFile, (Object)ctxFile.getName()));
                                if (ctxFile.delete()) {
                                    if (Trace.isTraceEnabled()) {
                                        Trace.trace((byte)4, "Leftover context file " + ctxFile.getName() + " deleted.");
                                    }
                                    ms.add((IStatus)new Status(0, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.deletedContextFile, (Object)ctxFile.getName()), null));
                                } else {
                                    Trace.trace((byte)2, "Could not delete obsolete context file " + ctxFilePath.toOSString());
                                    ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotDeleteContextFile, (Object)ctxFilePath.toOSString()), null));
                                }
                            }
                            subMonitor.worked(100);
                            IPath ctxWorkPath = oldInstance.getContextWorkDirectory(baseDir, ctx);
                            if (baseDir.isPrefixOf(ctxWorkPath)) {
                                File ctxWorkDir = ctxWorkPath.toFile();
                                if (ctxWorkDir.exists() && ctxWorkDir.isDirectory()) {
                                    IStatus[] results = PublishHelper.deleteDirectory((File)ctxWorkDir, (IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 100));
                                    if (results.length <= 0) continue;
                                    Trace.trace((byte)2, "Could not delete work directory " + ctxWorkDir.getPath() + " for removed context " + oldPath);
                                    int i = 0;
                                    while (i < results.length) {
                                        ms.add(results[i]);
                                        ++i;
                                    }
                                    continue;
                                }
                                subMonitor.worked(100);
                                continue;
                            }
                            subMonitor.worked(100);
                        }
                        subMonitor.done();
                    }
                    monitor.worked(100);
                    if (removeKeptContextFiles && keptContextsMap.size() > 0) {
                        subMonitor = ProgressUtil.getSubMonitorFor(monitor, 100);
                        subMonitor.beginTask(Messages.deletingContextFilesTask, keptContextsMap.size() * 100);
                        for (String keptPath : keptContextsMap.keySet()) {
                            ctx = (Context)keptContextsMap.get(keptPath);
                            ctxFilePath = oldInstance.getContextFilePath(baseDir, ctx);
                            if (ctxFilePath != null && (ctxFile = ctxFilePath.toFile()).exists()) {
                                subMonitor.subTask(NLS.bind((String)Messages.deletingContextFile, (Object)ctxFile.getName()));
                                if (ctxFile.delete()) {
                                    if (Trace.isTraceEnabled()) {
                                        Trace.trace((byte)4, "Leftover context file " + ctxFile.getName() + " deleted.");
                                    }
                                    ms.add((IStatus)new Status(0, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.deletedContextFile, (Object)ctxFile.getName()), null));
                                } else {
                                    Trace.trace((byte)2, "Could not delete obsolete context file " + ctxFilePath.toOSString());
                                    ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotDeleteContextFile, (Object)ctxFilePath.toOSString()), null));
                                }
                            }
                            subMonitor.worked(100);
                        }
                        subMonitor.done();
                    }
                } else {
                    monitor.worked(200);
                }
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)4, "Server cleaned");
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not cleanup server at " + baseDir.toOSString() + ": " + e.getMessage());
                ms.add((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCleanupServer, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return ms;
    }

    public static IStatus createCatalinaInstanceDirectory(IPath baseDir) {
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Creating runtime directory at " + baseDir.toOSString());
        }
        if (!(temp = baseDir.append("conf").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("logs").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("temp").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("webapps").toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = baseDir.append("work").toFile()).exists()) {
            temp.mkdirs();
        }
        return Status.OK_STATUS;
    }

    public static IStatus createDeploymentDirectory(IPath deployDir, String webxml) {
        IPath tempPath;
        File temp;
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Creating deployment directory at " + deployDir.toOSString());
        }
        if (!(temp = deployDir.toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = (tempPath = deployDir.append("ROOT/WEB-INF")).toFile()).exists()) {
            temp.mkdirs();
        }
        if (!(temp = tempPath.append("web.xml").toFile()).exists()) {
            try {
                FileWriter fw = new FileWriter(temp);
                fw.write(webxml);
                fw.close();
            }
            catch (IOException e) {
                Trace.trace((byte)1, "Unable to create web.xml for ROOT context.", e);
            }
        }
        return Status.OK_STATUS;
    }

    public static IStatus publishCatalinaContextConfig(IPath baseDir, IPath webappsDir, IProgressMonitor monitor) {
        if (Trace.isTraceEnabled()) {
            Trace.trace((byte)4, "Apply context configurations");
        }
        IPath confDir = baseDir.append("conf");
        try {
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.publishConfigurationTask, 300);
            monitor.subTask(Messages.publishContextConfigTask);
            Factory factory = new Factory();
            factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            Server publishedServer = (Server)factory.loadDocument(new FileInputStream(confDir.append("server.xml").toFile()));
            ServerInstance publishedInstance = new ServerInstance(publishedServer, null, null);
            monitor.worked(100);
            boolean modified = false;
            MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, Messages.publishContextConfigTask, null);
            Context[] contexts = publishedInstance.getContexts();
            if (contexts != null) {
                int i = 0;
                while (i < contexts.length) {
                    Context context = contexts[i];
                    monitor.subTask(NLS.bind((String)Messages.checkingContextTask, (Object[])new String[]{context.getPath()}));
                    if (TomcatVersionHelper.addCatalinaContextConfig(webappsDir, context, ms)) {
                        modified = true;
                    }
                    ++i;
                }
            }
            monitor.worked(100);
            if (modified) {
                monitor.subTask(Messages.savingContextConfigTask);
                factory.save(confDir.append("server.xml").toOSString());
            }
            if (ms.getChildren().length > 0) {
                MultiStatus multiStatus = ms;
                return multiStatus;
            }
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Server.xml updated with context.xml configurations");
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not apply context configurations to published Tomcat configuration from " + confDir.toOSString() + ": " + e.getMessage());
            Status status = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private static boolean addCatalinaContextConfig(IPath webappsDir, Context context, MultiStatus ms) {
        boolean modified = false;
        String source = context.getSource();
        if (source != null && source.length() > 0) {
            File docBase = new File(context.getDocBase());
            if (!docBase.isAbsolute()) {
                docBase = new File(webappsDir.toOSString(), docBase.getPath());
            }
            try {
                Context contextConfig = TomcatVersionHelper.loadCatalinaContextConfig(docBase);
                if (contextConfig != null) {
                    if (context.hasChildNodes()) {
                        context.removeChildren();
                    }
                    contextConfig.copyChildrenTo(context);
                    Map attrs = contextConfig.getAttributes();
                    for (String name : attrs.keySet()) {
                        if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("docBase") || name.equalsIgnoreCase("source")) continue;
                        String value = (String)attrs.get(name);
                        context.setAttributeValue(name, value);
                    }
                    modified = true;
                }
            }
            catch (Exception e) {
                String contextPath = context.getPath();
                if (contextPath.startsWith("/")) {
                    contextPath = contextPath.substring(1);
                }
                Trace.trace((byte)2, "Error reading context.xml file for " + contextPath, e);
                Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorCouldNotLoadContextXml, (Object)contextPath), (Throwable)e);
                ms.add((IStatus)s);
            }
        }
        return modified;
    }

    private static Context loadCatalinaContextConfig(File docBase) throws IOException, SAXException {
        File contextXML = new File(docBase, "META-INF" + File.separator + "context.xml");
        if (contextXML.exists()) {
            try {
                FileInputStream is = new FileInputStream(contextXML);
                Factory ctxFactory = new Factory();
                ctxFactory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                Context ctx = (Context)ctxFactory.loadDocument(is);
                ((InputStream)is).close();
                return ctx;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    public static IStatus localizeConfiguration(IPath baseDir, IPath deployDir, TomcatServer server, IProgressMonitor monitor) {
        try {
            if (Trace.isTraceEnabled()) {
                Trace.trace((byte)4, "Localizing configuration at " + baseDir);
            }
            monitor = ProgressUtil.getMonitorFor(monitor);
            monitor.beginTask(Messages.publishConfigurationTask, 300);
            IPath serverXml = baseDir.append("conf/server.xml");
            Factory factory = new Factory();
            factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
            Server publishedServer = (Server)factory.loadDocument(new FileInputStream(serverXml.toFile()));
            ServerInstance publishedInstance = new ServerInstance(publishedServer, null, null);
            monitor.worked(100);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            boolean modified = false;
            boolean addRootWebapp = server.isTestEnvironment();
            boolean deployingToAppBase = "webapps".equals(server.getDeployDirectory());
            HashMap<String, String> pathMap = new HashMap<String, String>();
            MultiStatus ms = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishServer, (Object)server.getServer().getName()), null);
            Context[] contexts = publishedInstance.getContexts();
            if (contexts != null) {
                int i = 0;
                while (i < contexts.length) {
                    String source;
                    Context context = contexts[i];
                    String path = context.getPath();
                    if (path != null) {
                        String lcPath;
                        String origPath = path;
                        if ("/".equals(path)) {
                            if (Trace.isTraceEnabled()) {
                                Trace.trace((byte)4, "Context path is being changed from \"/\" to \"\".");
                            }
                            path = "";
                            context.setPath(path);
                            modified = true;
                        }
                        if (!pathMap.containsKey(lcPath = path.toLowerCase())) {
                            pathMap.put(lcPath, origPath);
                        } else {
                            String otherPath = (String)pathMap.get(lcPath);
                            Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", origPath.equals(otherPath) ? NLS.bind((String)Messages.errorPublishPathDup, (Object)origPath) : NLS.bind((String)Messages.errorPublishPathConflict, (Object)origPath, (Object)otherPath));
                            ms.add((IStatus)s);
                        }
                    } else {
                        Status s = new Status(4, "org.eclipse.jst.server.tomcat.core", Messages.errorPublishPathMissing);
                        ms.add((IStatus)s);
                    }
                    if (addRootWebapp && "".equals(context.getPath())) {
                        addRootWebapp = false;
                    }
                    if (!deployingToAppBase && (source = context.getSource()) != null && source.length() > 0) {
                        context.setDocBase(deployDir.append(context.getDocBase()).toOSString());
                        modified = true;
                    }
                    ++i;
                }
            }
            if (!ms.isOK()) {
                MultiStatus multiStatus = ms;
                return multiStatus;
            }
            if (addRootWebapp) {
                Context rootContext = publishedInstance.createContext(0);
                rootContext.setPath("");
                rootContext.setDocBase(deployDir.append("ROOT").toOSString());
                rootContext.setReloadable("false");
                modified = true;
            }
            monitor.worked(100);
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                if (modified) {
                    monitor.subTask(Messages.savingContextConfigTask);
                    factory.save(serverXml.toOSString());
                }
                monitor.worked(100);
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)4, "Context docBase settings updated in server.xml.");
                }
            }
            catch (Exception e) {
                Trace.trace((byte)1, "Could not localize server configuration published to " + baseDir.toOSString() + ": " + e.getMessage());
                Status status = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public static IStatus copyLoaderJar(IPath destDir, String serverId, String tomcatVersion) {
        URL localURL;
        String loaderJar = TomcatVersionHelper.getLoaderJarFile(serverId, tomcatVersion);
        URL installURL = TomcatPlugin.getInstance().getBundle().getEntry(loaderJar);
        if (installURL == null) {
            Trace.trace((byte)2, "Loader jar not found for server ID " + serverId);
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishLoaderJarNotFound, (Object)serverId), null);
        }
        try {
            localURL = FileLocator.toFileURL((URL)installURL);
        }
        catch (IOException e) {
            Trace.trace((byte)2, "Could not convert " + installURL.toString() + " to file URL: " + e.getMessage());
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishURLConvert, (Object[])new String[]{installURL.toString(), e.getLocalizedMessage()}), (Throwable)e);
        }
        destDir.toFile().mkdirs();
        IStatus status = FileUtil.copyFile(localURL, destDir.append(loaderJar).toString());
        return status;
    }

    public static IStatus removeLoaderJar(IPath destDir, String serverId, String tomcatVersion) {
        String loaderJar = TomcatVersionHelper.getLoaderJarFile(serverId, tomcatVersion);
        File loaderFile = destDir.append(loaderJar).toFile();
        if ("org.eclipse.jst.server.tomcat.runtime.70".equals(serverId) && tomcatVersion != null && !loaderFile.exists()) {
            loaderJar = TomcatVersionHelper.getLoaderJarFile(serverId, "");
            loaderFile = destDir.append(loaderJar).toFile();
        }
        if (loaderFile.exists() && !loaderFile.delete()) {
            return new Status(2, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishCantDeleteLoaderJar, (Object)loaderFile.getPath()), null);
        }
        return Status.OK_STATUS;
    }

    public static String getLoaderJarFile(String serverId, String tomcatVersion) {
        String loaderJar;
        block14: {
            int index;
            loaderJar = "/" + serverId + ".loader.jar";
            if ("org.eclipse.jst.server.tomcat.runtime.70".equals(serverId) && tomcatVersion != null && (index = tomcatVersion.indexOf(46)) >= 0 && tomcatVersion.length() > index + 1) {
                String versionStr = tomcatVersion.substring(0, index);
                try {
                    int index2;
                    int version = Integer.parseInt(versionStr);
                    if (version != 7 || (index2 = tomcatVersion.indexOf(46, index + 1)) < 0 || tomcatVersion.length() <= index2 + 1) break block14;
                    versionStr = tomcatVersion.substring(index + 1, index2);
                    try {
                        version = Integer.parseInt(versionStr);
                        if (version != 0) break block14;
                        int index3 = tomcatVersion.indexOf(46, index2 + 1);
                        if (index3 >= 0 && tomcatVersion.length() > index3 + 1) {
                            versionStr = tomcatVersion.substring(index2 + 1, index3);
                        } else {
                            versionStr = tomcatVersion.substring(index2 + 1);
                            int i = 0;
                            while (i < versionStr.length()) {
                                if (!Character.isDigit(versionStr.charAt(i))) {
                                    versionStr = versionStr.substring(0, i);
                                    break;
                                }
                                ++i;
                            }
                        }
                        try {
                            version = Integer.parseInt(versionStr);
                            if (version <= 6) {
                                loaderJar = "/" + serverId + "6.loader.jar";
                            } else if (version <= 8) {
                                loaderJar = "/" + serverId + "8.loader.jar";
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return loaderJar;
    }

    public static IStatus updatePropertiesToServeDirectly(IPath baseDir, String jarLoc, String loader) {
        File catalinaProperties = baseDir.append("conf/catalina.properties").toFile();
        try {
            CatalinaPropertiesUtil.addGlobalClasspath(catalinaProperties, loader, new String[]{"${catalina.base}/" + jarLoc + "/*.jar"});
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorPublishCatalinaProps, (Object)e.getLocalizedMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static IStatus updateContextsToServeDirectly(IPath baseDir, String tomcatVersion, String loader, boolean enableMetaInfResources, IProgressMonitor monitor) {
        IPath confDir = baseDir.append("conf");
        IPath serverXml = confDir.append("server.xml");
        try {
            try {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.publishConfigurationTask, 300);
                monitor.subTask(Messages.publishContextConfigTask);
                Factory factory = new Factory();
                factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                Server publishedServer = (Server)factory.loadDocument(new FileInputStream(serverXml.toFile()));
                ServerInstance publishedInstance = new ServerInstance(publishedServer, null, null);
                monitor.worked(100);
                boolean modified = false;
                boolean isTomcat80 = tomcatVersion.startsWith("8.0");
                boolean isTomcat85 = tomcatVersion.startsWith("8.5");
                boolean isTomcat9 = tomcatVersion.startsWith("9.");
                TomcatPublishModuleVisitor visitor = isTomcat80 ? new Tomcat80PublishModuleVisitor(baseDir, tomcatVersion, publishedInstance, loader, enableMetaInfResources) : (isTomcat85 ? new Tomcat85PublishModuleVisitor(baseDir, tomcatVersion, publishedInstance, loader, enableMetaInfResources) : (isTomcat9 ? new Tomcat90PublishModuleVisitor(baseDir, tomcatVersion, publishedInstance, loader, enableMetaInfResources) : new TomcatPublishModuleVisitor(baseDir, tomcatVersion, publishedInstance, loader, enableMetaInfResources)));
                Context[] contexts = publishedInstance.getContexts();
                int i = 0;
                while (i < contexts.length) {
                    String moduleId = contexts[i].getSource();
                    if (moduleId != null && moduleId.length() > 0) {
                        IModule module = ServerUtil.getModule((String)moduleId);
                        ModuleTraverser.traverse(module, visitor, monitor);
                        modified = true;
                    }
                    ++i;
                }
                if (modified) {
                    monitor.subTask(Messages.savingContextConfigTask);
                    factory.save(serverXml.toOSString());
                }
                monitor.worked(100);
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)4, "Context docBase settings updated in server.xml.");
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not modify context configurations to serve directly for Tomcat configuration " + confDir.toOSString() + ": " + e.getMessage());
                Status status = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public static IStatus moveContextsToSeparateFiles(IPath baseDir, boolean noPath, boolean serverStopped, IProgressMonitor monitor) {
        IPath confDir = baseDir.append("conf");
        IPath serverXml = confDir.append("server.xml");
        try {
            try {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask(Messages.publishConfigurationTask, 300);
                monitor.subTask(Messages.publishContextConfigTask);
                Factory factory = new Factory();
                factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                Server publishedServer = (Server)factory.loadDocument(new FileInputStream(serverXml.toFile()));
                ServerInstance publishedInstance = new ServerInstance(publishedServer, null, null);
                monitor.worked(100);
                boolean modified = false;
                Host host = publishedInstance.getHost();
                Context[] wtpContexts = publishedInstance.getContexts();
                if (wtpContexts != null && wtpContexts.length > 0) {
                    IPath contextPath = publishedInstance.getContextXmlDirectory(serverXml.removeLastSegments(1));
                    File contextDir = contextPath.toFile();
                    if (!contextDir.exists()) {
                        contextDir.mkdirs();
                    }
                    int i = wtpContexts.length - 1;
                    while (i >= 0) {
                        Context context = wtpContexts[i];
                        if (context.getSource() != null) {
                            String name = context.getPath();
                            if (name.startsWith("/")) {
                                name = name.substring(1);
                            }
                            if (name.length() == 0) {
                                name = "ROOT";
                            }
                            name = name.replace('/', '#');
                            if (Boolean.valueOf(context.getAttributeValue("antiResourceLocking")).booleanValue()) {
                                context.setAttributeValue("antiResourceLocking", "false");
                            }
                            File contextFile = new File(contextDir, String.valueOf(name) + ".xml");
                            Context existingContext = TomcatVersionHelper.loadContextFile(contextFile);
                            if (serverStopped || !context.isEquivalent(existingContext)) {
                                if (noPath) {
                                    context.removeAttribute("path");
                                }
                                DocumentBuilder builder = XMLUtil.getDocumentBuilder();
                                Document contextDoc = builder.newDocument();
                                contextDoc.appendChild(contextDoc.importNode(context.getElementNode(), true));
                                XMLUtil.save(contextFile.getAbsolutePath(), contextDoc);
                            }
                            host.removeElement("Context", i);
                            modified = true;
                        }
                        --i;
                    }
                }
                monitor.worked(100);
                if (modified) {
                    monitor.subTask(Messages.savingContextConfigTask);
                    factory.save(serverXml.toOSString());
                }
                monitor.worked(100);
                if (Trace.isTraceEnabled()) {
                    Trace.trace((byte)4, "Context docBase settings updated in server.xml.");
                }
            }
            catch (Exception e) {
                Trace.trace((byte)2, "Could not modify context configurations to serve directly for Tomcat configuration " + confDir.toOSString() + ": " + e.getMessage());
                Status status = new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPublishConfiguration, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private static void loadSeparateContextFiles(File contextDir, Factory factory, Map<File, Context> projectContexts) {
        File[] contextFiles = contextDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".xml");
            }
        });
        int j = 0;
        while (j < contextFiles.length) {
            String memento;
            File ctx = contextFiles[j];
            Context context = TomcatVersionHelper.loadContextFile(ctx);
            if (context != null && (memento = context.getSource()) != null) {
                projectContexts.put(ctx, context);
            }
            ++j;
        }
    }

    private static Context loadContextFile(File contextFile) {
        Context context;
        block14: {
            FileInputStream fis = null;
            context = null;
            if (contextFile != null && contextFile.exists()) {
                try {
                    try {
                        String path;
                        Factory factory = new Factory();
                        factory.setPackageName("org.eclipse.jst.server.tomcat.core.internal.xml.server40");
                        fis = new FileInputStream(contextFile);
                        context = (Context)factory.loadDocument(fis);
                        if (context != null && (path = context.getPath()) == null) {
                            String fileName = contextFile.getName();
                            path = fileName.substring(0, fileName.length() - ".xml".length());
                            if ("ROOT".equals(path)) {
                                path = "";
                            }
                            path = path.replace('#', '/');
                            context.setPath("/" + path);
                        }
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)4, "Unable to read context " + contextFile.getAbsolutePath());
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return context;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IStatus checkCatalinaVersion(IPath installPath, String serverType) {
        File jarFile;
        IPath catalinaJarPath;
        String versionSubString;
        block32: {
            versionSubString = null;
            catalinaJarPath = null;
            jarFile = null;
            if ("org.eclipse.jst.server.tomcat.60".equals(serverType) || "org.eclipse.jst.server.tomcat.70".equals(serverType) || "org.eclipse.jst.server.tomcat.80".equals(serverType) || "org.eclipse.jst.server.tomcat.85".equals(serverType) || "org.eclipse.jst.server.tomcat.90".equals(serverType)) {
                catalinaJarPath = installPath.append("lib").append("catalina.jar");
                jarFile = catalinaJarPath.toFile();
                if (!jarFile.exists() && !(jarFile = (catalinaJarPath = installPath.append("server/lib").append("catalina.jar")).toFile()).exists()) {
                    catalinaJarPath = null;
                }
            } else if (("org.eclipse.jst.server.tomcat.50".equals(serverType) || "org.eclipse.jst.server.tomcat.55".equals(serverType) || "org.eclipse.jst.server.tomcat.41".equals(serverType)) && !(jarFile = (catalinaJarPath = installPath.append("server/lib").append("catalina.jar")).toFile()).exists() && !(jarFile = (catalinaJarPath = installPath.append("lib").append("catalina.jar")).toFile()).exists()) {
                catalinaJarPath = null;
            }
            if (catalinaJarPath == null) return Status.CANCEL_STATUS;
            versionSubString = catalinaJarVersion.get(catalinaJarPath);
            long checkTime = System.currentTimeMillis();
            if (versionSubString != null && checkTime - lastCheck > 2000L) {
                long curLastModified = jarFile.lastModified();
                Long oldLastModified = catalinaJarLastModified.get(catalinaJarPath);
                if (oldLastModified == null || curLastModified != oldLastModified) {
                    versionSubString = null;
                }
            }
            lastCheck = checkTime;
            if (versionSubString == null) {
                InputStream is = null;
                JarFile jar = null;
                try {
                    try {
                        jar = new JarFile(jarFile);
                        JarEntry entry = jar.getJarEntry("org/apache/catalina/util/ServerInfo.properties");
                        if (entry != null && (is = jar.getInputStream(entry)) != null) {
                            int index;
                            Properties props = new Properties();
                            props.load(is);
                            String serverVersion = props.getProperty("server.info");
                            if (serverVersion != null && (index = serverVersion.indexOf("/")) > 0) {
                                versionSubString = serverVersion.substring(index + 1);
                                catalinaJarVersion.put(catalinaJarPath, versionSubString);
                                catalinaJarLastModified.put(catalinaJarPath, new Long(jarFile.lastModified()));
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        if (jar != null) {
                            try {
                                jar.close();
                            }
                            catch (IOException iOException3) {}
                        }
                        break block32;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (jar == null) throw throwable;
                    try {
                        jar.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (versionSubString != null) {
            if (versionSubString.length() <= 0) return Status.CANCEL_STATUS;
            String versionTest = versionStringMap.get(serverType);
            if (versionTest == null || versionSubString.startsWith(versionTest)) return Status.OK_STATUS;
            return new Status(4, "org.eclipse.jst.server.tomcat.core", NLS.bind((String)Messages.errorInstallDirWrongVersion2, (Object)versionSubString, (Object)versionTest.substring(0, versionTest.length() - 1)));
        }
        catalinaJarVersion.put(catalinaJarPath, "");
        catalinaJarLastModified.put(catalinaJarPath, new Long(jarFile.lastModified()));
        return Status.CANCEL_STATUS;
    }

    public static String getCatalinaVersion(IPath installPath, String serverType) {
        for (Map.Entry<IPath, String> entry : catalinaJarVersion.entrySet()) {
            IPath jarPath = entry.getKey();
            if (!installPath.isPrefixOf(jarPath)) continue;
            return entry.getValue();
        }
        IStatus result = TomcatVersionHelper.checkCatalinaVersion(installPath, serverType);
        if (result.isOK()) {
            for (Map.Entry<IPath, String> entry : catalinaJarVersion.entrySet()) {
                IPath jarPath = entry.getKey();
                if (!installPath.isPrefixOf(jarPath)) continue;
                return entry.getValue();
            }
        }
        return "";
    }
}

