/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.view;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.TaglibBasedViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletViewDefnAdapter
extends TaglibBasedViewDefnAdapter {
    protected FaceletViewDefnAdapter(ITagRegistry tagRegistry) {
        super(tagRegistry);
    }

    public IDocument getContainer(DTFacesContext context, String viewId) {
        IResource viewDefn = context.adaptContextObject();
        if (viewDefn instanceof IFile) {
            IFile viewDefnFile = (IFile)viewDefn;
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(viewDefnFile);
                IStructuredDocument iStructuredDocument = model.getStructuredDocument();
                return iStructuredDocument;
            }
            catch (IOException e) {
                JSFCorePlugin.log((Exception)e, (String)"Acquiring model for view root");
            }
            catch (CoreException e) {
                JSFCorePlugin.log((Exception)((Object)e), (String)"Acquiring model for view root");
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    public XMLViewDefnAdapter.DTELExpression getELExpression(IModelContext genericContext) throws IDTViewHandler.ViewHandlerException {
        IStructuredDocumentContext context = (IStructuredDocumentContext)genericContext.getAdapter(IStructuredDocumentContext.class);
        if (context == null) {
            throw new IDTViewHandler.ViewHandlerException(IDTViewHandler.ViewHandlerException.Cause.EL_NOT_FOUND);
        }
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        if (resolver != null) {
            int elCloseIdx;
            String attributeText;
            int elOpenIdx;
            String regionType = resolver.getRegionType();
            int startOffset = resolver.getStartOffset();
            int relativeOffset = context.getDocumentPosition() - startOffset;
            if ("XML_TAG_ATTRIBUTE_VALUE".equals(regionType) && (elOpenIdx = (attributeText = resolver.getRegionText()).indexOf("#")) >= 0 && elOpenIdx < relativeOffset && elOpenIdx + 1 < attributeText.length() && attributeText.charAt(elOpenIdx + 1) == '{' && (elCloseIdx = attributeText.indexOf(125, elOpenIdx + 1)) != -1) {
                IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), resolver.getStartOffset() + elOpenIdx + 2);
                String elText = attributeText.substring(elOpenIdx + 2, elCloseIdx);
                return new XMLViewDefnAdapter.DTELExpression(elContext, elText);
            }
        }
        return null;
    }

    public String getNamespace(Element element, IDocument doc) {
        String prefix;
        Map<String, PrefixEntry> namespaces = this.getDocumentNamespaces(element.getOwnerDocument());
        PrefixEntry prefixEntry = namespaces.get(prefix = element.getPrefix());
        if (prefixEntry != null) {
            return prefixEntry.getUri();
        }
        return null;
    }

    public String getPrefix(String namespace, IDocument document) {
        Document xmlDoc;
        IDOMContextResolver resolver;
        if (namespace == null || "".equals(namespace.trim())) {
            return null;
        }
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(document, -1);
        if (context != null && (resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context)) != null && (xmlDoc = resolver.getDOMDocument()) != null) {
            Map<String, PrefixEntry> map = this.getDocumentNamespaces(xmlDoc);
            for (Map.Entry<String, PrefixEntry> mapEntry : map.entrySet()) {
                if (!namespace.equals(mapEntry.getValue().getUri())) continue;
                return mapEntry.getKey();
            }
        }
        return null;
    }

    private Map<String, PrefixEntry> getDocumentNamespaces(Document doc) {
        HashMap<String, PrefixEntry> namespaces = new HashMap<String, PrefixEntry>();
        Element rootElement = doc.getDocumentElement();
        if (rootElement != null) {
            NamedNodeMap attrs = rootElement.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr a = (Attr)attrs.item(i);
                PrefixEntry ns = PrefixEntry.parseNamespace(a);
                if (ns != null) {
                    namespaces.put(ns._prefix, ns);
                }
                ++i;
            }
        }
        return namespaces;
    }

    private static class PrefixEntry {
        private static final String XMLNS = "xmlns";
        private final String _uri;
        private final String _prefix;

        public static PrefixEntry parseNamespace(Attr attr) {
            String uri;
            String prefixName;
            String prefix = attr.getPrefix();
            if (XMLNS.equals(prefix) && (prefixName = attr.getLocalName()) != null && (uri = attr.getNodeValue()) != null) {
                return new PrefixEntry(uri, prefixName);
            }
            return null;
        }

        public PrefixEntry(String uri, String prefix) {
            this._uri = uri;
            this._prefix = prefix;
        }

        public final String getUri() {
            return this._uri;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object obj) {
            return this._uri.equals(obj);
        }
    }
}

