/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.npm.internal.wizard;

import org.eclipse.core.internal.resources.Container;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.jsdt.js.common.util.WorkbenchResourceUtil;
import org.eclipse.wst.jsdt.js.npm.NpmPlugin;
import org.eclipse.wst.jsdt.js.npm.PackageJson;
import org.eclipse.wst.jsdt.js.npm.internal.Messages;
import org.eclipse.wst.jsdt.js.npm.internal.wizard.NpmInitPage;
import org.eclipse.wst.jsdt.js.npm.util.NpmUtil;

public class NpmInitWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private NpmInitPage npmInitPage;

    public NpmInitWizard() {
        this.setDefaultPageImageDescriptor(NpmPlugin.getImageDescriptor("/icons/npm_75.png"));
        this.setWindowTitle(Messages.NpmInitWizard_WindowTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        this.npmInitPage = new NpmInitPage(this.selection);
        this.addPage((IWizardPage)this.npmInitPage);
    }

    public boolean performFinish() {
        PackageJson packageJson = this.npmInitPage.getModel();
        String dir = this.npmInitPage.getExecutionDir();
        try {
            IFile file;
            IContainer root = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(dir));
            if (root != null && root.exists() && !(file = ((Container)root).getFile("package.json")).exists()) {
                String json = NpmUtil.generateJson(packageJson);
                WorkbenchResourceUtil.createFile((IFile)file, (String)json);
                WorkbenchResourceUtil.openInEditor((IFile)file, null);
            }
        }
        catch (CoreException e) {
            NpmPlugin.logError(e);
            return false;
        }
        return true;
    }
}

