/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.perf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.el.AbstractDTVariableResolver;
import org.eclipse.jst.jsf.test.util.PerfTracker;
import org.eclipse.jst.jsf.validation.el.tests.base.ELAssert;
import org.eclipse.jst.jsf.validation.el.tests.base.JSPTestCase;
import org.eclipse.jst.jsf.validation.el.tests.base.MockELValidationReporter;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class StressTest
extends JSPTestCase {
    protected IFile _testJSP;
    private IStructuredModel _structuredModel;
    private IStructuredDocument _structuredDocument;

    public StressTest() {
        super(JSFVersion.V1_1, "/testdata/web/faces-config_1_1.xml.data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this._testJSP = this.loadJSP("/testdata/jsps/perfTest1.jsp.data", "/perfTest1.jsp");
        this._structuredModel = StructuredModelManager.getModelManager().getModelForRead(this._testJSP);
        this._structuredDocument = this._structuredModel.getStructuredDocument();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this._structuredModel != null) {
            this._structuredModel.releaseFromRead();
        }
    }

    public void testStressVariableResolver() {
        AbstractDTVariableResolver variableRes = DesignTimeApplicationManager.getInstance((IProject)this._testEnv.getTestProject()).getVariableResolver();
        DTFacesContext facesContext = DesignTimeApplicationManager.getInstance((IProject)this._testEnv.getTestProject()).getFacesContext(this._testJSP);
        PerfTracker perfTracker = new PerfTracker("Stress Variable Resolver", 100000);
        int x = 0;
        while (x < 100000) {
            long startTime = System.nanoTime();
            ISymbol var = variableRes.resolveVariable(facesContext, "myBean", (IAdaptable)this._testJSP);
            perfTracker.recordTime(System.nanoTime() - startTime);
            StressTest.assertNotNull((Object)var);
            StressTest.assertEquals((String)"myBean", (String)var.getName());
            ++x;
        }
        perfTracker.printReport(System.out);
    }

    public void testStressPropertyResolver() {
        AbstractDTVariableResolver variableRes = DesignTimeApplicationManager.getInstance((IProject)this._testEnv.getTestProject()).getVariableResolver();
        DTFacesContext facesContext = DesignTimeApplicationManager.getInstance((IProject)this._testEnv.getTestProject()).getFacesContext(this._testJSP);
        ISymbol var = variableRes.resolveVariable(facesContext, "myBean", (IAdaptable)this._testJSP);
        AbstractDTPropertyResolver propRes = DesignTimeApplicationManager.getInstance((IProject)this._testEnv.getTestProject()).getPropertyResolver();
        PerfTracker perfTracker = new PerfTracker("Stress Property Resolver", 1000);
        int x = 0;
        while (x < 1000) {
            long startTime = System.nanoTime();
            ISymbol property = propRes.getProperty(var, (Object)"stringProperty");
            perfTracker.recordTime(System.nanoTime() - startTime);
            StressTest.assertNotNull((Object)property);
            StressTest.assertEquals((String)"stringProperty", (String)property.getName());
            ++x;
        }
        perfTracker.printReport(System.out);
    }

    public void testStressSimpleValueBindingValidation() {
        StressTest.assertEquals((String)"myBean.stringProperty", (String)ELAssert.getELText(this._structuredDocument, 795));
        PerfTracker perfTracker = new PerfTracker("Stress Simple Bean Property Validation", 1000);
        int x = 0;
        while (x < 1000) {
            MockELValidationReporter reporter = new MockELValidationReporter();
            ELExpressionValidator validator = ELAssert.createELValidator(this._structuredDocument, 795, this._testJSP, reporter, this._symbolResolverFactory);
            long startTime = System.nanoTime();
            validator.validateXMLNode();
            perfTracker.recordTime(System.nanoTime() - startTime);
            ++x;
        }
        perfTracker.printReport(System.out);
    }
}

