/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;

public abstract class DatabaseObjectDefinition
implements Cloneable,
Serializable {
    public String name = "";
    public String qualifier = "";

    protected static final FieldTypeDefinition getFieldTypeDefinition(AbstractSession session, Class type, String name) {
        FieldTypeDefinition fieldType;
        FieldTypeDefinition fieldTypeDefinition = fieldType = type != null ? session.getPlatform().getFieldTypeDefinition(type) : new FieldTypeDefinition(name);
        if (fieldType == null) {
            throw ValidationException.javaTypeIsNotAValidDatabaseType(type);
        }
        return fieldType;
    }

    protected static final FieldTypeDefinition getFieldTypeDefinition(DatabasePlatform platform, Class type, String name) {
        FieldTypeDefinition fieldType;
        if (type != null) {
            fieldType = platform.getFieldTypeDefinition(type);
            if (fieldType == null) {
                throw ValidationException.javaTypeIsNotAValidDatabaseType(type);
            }
        } else if (name != null) {
            Map<String, Class> fieldTypes = platform.getClassTypes();
            Class typeFromName = fieldTypes.get(name);
            if (typeFromName == null) {
                fieldType = new FieldTypeDefinition(name);
            } else {
                fieldType = platform.getFieldTypeDefinition(typeFromName);
                if (fieldType == null) {
                    throw ValidationException.javaTypeIsNotAValidDatabaseType(typeFromName);
                }
            }
        } else {
            throw ValidationException.javaTypeIsNotAValidDatabaseType(null);
        }
        return fieldType;
    }

    public abstract Writer buildCreationWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Writer buildVPDCreationPolicyWriter(AbstractSession session, Writer writer) {
        return null;
    }

    public Writer buildVPDCreationFunctionWriter(AbstractSession session, Writer writer) {
        return null;
    }

    public Writer buildVPDDeletionWriter(AbstractSession session, Writer writer) {
        return null;
    }

    public abstract Writer buildDeletionWriter(AbstractSession var1, Writer var2) throws ValidationException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void createDatabaseSchema(AbstractSession session, Writer writer, Set<String> createdDatabaseSchemas) throws EclipseLinkException {
    }

    public void createDatabaseSchemaOnDatabase(AbstractSession session, Set<String> createdDatabaseSchemas) throws EclipseLinkException {
    }

    public void createObject(AbstractSession session, Writer schemaWriter) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.createOnDatabase(session);
        } else {
            this.buildCreationWriter(session, schemaWriter);
            if (this.shouldCreateVPDCalls(session)) {
                this.buildVPDCreationPolicyWriter(session, schemaWriter);
                this.buildVPDCreationFunctionWriter(session, schemaWriter);
            }
        }
    }

    public void createOnDatabase(AbstractSession session) throws EclipseLinkException {
        session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildCreationWriter(session, new StringWriter()).toString()));
        if (this.shouldCreateVPDCalls(session)) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDCreationPolicyWriter(session, new StringWriter()).toString()));
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDCreationFunctionWriter(session, new StringWriter()).toString()));
        }
    }

    public boolean shouldCreateDatabaseSchema(Set<String> createdDatabaseSchemas) {
        return false;
    }

    public boolean shouldCreateVPDCalls(AbstractSession session) {
        return false;
    }

    public void dropDatabaseSchema(AbstractSession session, Writer writer) throws EclipseLinkException {
    }

    public void dropDatabaseSchemaOnDatabase(AbstractSession session) throws EclipseLinkException {
    }

    public void dropFromDatabase(AbstractSession session) throws EclipseLinkException {
        session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildDeletionWriter(session, new StringWriter()).toString()));
        if (this.shouldCreateVPDCalls(session)) {
            session.priviledgedExecuteNonSelectingCall(new SQLCall(this.buildVPDDeletionWriter(session, new StringWriter()).toString()));
        }
    }

    public void dropObject(AbstractSession session, Writer schemaWriter, boolean createSQLFiles) throws EclipseLinkException {
        if (schemaWriter == null) {
            this.dropFromDatabase(session);
        } else {
            this.buildDeletionWriter(session, schemaWriter);
            if (this.shouldCreateVPDCalls(session)) {
                this.buildVPDDeletionWriter(session, schemaWriter);
            }
        }
    }

    public String getDatabaseSchema() {
        return null;
    }

    public String getFullName() {
        if (this.getQualifier().equals("")) {
            return this.getName();
        }
        return String.valueOf(this.getQualifier()) + "." + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    protected boolean hasDatabaseSchema() {
        return this.getDatabaseSchema() != null && !this.getDatabaseSchema().equals("");
    }

    public void postCreateObject(AbstractSession session, Writer createSchemaWriter, boolean createSQLFiles) {
    }

    public void preDropObject(AbstractSession session, Writer dropSchemaWriter, boolean createSQLFiles) {
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.getFullName() + ")";
    }
}

