/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.impl.AbstractCreateConnectionFeature;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.AddHasReferenceRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.modelintegration.util.ModelIntegrationUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasCollectionReferenceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class EmbedCollectionOfObjectsFeature
extends AbstractCreateConnectionFeature {
    private PersistentType embeddingEntity;

    public EmbedCollectionOfObjectsFeature(IFeatureProvider fp) {
        this(fp, JPAEditorMessages.EmbedCollectionOfObjectsFeature_ElementCollectionFeatureName, JPAEditorMessages.EmbedCollectionOfObjectsFeature_ElementCollectionFeatureDescription);
    }

    public EmbedCollectionOfObjectsFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        PersistentType embeddingEntity = this.getPersistentType(context.getSourceAnchor());
        PersistentType embeddable = this.getPersistentType(context.getTargetAnchor());
        if (embeddable == null || embeddingEntity == null) {
            return false;
        }
        if (!JpaArtifactFactory.instance().isEmbeddable(embeddable)) {
            return false;
        }
        if (!JpaArtifactFactory.instance().isEntity(embeddingEntity) && !JpaArtifactFactory.instance().isEmbeddable(embeddingEntity)) {
            return false;
        }
        return !this.isNotAllowed(embeddingEntity, embeddable);
    }

    public Connection create(ICreateConnectionContext context) {
        PersistentType embeddingEntity = this.getPersistentType(context.getSourceAnchor());
        PersistentType embeddable = this.getPersistentType(context.getTargetAnchor());
        boolean isMap = JPADiagramPropertyPage.isMapType(embeddingEntity.getJpaProject().getProject());
        String mapKeyType = null;
        if (isMap) {
            mapKeyType = "java.lang.String";
        }
        PersistentAttribute embeddedAttribute = JPAEditorUtil.addAnnotatedAttribute(embeddingEntity, embeddable, true, mapKeyType);
        PersistentAttribute ormAttr = JpaArtifactFactory.instance().addOrmPersistentAttribute(embeddingEntity, embeddedAttribute, "elementCollection");
        if (ormAttr == null || ormAttr.isVirtual()) {
            embeddedAttribute.getJavaPersistentAttribute().setMappingKey("elementCollection");
        }
        HasCollectionReferenceRelation rel = new HasCollectionReferenceRelation(embeddingEntity, embeddable);
        rel.setEmbeddedAnnotatedAttribute(embeddedAttribute);
        AddHasReferenceRelationFeature ft = new AddHasReferenceRelationFeature(this.getFeatureProvider());
        AddConnectionContext cont = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        cont.setNewObject((Object)rel);
        Connection connection = (Connection)ft.add((IAddContext)cont);
        return connection;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        this.embeddingEntity = this.getPersistentType(context.getSourceAnchor());
        return this.embeddingEntity != null;
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.element-collection";
    }

    protected PersistentType getPersistentType(Anchor anchor) {
        Object refObject;
        if (anchor != null && (refObject = this.getBusinessObjectForPictogramElement((PictogramElement)anchor.getParent())) instanceof PersistentType) {
            return (PersistentType)refObject;
        }
        return null;
    }

    private boolean isEmbeddableAlreadyEmbeddedAsElementCollection(PersistentType jpt, boolean isEmbedded) {
        Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelationsByEmbeddable(jpt, this.getFeatureProvider());
        if (!refs.isEmpty()) {
            for (HasReferanceRelation ref : refs) {
                if (!ref.getReferenceType().equals((Object)HasReferanceRelation.HasReferenceType.COLLECTION)) continue;
                if (!isEmbedded && ref.getEmbeddable().getName().equals(jpt.getName())) {
                    return true;
                }
                if (!isEmbedded || !ref.getEmbeddingEntity().getName().equals(jpt.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotAllowed(PersistentType embeddingEntity, PersistentType embeddable) {
        boolean notAllowed = false;
        if (JpaArtifactFactory.instance().isEmbeddable(embeddable)) {
            for (PersistentAttribute attr : embeddable.getAllAttributes()) {
                if (!attr.getMappingKey().equals("elementCollection")) continue;
                return true;
            }
        }
        if (JpaArtifactFactory.instance().isEmbeddable(embeddingEntity)) {
            notAllowed = this.isEmbeddableAlreadyEmbeddedAsElementCollection(embeddingEntity, false);
        } else if (JpaArtifactFactory.instance().isEntity(embeddingEntity)) {
            notAllowed = this.isEmbeddableAlreadyEmbeddedAsElementCollection(embeddable, true);
        }
        return notAllowed;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public void attachedToSource(ICreateConnectionContext context) {
        super.attachedToSource(context);
        this.getFeatureProvider().setOriginalPersistentTypeColor();
        this.disableUnvalidRelationTargets();
    }

    public void endConnecting() {
        super.endConnecting();
        this.getFeatureProvider().setOriginalPersistentTypeColor();
    }

    public void startConnecting() {
        super.startConnecting();
        this.disableAllMappedSuperclasses();
    }

    private void disableUnvalidRelationTargets() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        if (JpaArtifactFactory.instance().isEntity(this.embeddingEntity) || JpaArtifactFactory.instance().isEmbeddable(this.embeddingEntity)) {
            this.disableAllNotEmbeddablesOrEmbedAsElementCollection(unit);
        } else if (JpaArtifactFactory.instance().isMappedSuperclass(this.embeddingEntity)) {
            this.disableAllPersistentType(unit);
        }
    }

    private void disableAllNotEmbeddablesOrEmbedAsElementCollection(PersistenceUnit unit) {
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (!JpaArtifactFactory.instance().isEntity((PersistentType)jpt) && !JpaArtifactFactory.instance().isMappedSuperclass((PersistentType)jpt) && !this.embeddingEntity.getName().equals(jpt.getName()) && !this.isNotAllowed(this.embeddingEntity, (PersistentType)jpt)) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private void disableAllPersistentType(PersistenceUnit unit) {
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }

    private void disableAllMappedSuperclasses() {
        Diagram d = this.getDiagram();
        JpaProject project = ModelIntegrationUtil.getProjectByDiagram(d.getName());
        PersistenceUnit unit = (PersistenceUnit)project.getContextRoot().getPersistenceXml().getRoot().getPersistenceUnits().iterator().next();
        for (ClassRef classRef : unit.getClassRefs()) {
            if (classRef.getJavaPersistentType() == null) continue;
            JavaPersistentType jpt = classRef.getJavaPersistentType();
            if (!JpaArtifactFactory.instance().isMappedSuperclass((PersistentType)jpt)) continue;
            this.getFeatureProvider().setGrayColor((PersistentType)jpt);
        }
    }
}

