/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BP2107
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean schemaFound = false;
    private ErrorList errors = new ErrorList();

    public BP2107(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        Types t = (Types)entryContext.getEntry().getEntryDetail();
        List exts = t.getExtensibilityElements();
        if (exts != null) {
            Iterator it = exts.iterator();
            while (it.hasNext()) {
                ExtensibilityElement el = (ExtensibilityElement)it.next();
                if (!(el instanceof Schema)) continue;
                this.searchForSchema(((Schema)el).getElement());
            }
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.schemaFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForSchema(Node n) {
        while (n != null) {
            if (1 == n.getNodeType()) {
                if (XMLUtils.equals(n, ELEM_XSD_SCHEMA)) {
                    this.schemaFound = true;
                    this.processSchema(n, null);
                } else {
                    this.searchForSchema(n.getFirstChild());
                }
            }
            n = n.getNextSibling();
        }
    }

    private void processSchema(Node schema, String namespace) {
        Attr a = XMLUtils.getAttribute((Element)schema, ATTR_XSD_TARGETNAMESPACE);
        String targetNamespace = a != null ? a.getValue() : null;
        Node n = schema.getFirstChild();
        boolean containsOnlyImportAndAnnotation = true;
        while (n != null) {
            if (n.getNodeType() == 1) {
                containsOnlyImportAndAnnotation &= XMLUtils.equals(n, ELEM_XSD_IMPORT) || XMLUtils.equals(n, ELEM_XSD_ANNOTATION);
            }
            n = n.getNextSibling();
        }
        if (!(targetNamespace != null && targetNamespace.length() != 0 || containsOnlyImportAndAnnotation)) {
            this.errors.add(targetNamespace, XMLUtils.serialize((Element)schema));
        }
        if (namespace != null && !namespace.equals(targetNamespace)) {
            this.errors.add(namespace, XMLUtils.serialize((Element)schema));
        }
    }
}

