/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.EditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.preferences.OverlayPreferenceStore;
import org.eclipse.wst.sse.ui.internal.preferences.TabFolderLayout;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ColorEditor;
import org.eclipse.wst.sse.ui.internal.preferences.ui.IPreferenceTab;
import org.eclipse.wst.sse.ui.internal.preferences.ui.StatusInfo;
import org.eclipse.wst.sse.ui.internal.preferences.ui.TextHoverPreferenceTab;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;

public class StructuredTextEditorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorEditor fAppearanceColorEditor;
    private List fAppearanceColorList;
    private final String[][] fAppearanceColorListModel = new String[][]{{SSEUIMessages.StructuredTextEditorPreferencePage_2, EditorPreferenceNames.MATCHING_BRACKETS_COLOR}, {SSEUIMessages.StructuredTextEditorPreferencePage_41, "content_assist_proposals_background"}, {SSEUIMessages.StructuredTextEditorPreferencePage_42, "content_assist_proposals_foreground"}, {SSEUIMessages.StructuredTextEditorPreferencePage_43, "content_assist_parameters_background"}, {SSEUIMessages.StructuredTextEditorPreferencePage_44, "content_assist_parameters_foreground"}};
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            StructuredTextEditorPreferencePage.this.fOverlayStore.setValue((String)StructuredTextEditorPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    private Map fColorButtons = new HashMap();
    private ArrayList fNumberFields = new ArrayList();
    private OverlayPreferenceStore fOverlayStore;
    Button fSetDefaultButton;
    private IPreferenceTab[] fTabs = null;
    private Map fTextFields = new HashMap();

    public StructuredTextEditorPreferencePage() {
        this.setDescription(SSEUIMessages.StructuredTextEditorPreferencePage_6);
        this.setPreferenceStore(SSEUIPlugin.getDefault().getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    private Control createAppearancePage(Composite parent) {
        Composite appearanceComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        appearanceComposite.setLayout((Layout)layout);
        String label = SSEUIMessages.StructuredTextEditorPreferencePage_20;
        this.addCheckBox(appearanceComposite, label, EditorPreferenceNames.MATCHING_BRACKETS, 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_30;
        this.addCheckBox(appearanceComposite, label, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS, 0);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(appearanceComposite, 0, "ValidationPreferencePage", SSEUIMessages.StructuredTextEditorPreferencePage_40, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        data.horizontalIndent = 20;
        contentTypeArea.getControl().setLayoutData((Object)data);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_39;
        this.addCheckBox(appearanceComposite, label, "showUnknownContentTypeMsg", 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_3;
        this.addCheckBox(appearanceComposite, label, "foldingEnabled", 0);
        label = SSEUIMessages.StructuredTextEditorPreferencePage_1;
        this.addCheckBox(appearanceComposite, label, "semanticHighlighting", 0);
        Label l = new Label(appearanceComposite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = this.convertHeightInCharsToPixels(1) / 2;
        l.setLayoutData((Object)gd);
        l = new Label(appearanceComposite, 16384);
        l.setText(SSEUIMessages.StructuredTextEditorPreferencePage_23);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        Composite editorComposite = new Composite(appearanceComposite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        gd = new GridData(1296);
        gd.horizontalSpan = 2;
        editorComposite.setLayoutData((Object)gd);
        this.fAppearanceColorList = new List(editorComposite, 2564);
        gd = new GridData(770);
        gd.heightHint = this.convertHeightInCharsToPixels(7);
        this.fAppearanceColorList.setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        l = new Label(stylesComposite, 16384);
        final String buttonLabel = SSEUIMessages.StructuredTextEditorPreferencePage_24;
        l.setText(buttonLabel);
        gd = new GridData();
        gd.horizontalAlignment = 1;
        l.setLayoutData((Object)gd);
        this.fAppearanceColorEditor = new ColorEditor(stylesComposite);
        Button foregroundColorButton = this.fAppearanceColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fAppearanceColorList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                StructuredTextEditorPreferencePage.this.handleAppearanceColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = StructuredTextEditorPreferencePage.this.fAppearanceColorList.getSelectionIndex();
                String key = StructuredTextEditorPreferencePage.this.fAppearanceColorListModel[i][1];
                PreferenceConverter.setValue((IPreferenceStore)StructuredTextEditorPreferencePage.this.fOverlayStore, (String)key, (RGB)StructuredTextEditorPreferencePage.this.fAppearanceColorEditor.getColorValue());
            }
        });
        foregroundColorButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID == -1) {
                    e.result = buttonLabel;
                }
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)appearanceComposite, "org.eclipse.wst.sse.ui.sted0001");
        return appearanceComposite;
    }

    protected Control createContents(Composite parent) {
        TextHoverPreferenceTab hoversTab = new TextHoverPreferenceTab(this, this.fOverlayStore);
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(SSEUIMessages.StructuredTextEditorPreferencePage_0);
        item.setControl(this.createAppearancePage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(hoversTab.getTitle());
        item.setControl(hoversTab.createContents((Composite)folder));
        this.fTabs = new IPreferenceTab[]{hoversTab};
        this.initialize();
        Dialog.applyDialogFont((Control)folder);
        return folder;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, EditorPreferenceNames.MATCHING_BRACKETS_COLOR));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, EditorPreferenceNames.MATCHING_BRACKETS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "showUnknownContentTypeMsg"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "foldingEnabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "semanticHighlighting"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_proposals_foreground"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_background"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "content_assist_parameters_foreground"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    private void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        while (i < this.fAppearanceColorListModel.length) {
            this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
            ++i;
        }
        this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (StructuredTextEditorPreferencePage.this.fAppearanceColorList != null && !StructuredTextEditorPreferencePage.this.fAppearanceColorList.isDisposed()) {
                    StructuredTextEditorPreferencePage.this.fAppearanceColorList.select(0);
                    StructuredTextEditorPreferencePage.this.handleAppearanceColorListSelection();
                }
            }
        });
    }

    private void initializeFields() {
        String key;
        Iterator e = this.fColorButtons.keySet().iterator();
        while (e.hasNext()) {
            ColorEditor c = (ColorEditor)e.next();
            key = (String)this.fColorButtons.get(c);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            c.setColorValue(rgb);
        }
        e = this.fCheckBoxes.keySet().iterator();
        while (e.hasNext()) {
            Button b = (Button)e.next();
            key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        e = this.fTextFields.keySet().iterator();
        while (e.hasNext()) {
            Text t = (Text)e.next();
            key = (String)this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
    }

    protected void performApply() {
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performApply();
            ++i;
        }
        super.performApply();
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performDefaults();
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        int i = 0;
        while (i < this.fTabs.length) {
            this.fTabs[i].performOk();
            ++i;
        }
        this.fOverlayStore.propagate();
        SSEUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = (Text)this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(SSEUIMessages.StructuredTextEditorPreferencePage_37);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(String.valueOf(number) + SSEUIMessages.StructuredTextEditorPreferencePage_38);
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(String.valueOf(number) + SSEUIMessages.StructuredTextEditorPreferencePage_38);
            }
        }
        return status;
    }
}

