/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;

public abstract class AbstractSimultaneousIterator<E, I extends Iterator<? extends E>>
implements Iterator<List<E>> {
    final Iterable<? extends I> iterators;
    final int iteratorsSize;

    <T extends I> AbstractSimultaneousIterator(Iterable<T> iterators) {
        this(iterators, -1);
    }

    <T extends I> AbstractSimultaneousIterator(Iterable<T> iterators, int iteratorsSize) {
        if (iterators == null) {
            throw new NullPointerException();
        }
        this.iterators = iterators;
        this.iteratorsSize = iteratorsSize;
    }

    @Override
    public boolean hasNext() {
        if (this.iteratorsIsEmpty()) {
            return false;
        }
        for (Iterator iterator : this.iterators) {
            if (iterator.hasNext()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<E> next() {
        if (this.iteratorsIsEmpty()) {
            throw new NoSuchElementException();
        }
        ArrayList result = this.buildList();
        for (Iterator iterator : this.iterators) {
            result.add(iterator.next());
        }
        return result;
    }

    ArrayList<E> buildList() {
        return this.iteratorsSize < 0 ? new ArrayList() : new ArrayList(this.iteratorsSize);
    }

    @Override
    public void remove() {
        if (this.iteratorsIsEmpty()) {
            throw new IllegalStateException();
        }
        for (Iterator iterator : this.iterators) {
            iterator.remove();
        }
    }

    boolean iteratorsIsEmpty() {
        return IterableTools.isEmpty(this.iterators);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterators);
    }
}

