/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.command;

import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.MappedByRelationship;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.java.OwnableRelationshipMappingAnnotation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class SetMappedByNewValueCommand
implements Command {
    private IJPAEditorFeatureProvider fp;
    private PersistenceUnit pu;
    private String inverseEntityName;
    private String inverseAttributeName;
    private String newAtName;
    private PersistentAttribute oldAt;

    public SetMappedByNewValueCommand(IJPAEditorFeatureProvider fp, PersistenceUnit pu, String inverseEntityName, String inverseAttributeName, String newAt, PersistentAttribute oldAt) {
        this.fp = fp;
        this.pu = pu;
        this.inverseEntityName = inverseEntityName;
        this.inverseAttributeName = inverseAttributeName;
        this.newAtName = newAt;
        this.oldAt = oldAt;
    }

    public void execute() {
        this.fp.addAttribForUpdate(this.pu, String.valueOf(this.inverseEntityName) + ";" + this.inverseAttributeName + ";" + this.newAtName + ";" + this.oldAt.getName());
        PersistentType pt = this.pu.getPersistentType(this.inverseEntityName);
        if (pt == null) {
            return;
        }
        PersistentAttribute pa = pt.getAttributeNamed(this.inverseAttributeName);
        if (pa == null) {
            return;
        }
        AttributeMapping m = JpaArtifactFactory.instance().getAttributeMapping(pa);
        if (m != null && m instanceof RelationshipMapping) {
            JavaAttributeMapping attrM;
            Annotation a;
            MappedByRelationship mappedByrelationShip = (MappedByRelationship)((RelationshipMapping)m).getRelationship();
            SpecifiedMappedByRelationshipStrategy mappedByStrategy = mappedByrelationShip.getMappedByStrategy();
            String mappedBy = mappedByStrategy.getMappedByAttribute();
            if (mappedBy == null) {
                return;
            }
            String[] mappedByAttrs = mappedBy.split("\\.");
            if (mappedByAttrs.length > 1) {
                if (mappedByAttrs[0].equals(this.oldAt.getName())) {
                    mappedBy = String.valueOf(this.newAtName) + "." + mappedByAttrs[1];
                } else if (mappedByAttrs[1].equals(this.oldAt.getName())) {
                    mappedBy = String.valueOf(mappedByAttrs[0]) + "." + this.newAtName;
                }
            } else {
                mappedBy = this.newAtName;
            }
            mappedByStrategy.setMappedByAttribute(mappedBy);
            if (pa.getJavaPersistentAttribute() != null && JpaArtifactFactory.instance().getORMPersistentAttribute(pa) == null && (a = (attrM = pa.getJavaPersistentAttribute().getMapping()).getMappingAnnotation()) != null) {
                ((OwnableRelationshipMappingAnnotation)a).setMappedBy(mappedBy);
            }
        }
    }
}

