/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.catalog.tests.internal;

import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wst.xml.catalog.tests.internal.AbstractCatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.CatalogTest;
import org.eclipse.wst.xml.catalog.tests.internal.TestPlugin;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;

public class CatalogReaderTest
extends AbstractCatalogTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CatalogReaderTest(String name) {
        super(name);
    }

    public void testReadCatalog() throws Exception {
        String catalogFile = "/data/catalog1.xml";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogReaderTest.assertNotNull((Object)catalogUrl);
        URL base = FileLocator.resolve((URL)catalogUrl);
        Catalog catalog = (Catalog)this.getCatalog("catalog1", base.toString());
        CatalogReaderTest.assertNotNull((Object)catalog);
        CatalogReaderTest.assertEquals((int)3, (int)catalog.getCatalogEntries().length);
        List entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 2);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        ICatalogEntry entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"InvoiceId_test", (String)entry.getKey());
        CatalogReaderTest.assertEquals((String)"http://webURL", (String)entry.getAttributeValue("webURL"));
        entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 3);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"Invoice.dtd", (String)entry.getKey());
        CatalogReaderTest.assertEquals((String)"yes", (String)entry.getAttributeValue("chached"));
        CatalogReaderTest.assertEquals((String)"value1", (String)entry.getAttributeValue("property"));
        entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 4);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/Invoice/Invoice.dtd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"http://www.test.com/Invoice.dtd", (String)entry.getKey());
        CatalogReaderTest.assertEquals((String)"no", (String)entry.getAttributeValue("chached"));
        CatalogReaderTest.assertEquals((String)"value2", (String)entry.getAttributeValue("property"));
        INextCatalog[] nextCatalogEntries = catalog.getNextCatalogs();
        CatalogReaderTest.assertEquals((int)1, (int)nextCatalogEntries.length);
        INextCatalog nextCatalogEntry = nextCatalogEntries[0];
        CatalogReaderTest.assertNotNull((Object)nextCatalogEntry);
        CatalogReaderTest.assertEquals((String)"catalog2.xml", (String)nextCatalogEntry.getCatalogLocation());
        ICatalog nextCatalog = nextCatalogEntry.getReferencedCatalog();
        CatalogReaderTest.assertNotNull((Object)nextCatalog);
        CatalogReaderTest.assertEquals((int)4, (int)nextCatalog.getCatalogEntries().length);
        entries = CatalogTest.getCatalogEntries(nextCatalog, 2);
        CatalogReaderTest.assertEquals((int)2, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/PublicationCatalogue/Catalogue.xsd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"http://www.eclipse.org/webtools/Catalogue_001", (String)entry.getKey());
        entry = (ICatalogEntry)entries.get(1);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/PublicationCatalogue/Catalogue.xsd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"http://www.eclipse.org/webtools/Catalogue_002", (String)entry.getKey());
        entries = CatalogTest.getCatalogEntries(nextCatalog, 3);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)this.getFileLocation("/data/PublicationCatalogue/Catalogue.xsd"), (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"Catalogue.xsd", (String)entry.getKey());
        entries = CatalogTest.getCatalogEntries(nextCatalog, 4);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)"http://www.eclipse.org/webtools/Catalogue/Catalogue.xsd", (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"http://www.eclipse.org/webtools/Catalogue.xsd", (String)entry.getKey());
    }

    public void testReadComplexCatalog() throws Exception {
        String catalogFile = "/data/delegateAndRewrite/catalog11.xml";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogReaderTest.assertNotNull((Object)catalogUrl);
        URL base = FileLocator.resolve((URL)catalogUrl);
        Catalog catalog = (Catalog)this.getCatalog("catalog11", base.toString());
        CatalogReaderTest.assertNotNull((Object)catalog);
        CatalogReaderTest.assertEquals((int)13, (int)catalog.getCatalogElements().length);
        CatalogReaderTest.assertEquals((int)2, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 2).size());
        CatalogReaderTest.assertEquals((int)2, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 3).size());
        CatalogReaderTest.assertEquals((int)1, (int)CatalogTest.getCatalogEntries((ICatalog)catalog, 4).size());
        INextCatalog[] nextCatalogEntries = catalog.getNextCatalogs();
        CatalogReaderTest.assertEquals((int)1, (int)nextCatalogEntries.length);
        INextCatalog nextCatalogEntry = nextCatalogEntries[0];
        CatalogReaderTest.assertNotNull((Object)nextCatalogEntry);
        CatalogReaderTest.assertEquals((String)"catalog.xml", (String)nextCatalogEntry.getCatalogLocation());
    }

    public void testCompatabilityReader() throws Exception {
        String catalogFile = "/data/compatabilityTest.xmlcatalog";
        URL catalogUrl = TestPlugin.getDefault().getBundle().getEntry(catalogFile);
        CatalogReaderTest.assertNotNull((Object)catalogUrl);
        URL base = FileLocator.resolve((URL)catalogUrl);
        Catalog catalog = (Catalog)this.getCatalog("compatabilityCatalog", base.toString());
        CatalogReaderTest.assertNotNull((Object)catalog);
        List entries = CatalogTest.getCatalogEntries((ICatalog)catalog, 2);
        CatalogReaderTest.assertEquals((int)1, (int)entries.size());
        ICatalogEntry entry = (ICatalogEntry)entries.get(0);
        CatalogReaderTest.assertEquals((String)"platform:/resource/XMLExamples/Invoice2/Invoice.dtd", (String)entry.getURI());
        CatalogReaderTest.assertEquals((String)"InvoiceId", (String)entry.getKey());
    }
}

