	// Validate an integer input value
	
	function validateInteger(validatorId, valueId, minValue, maxValue) {
	
		var validatorElement = document.getElementById(validatorId);	
		
		var valueElement = document.getElementById(valueId);
		var value = Number(valueElement.value);

		// validate the value
		if (isNaN(value) || (value != Math.round(value)) || 
			(minValue > value) || (value > maxValue)) {
			
			validatorElement.innerHTML = 
				"Please enter an integer between " + minValue + 
				" and " + maxValue + "!" ;
			return false;
		}
		
		// the value is valid
		validatorElement.innerHTML = "";
		return true;
	}
	
	function validateGoals(validatorId, goalsId) {
	
		// the number of goals must be an integer between 0 and 99
		return validateInteger(validatorId, goalsId, 0, 99);
	}
	
	function validateVisitor() {
	
		return validateGoals("visitorValidator", "visitorId");
	}
	
	function validateHome() {
	
		return validateGoals("homeValidator", "homeId");
	}

	// Validate all the input fields
	
	function validateFields() {
	
		var visitorValid = validateVisitor();
		var homeValid = validateHome();
		
		return visitorValid && homeValid;
	}
	
	// Submit the score
	
	function submitScore() {
	
		var valid = validateFields();
		if (!valid) {
		
			window.alert(
				"You entered an invalid score.\n" + 
				"Please correct the errors and resubmit.");
		}
		
		return valid;
	}
	
	// Reset the validator messages
	
	function resetValidators() {
	
		document.getElementById("visitorValidator").innerHTML = "";
		document.getElementById("homeValidator").innerHTML = "";
	}
	
