/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.HashMap;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.selection.Selection;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.dali.ui.views.PersistenceView;
import org.eclipse.dali.ui.views.PersistentAttributeComposite;
import org.eclipse.dali.ui.views.PersistentTypeComposite;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Composite;

public class PersistencePropertiesView
extends PersistenceView {
    private static final String NOT_AVAILABLE_LABEL = DaliUiMessages.PersistencePropertiesView_viewNotAvailable;
    private static final EClass PERSISTENT_TYPE_COMPOSITE_KEY = OrmPackage.eINSTANCE.getPersistentType();
    private static final EClass PERSISTENT_ATTRIBUTE_COMPOSITE_KEY = OrmPackage.eINSTANCE.getPersistentAttribute();
    private EditingDomain editingDomain;
    private PersistentTypeComposite persistentTypeComposite;
    private PersistentAttributeComposite persistentAttributeComposite;

    public PersistencePropertiesView() {
        super(NOT_AVAILABLE_LABEL);
    }

    public void subcreatePartControl(Composite parent) {
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)new OrmItemProviderAdapterFactory(), (CommandStack)new BasicCommandStack(), new HashMap());
        this.persistentTypeComposite = new PersistentTypeComposite(this.pageBookManager.getComposite(), this.editingDomain);
        this.pageBookManager.put(PERSISTENT_TYPE_COMPOSITE_KEY, this.persistentTypeComposite);
        this.pageBookManager.deactivate(PERSISTENT_TYPE_COMPOSITE_KEY);
        this.persistentAttributeComposite = new PersistentAttributeComposite(this.pageBookManager.getComposite(), this.editingDomain);
        this.pageBookManager.put(PERSISTENT_ATTRIBUTE_COMPOSITE_KEY, this.persistentAttributeComposite);
        this.pageBookManager.deactivate(PERSISTENT_ATTRIBUTE_COMPOSITE_KEY);
    }

    public Selection getSelection() {
        if (this.pageBookManager.getActive() == this.persistentTypeComposite) {
            return new Selection((PersistenceSourceRefElement)this.persistentTypeComposite.getPersistentType());
        }
        if (this.pageBookManager.getActive() == this.persistentAttributeComposite) {
            return new Selection((PersistenceSourceRefElement)this.persistentAttributeComposite.getPersistentAttribute());
        }
        return Selection.NULL_SELECTION;
    }

    public void select(Selection newSelection) {
        Selection currentSelection = this.getSelection();
        if (newSelection.equals(currentSelection)) {
            return;
        }
        PersistenceSourceRefElement newElement = newSelection.getSelectedElement();
        PersistenceSourceRefElement currentElement = currentSelection.getSelectedElement();
        if (newSelection == Selection.NULL_SELECTION || currentSelection != Selection.NULL_SELECTION && !newElement.eClass().equals(currentElement.eClass())) {
            IPersistenceComposite activeComposite = (IPersistenceComposite)this.pageBookManager.getActive();
            activeComposite.populate(null);
            this.pageBookManager.deactivate(currentElement.eClass());
        }
        if (newSelection != Selection.NULL_SELECTION && (newElement.eClass().equals(PERSISTENT_TYPE_COMPOSITE_KEY) || newElement.eClass().equals(PERSISTENT_ATTRIBUTE_COMPOSITE_KEY))) {
            this.pageBookManager.activate(newElement.eClass());
            ((IPersistenceComposite)this.pageBookManager.getActive()).populate((EObject)newElement);
        }
    }

    public void dispose() {
        this.persistentAttributeComposite.dispose();
        this.persistentTypeComposite.dispose();
        super.dispose();
    }
}

