/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.core.util.jdt.JDTTools;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.ColumnHolder;
import org.eclipse.dali.orm.Insertable;
import org.eclipse.dali.orm.Table;
import org.eclipse.dali.orm.Updatable;
import org.eclipse.dali.orm.adapters.IAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.AbstractJavaColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaAttributeOverrideColumnModelAdapter
extends AbstractJavaColumnModelAdapter {
    public JavaAttributeOverrideColumnModelAdapter(Member member, IColumnModelAdapter.ColumnOwner owner) {
        super(member, owner);
    }

    protected void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedTableName(astRoot);
        this.updatePersInsertable(astRoot);
        this.updatePersUpdatable(astRoot);
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultTableName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        String javaValue = this.javaStringValue(astRoot, "name");
        String persValue = this.column.getSpecifiedName();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.column.setSpecifiedName(javaValue);
        }
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.column.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        String javaValue = this.javaStringValue(astRoot, "table");
        String persValue = this.column.getSpecifiedTableName();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.column.setSpecifiedTableName(javaValue);
        }
    }

    private void updatePersInsertable(CompilationUnit astRoot) {
        Boolean javaBoolean = this.javaBooleanValue(astRoot, "insertable");
        Insertable javaValue = Insertable.DEFAULT_LITERAL;
        if (javaBoolean == Boolean.TRUE) {
            javaValue = Insertable.TRUE_LITERAL;
        } else if (javaBoolean == Boolean.FALSE) {
            javaValue = Insertable.FALSE_LITERAL;
        }
        Insertable persValue = this.column.getInsertable();
        if (javaValue == null && javaValue != persValue || javaValue != null && !((Object)((Object)javaValue)).equals((Object)persValue)) {
            this.column.setInsertable(javaValue);
        }
    }

    private void updatePersUpdatable(CompilationUnit astRoot) {
        Boolean javaBoolean = this.javaBooleanValue(astRoot, "updatable");
        Updatable javaValue = Updatable.DEFAULT_LITERAL;
        if (javaBoolean == Boolean.TRUE) {
            javaValue = Updatable.TRUE_LITERAL;
        } else if (javaBoolean == Boolean.FALSE) {
            javaValue = Updatable.FALSE_LITERAL;
        }
        Updatable persValue = this.column.getUpdatable();
        if (javaValue == null && javaValue != persValue || javaValue != null && !((Object)((Object)javaValue)).equals((Object)persValue)) {
            this.column.setUpdatable(javaValue);
        }
    }

    private String defaultName() {
        ColumnHolder columnMapping = this.attributeOverrideOwner().columnMapping();
        if (columnMapping == null) {
            return this.getAttributeOverride().getName();
        }
        return columnMapping.getColumn().getName();
    }

    private IAttributeOverrideModelAdapter.AttributeOverrideOwner attributeOverrideOwner() {
        return ((IAttributeOverrideModelAdapter)this.getAttributeOverride().getModelAdapter()).getOwner();
    }

    private String defaultTableName() {
        Table table = ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping().getTable();
        if (table == null) {
            return null;
        }
        return table.getName();
    }

    private String javaStringValue(CompilationUnit astRoot, String elementName) {
        MemberValuePair valuePair = this.columnStringValuePair(this.member().bodyDeclaration(astRoot), elementName);
        if (valuePair != null) {
            return ASTTools.stringValue(valuePair);
        }
        return null;
    }

    private Boolean javaBooleanValue(CompilationUnit astRoot, String elementName) {
        MemberValuePair valuePair = this.columnStringValuePair(this.member().bodyDeclaration(astRoot), elementName);
        if (valuePair != null) {
            return ASTTools.booleanValue(valuePair);
        }
        return null;
    }

    private MemberValuePair columnStringValuePair(BodyDeclaration bodyDeclaration, String elementName) {
        Expression columnAnnotation;
        MemberValuePair columnValuePair = this.columnValuePair(bodyDeclaration);
        if (columnValuePair != null && (columnAnnotation = columnValuePair.getValue()).getNodeType() == 77) {
            return ASTTools.memberValuePair((NormalAnnotation)columnAnnotation, elementName);
        }
        return null;
    }

    MemberValuePair columnValuePair(BodyDeclaration bodyDeclaration) {
        Annotation attributeOverrideAnnotation = this.getAttributeOverrideAnnotation(bodyDeclaration);
        if (attributeOverrideAnnotation != null) {
            return ASTTools.memberValuePair(attributeOverrideAnnotation, "column");
        }
        return null;
    }

    Annotation getAttributeOverrideAnnotation(BodyDeclaration bodyDeclaration) {
        return ((JavaAttributeOverrideModelAdapter)this.getAttributeOverride().getModelAdapter()).getAttributeOverrideAnnotation(bodyDeclaration);
    }

    public void specifiedNameChanged() {
        String javaName = this.javaStringValue(this.member().createASTRoot(), "name");
        String persName = this.column.getSpecifiedName();
        if (persName == null && javaName != null) {
            if (this.willBeEmptyAfterRemovingAColumnAnnotationElement()) {
                this.removeAttributeOverrideAnnotation();
            } else {
                this.removeValuePair("name");
            }
        }
        if (persName != null && !persName.equals(javaName)) {
            this.setJavaValue(persName, "name");
        }
    }

    private void removeAttributeOverrideAnnotation() {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation attributeOverrideAnnotation = JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                ASTNode parent = attributeOverrideAnnotation.getParent();
                if (parent instanceof MemberValuePair) {
                    MemberValuePair valuePair = (MemberValuePair)parent;
                    if ((parent = valuePair.getParent()) instanceof NormalAnnotation) {
                        List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                        list.remove(valuePair);
                        if (list.isEmpty()) {
                            ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                        }
                    }
                } else if (parent == bodyDeclaration) {
                    ASTTools.removeAnnotation(bodyDeclaration, attributeOverrideAnnotation);
                } else if (parent instanceof NormalAnnotation) {
                    List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                    }
                } else if (parent instanceof ArrayInitializer) {
                    List list = (List)((ArrayInitializer)parent).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        if ((parent = parent.getParent()).getNodeType() == 80) {
                            parent = parent.getParent();
                        }
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)parent);
                    }
                }
            }
        });
    }

    private void removeValuePair(final String elementName) {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair columnValuePair = JavaAttributeOverrideColumnModelAdapter.this.columnValuePair(bodyDeclaration);
                NormalAnnotation normalAnnotation = (NormalAnnotation)columnValuePair.getValue();
                ASTTools.removeValuePair(normalAnnotation, elementName);
            }
        });
    }

    private void setJavaValue(final String javaValue, final String elementName) {
        this.addApproriateAttributeOverrideAnnotation();
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair columnValuePair = JavaAttributeOverrideColumnModelAdapter.this.columnValuePair(bodyDeclaration);
                Expression columnAnnotation = columnValuePair.getValue();
                MemberValuePair columnNameValuePair = ASTTools.memberValuePair((Annotation)columnAnnotation, elementName);
                if (columnNameValuePair == null) {
                    columnNameValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnNameValuePair.setName(bodyDeclaration.getAST().newSimpleName(elementName));
                    ASTTools.addValuePair((NormalAnnotation)columnAnnotation, columnNameValuePair);
                }
                columnNameValuePair.setValue((Expression)ASTTools.newStringLiteral(bodyDeclaration.getAST(), javaValue));
            }
        });
    }

    private void setJavaValue(final boolean javaValue, final String elementName) {
        this.addApproriateAttributeOverrideAnnotation();
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair columnValuePair = JavaAttributeOverrideColumnModelAdapter.this.columnValuePair(bodyDeclaration);
                Expression columnAnnotation = columnValuePair.getValue();
                MemberValuePair columnNameValuePair = ASTTools.memberValuePair((Annotation)columnAnnotation, elementName);
                if (columnNameValuePair == null) {
                    columnNameValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnNameValuePair.setName(bodyDeclaration.getAST().newSimpleName(elementName));
                    ASTTools.addValuePair((NormalAnnotation)columnAnnotation, columnNameValuePair);
                }
                columnNameValuePair.setValue((Expression)ASTTools.newBooleanLiteral(bodyDeclaration.getAST(), javaValue));
            }
        });
    }

    private void addApproriateAttributeOverrideAnnotation() {
        BodyDeclaration bodyDeclaration = this.member().bodyDeclaration();
        MemberValuePair columnValuePair = this.columnValuePair(bodyDeclaration);
        if (columnValuePair == null) {
            NormalAnnotation attributeOverrideAnnotation = (NormalAnnotation)this.getAttributeOverrideAnnotation(bodyDeclaration);
            if (attributeOverrideAnnotation == null) {
                Annotation existingAnnotation = ASTTools.annotation(bodyDeclaration, "AttributeOverride");
                if (existingAnnotation != null) {
                    JDTTools.addImport(this.member().getJDTMember().getCompilationUnit(), "javax.persistence.AttributeOverrides");
                    this.addAttributeOverridesAnnotation();
                } else {
                    existingAnnotation = ASTTools.annotation(bodyDeclaration, "AttributeOverrides");
                    if (existingAnnotation != null) {
                        this.addAttributeOverrideAnnotationToExistingAnnotation();
                    } else {
                        JDTTools.addImport(this.member().getJDTMember().getCompilationUnit(), "javax.persistence.AttributeOverride");
                        this.addAttributeOverrideAnnotation();
                    }
                }
            }
            JDTTools.addImport(this.member().getJDTMember().getCompilationUnit(), "javax.persistence.Column");
            this.member().editAnnotation(new Member.IAnnotationEditor(){

                public void edit(BodyDeclaration bodyDeclaration) {
                    NormalAnnotation attributeOverrideAnnotation = (NormalAnnotation)JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                    MemberValuePair columnValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnValuePair.setName(bodyDeclaration.getAST().newSimpleName("column"));
                    ASTTools.addValuePair(attributeOverrideAnnotation, columnValuePair);
                    NormalAnnotation columnAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "Column");
                    columnValuePair.setValue((Expression)columnAnnotation);
                }
            });
        }
    }

    private void addAttributeOverridesAnnotation() {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                Annotation existingAnnotation = ASTTools.annotation(bodyDeclaration, "AttributeOverride");
                NormalAnnotation attributeOverrideAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "AttributeOverride");
                ASTTools.addLiteralMemberValuePair(attributeOverrideAnnotation, "name", JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverride().getName());
                SingleMemberAnnotation overridesAnnotation = ASTTools.newSingleMemberAnnotation(ast, "AttributeOverrides");
                ArrayInitializer array = ast.newArrayInitializer();
                List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                ASTTools.removeAnnotation(bodyDeclaration, existingAnnotation);
                list.add(existingAnnotation);
                list.add(attributeOverrideAnnotation);
                overridesAnnotation.setValue((Expression)array);
                ASTTools.addAnnotation(bodyDeclaration, (Annotation)overridesAnnotation);
            }
        });
    }

    private void addAttributeOverrideAnnotationToExistingAnnotation() {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                AST ast = bodyDeclaration.getAST();
                Annotation existingAnnotation = ASTTools.annotation(bodyDeclaration, "AttributeOverride");
                NormalAnnotation attributeOverrideAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "AttributeOverride");
                ASTTools.addLiteralMemberValuePair(attributeOverrideAnnotation, "name", JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverride().getName());
                if (existingAnnotation.isSingleMemberAnnotation()) {
                    Expression expression = ((SingleMemberAnnotation)existingAnnotation).getValue();
                    if (expression.getNodeType() == 4) {
                        ((List)((ArrayInitializer)expression).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                    } else {
                        ArrayInitializer array = ast.newArrayInitializer();
                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                        ((SingleMemberAnnotation)existingAnnotation).setValue((Expression)array);
                        list.add(expression);
                        list.add(attributeOverrideAnnotation);
                    }
                } else if (existingAnnotation.isNormalAnnotation()) {
                    Expression existingValue;
                    MemberValuePair valuePair = ASTTools.memberValuePair((NormalAnnotation)existingAnnotation, "value");
                    if (valuePair == null) {
                        valuePair = ast.newMemberValuePair();
                        valuePair.setName(ast.newSimpleName("value"));
                        ASTTools.addValuePair((NormalAnnotation)existingAnnotation, valuePair);
                    }
                    if ((existingValue = valuePair.getValue()) != null && existingValue.getNodeType() == 4) {
                        ((List)((ArrayInitializer)existingValue).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                    } else {
                        ArrayInitializer array = ast.newArrayInitializer();
                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                        valuePair.setValue((Expression)array);
                        if (existingValue != null) {
                            list.add(existingValue);
                        }
                        list.add(attributeOverrideAnnotation);
                    }
                }
            }
        });
    }

    private void addAttributeOverrideAnnotation() {
        this.member().editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                NormalAnnotation attributeOverrideAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "AttributeOverride");
                ASTTools.addLiteralMemberValuePair(attributeOverrideAnnotation, "name", JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverride().getName());
                ASTTools.addAnnotation(bodyDeclaration, (Annotation)attributeOverrideAnnotation);
            }
        });
    }

    public void specifiedTableNameChanged() {
        String javaName = this.javaStringValue(this.member().createASTRoot(), "table");
        String persName = this.column.getSpecifiedTableName();
        if (persName == null && javaName != null) {
            if (this.willBeEmptyAfterRemovingAColumnAnnotationElement()) {
                this.removeAttributeOverrideAnnotation();
                return;
            }
            this.removeValuePair("table");
            return;
        }
        if (persName != null && !persName.equals(javaName)) {
            this.setJavaValue(persName, "table");
        }
    }

    private boolean willBeEmptyAfterRemovingAColumnAnnotationElement() {
        MemberValuePair columnValuePair = this.columnValuePair(this.member().bodyDeclaration());
        if (columnValuePair == null) {
            return true;
        }
        Expression columnExpression = columnValuePair.getValue();
        if (columnExpression == null) {
            return true;
        }
        return columnExpression.getNodeType() != 77 || columnExpression.getNodeType() != 77 || ((NormalAnnotation)columnExpression).values().size() <= 1;
    }

    public void insertableChanged() {
        Boolean javaInsertableBoolean = this.javaBooleanValue(this.member().createASTRoot(), "insertable");
        Insertable javaInsertable = Insertable.DEFAULT_LITERAL;
        if (javaInsertableBoolean == Boolean.TRUE) {
            javaInsertable = Insertable.TRUE_LITERAL;
        } else if (javaInsertableBoolean == Boolean.FALSE) {
            javaInsertable = Insertable.FALSE_LITERAL;
        }
        Insertable persInsertable = this.column.getInsertable();
        if (persInsertable == Insertable.DEFAULT_LITERAL && javaInsertable != Insertable.DEFAULT_LITERAL) {
            if (this.willBeEmptyAfterRemovingAColumnAnnotationElement()) {
                this.removeAttributeOverrideAnnotation();
                return;
            }
            this.removeValuePair("insertable");
            return;
        }
        if (persInsertable != null && persInsertable != javaInsertable) {
            if (persInsertable == Insertable.FALSE_LITERAL) {
                this.setJavaValue(false, "insertable");
            } else {
                this.setJavaValue(true, "insertable");
            }
        }
    }

    public void updatableChanged() {
        Boolean javaUpdatableBoolean = this.javaBooleanValue(this.member().createASTRoot(), "updatable");
        Updatable javaUpdatable = Updatable.DEFAULT_LITERAL;
        if (javaUpdatableBoolean == Boolean.TRUE) {
            javaUpdatable = Updatable.TRUE_LITERAL;
        } else if (javaUpdatableBoolean == Boolean.FALSE) {
            javaUpdatable = Updatable.FALSE_LITERAL;
        }
        Updatable persUpdatable = this.column.getUpdatable();
        if (persUpdatable == Updatable.DEFAULT_LITERAL && javaUpdatable != Updatable.DEFAULT_LITERAL) {
            if (this.willBeEmptyAfterRemovingAColumnAnnotationElement()) {
                this.removeAttributeOverrideAnnotation();
                return;
            }
            this.removeValuePair("updatable");
            return;
        }
        if (persUpdatable != null && persUpdatable != javaUpdatable) {
            if (persUpdatable == Updatable.FALSE_LITERAL) {
                this.setJavaValue(false, "updatable");
            } else {
                this.setJavaValue(true, "updatable");
            }
        }
    }

    AttributeOverride getAttributeOverride() {
        return (AttributeOverride)this.column.getParent();
    }

    public ITextRange getTextRange() {
        MemberValuePair valuePair = this.columnValuePair(this.member().bodyDeclaration());
        if (valuePair != null) {
            return ASTTools.textRange((ASTNode)valuePair);
        }
        return this.getAttributeOverride().getTextRange();
    }

    public ITextRange nameTextRange() {
        MemberValuePair valuePair = this.columnStringValuePair(this.member().bodyDeclaration(), "name");
        if (valuePair != null) {
            return ASTTools.textRange((ASTNode)valuePair);
        }
        return this.getTextRange();
    }

    public ITextRange tableNameTextRange() {
        MemberValuePair valuePair = this.columnStringValuePair(this.member().bodyDeclaration(), "table");
        if (valuePair != null) {
            return ASTTools.textRange((ASTNode)valuePair);
        }
        return this.getTextRange();
    }
}

