/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.util.Iterator;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.JoinColumn;
import org.eclipse.dali.orm.JoinTable;
import org.eclipse.dali.orm.MultiRelationshipMapping;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.JoinColumnInJoinTableDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;

public class InverseJoinColumnDialog
extends JoinColumnInJoinTableDialog {
    InverseJoinColumnDialog(Shell parent, JoinTable joinTable) {
        super(parent, joinTable);
    }

    InverseJoinColumnDialog(Shell parent, JoinColumn joinColumn) {
        super(parent, joinColumn);
    }

    protected String getTitle() {
        return DaliUiMessages.InverseJoinColumnDialog_editInverseJoinColumn;
    }

    protected void populateNameCombo(Combo nameCombo) {
        if (this.getJoinColumn() == null) {
            return;
        }
        nameCombo.add(NLS.bind((String)DaliUiMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultName()));
        Table joinDBTable = ((JoinTable)this.getJoinColumn().getParent()).getDBTable();
        if (joinDBTable != null) {
            Iterator i = joinDBTable.columnNames();
            while (i.hasNext()) {
                nameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            nameCombo.setText(this.getJoinColumn().getSpecifiedName());
        } else {
            nameCombo.select(0);
        }
    }

    protected void populateReferencedNameCombo(Combo referencedColumnNameCombo) {
        Table referencedDbTable;
        if (this.getJoinColumn() == null) {
            return;
        }
        referencedColumnNameCombo.add(NLS.bind((String)DaliUiMessages.InverseJoinColumnDialog_defaultWithOneParam, (Object)this.getJoinColumn().getDefaultReferencedColumnName()));
        MultiRelationshipMapping multiRelationshipMapping = (MultiRelationshipMapping)((JoinTable)this.getJoinColumn().getParent()).getParent();
        Entity targetEntity = multiRelationshipMapping.getResolvedTargetEntity();
        if (targetEntity != null && (referencedDbTable = targetEntity.getResolvedDBTable()) != null) {
            Iterator i = referencedDbTable.columnNames();
            while (i.hasNext()) {
                referencedColumnNameCombo.add((String)i.next());
            }
        }
        if (this.getJoinColumn().getSpecifiedReferencedColumnName() != null) {
            referencedColumnNameCombo.setText(this.getJoinColumn().getSpecifiedReferencedColumnName());
        } else {
            referencedColumnNameCombo.select(0);
        }
    }
}

