/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;
import org.eclipse.dali.internal.utility.iterators.SingleElementIterator;

public class CompositeIterator
implements Iterator {
    private final Iterator iterators;
    private Iterator currentIterator;
    private Iterator lastIteratorToReturnNext;

    public CompositeIterator(Collection iterators) {
        this(iterators.iterator());
    }

    public CompositeIterator(Iterator iterators) {
        this.iterators = iterators;
    }

    public CompositeIterator(Object object, Iterator iterator) {
        this((Iterator)new SingleElementIterator(object), iterator);
    }

    public CompositeIterator(Iterator iterator, Object object) {
        this(iterator, (Iterator)new SingleElementIterator(object));
    }

    public CompositeIterator(Iterator iterator1, Iterator iterator2) {
        this(new ArrayIterator(new Object[]{iterator1, iterator2}));
    }

    public CompositeIterator(Iterator iterator1, Iterator iterator2, Iterator iterator3) {
        this(new ArrayIterator(new Object[]{iterator1, iterator2, iterator3}));
    }

    public CompositeIterator(Iterator[] iterators) {
        this(new ArrayIterator(iterators));
    }

    public boolean hasNext() {
        try {
            this.loadCurrentIterator();
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.loadCurrentIterator();
        Object result = this.currentIterator.next();
        this.lastIteratorToReturnNext = this.currentIterator;
        return result;
    }

    public void remove() {
        if (this.lastIteratorToReturnNext == null) {
            throw new IllegalStateException();
        }
        this.lastIteratorToReturnNext.remove();
    }

    private void loadCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = (Iterator)this.iterators.next();
        }
        while (!this.currentIterator.hasNext() && this.iterators.hasNext()) {
            this.currentIterator = (Iterator)this.iterators.next();
        }
    }

    public String toString() {
        return String.valueOf(ClassTools.shortClassNameForObject(this)) + '(' + this.iterators + ')';
    }
}

